/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Collections;
import java.util.Set;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

@ThreadSafe
public abstract class AbstractAuthorityFactory
extends ReferencingFactory
implements AuthorityFactory {
    protected final NameFactory nameFactory;

    AbstractAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory) {
        this.nameFactory = abstractAuthorityFactory.nameFactory;
    }

    protected AbstractAuthorityFactory(Hints hints) {
        this.nameFactory = FactoryFinder.getNameFactory(hints);
        this.hints.put(Hints.NAME_FACTORY, this.nameFactory);
    }

    boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        return authorityFactory == this;
    }

    @Override
    public abstract Citation getAuthority();

    static Citation getAuthority(Class<? extends AuthorityFactory> clazz) {
        String string;
        if (clazz != null && (string = clazz.getName()).contains(".epsg.")) {
            return Citations.EPSG;
        }
        return Citations.UNKNOWN;
    }

    Citation getCitation(String string) {
        if (string.equals("getAuthority")) {
            return AbstractAuthorityFactory.getAuthority(this.getClass());
        }
        if (string.equals("getVendor")) {
            return Citations.UNKNOWN;
        }
        throw new IllegalArgumentException(string);
    }

    static Citation getCitation(AuthorityFactory authorityFactory, String string) {
        if (string.equals("getAuthority")) {
            return authorityFactory.getAuthority();
        }
        if (string.equals("getVendor")) {
            return authorityFactory.getVendor();
        }
        throw new IllegalArgumentException(string);
    }

    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    @Override
    public IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractAuthorityFactory.ensureNonNull("code", string);
        throw this.noSuchAuthorityCode(IdentifiedObject.class, string);
    }

    public Datum createDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (Datum)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(Datum.class, string, classCastException);
        }
    }

    public EngineeringDatum createEngineeringDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(string);
        try {
            return (EngineeringDatum)datum;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(EngineeringDatum.class, string, classCastException);
        }
    }

    public ImageDatum createImageDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(string);
        try {
            return (ImageDatum)datum;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(ImageDatum.class, string, classCastException);
        }
    }

    public VerticalDatum createVerticalDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(string);
        try {
            return (VerticalDatum)datum;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(VerticalDatum.class, string, classCastException);
        }
    }

    public TemporalDatum createTemporalDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(string);
        try {
            return (TemporalDatum)datum;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(TemporalDatum.class, string, classCastException);
        }
    }

    public GeodeticDatum createGeodeticDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(string);
        try {
            return (GeodeticDatum)datum;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(GeodeticDatum.class, string, classCastException);
        }
    }

    public Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (Ellipsoid)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, string, classCastException);
        }
    }

    public PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (PrimeMeridian)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, string, classCastException);
        }
    }

    public Extent createExtent(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (Extent)((Object)identifiedObject);
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(Extent.class, string, classCastException);
        }
    }

    public CoordinateSystem createCoordinateSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (CoordinateSystem)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, string, classCastException);
        }
    }

    public CartesianCS createCartesianCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (CartesianCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CartesianCS.class, string, classCastException);
        }
    }

    public PolarCS createPolarCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (PolarCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(PolarCS.class, string, classCastException);
        }
    }

    public CylindricalCS createCylindricalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (CylindricalCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CylindricalCS.class, string, classCastException);
        }
    }

    public SphericalCS createSphericalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (SphericalCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(SphericalCS.class, string, classCastException);
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (EllipsoidalCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(EllipsoidalCS.class, string, classCastException);
        }
    }

    public VerticalCS createVerticalCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (VerticalCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(VerticalCS.class, string, classCastException);
        }
    }

    public TimeCS createTimeCS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem coordinateSystem = this.createCoordinateSystem(string);
        try {
            return (TimeCS)coordinateSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(TimeCS.class, string, classCastException);
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (CoordinateSystemAxis)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, string, classCastException);
        }
    }

    public Unit<?> createUnit(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (Unit)((Object)identifiedObject);
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(Unit.class, string, classCastException);
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (CoordinateReferenceSystem)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string, classCastException);
        }
    }

    public CompoundCRS createCompoundCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (CompoundCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CompoundCRS.class, string, classCastException);
        }
    }

    public DerivedCRS createDerivedCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (DerivedCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(DerivedCRS.class, string, classCastException);
        }
    }

    public EngineeringCRS createEngineeringCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (EngineeringCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(EngineeringCRS.class, string, classCastException);
        }
    }

    public GeographicCRS createGeographicCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (GeographicCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(GeographicCRS.class, string, classCastException);
        }
    }

    public GeocentricCRS createGeocentricCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (GeocentricCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(GeocentricCRS.class, string, classCastException);
        }
    }

    public ImageCRS createImageCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (ImageCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(ImageCRS.class, string, classCastException);
        }
    }

    public ProjectedCRS createProjectedCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (ProjectedCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(ProjectedCRS.class, string, classCastException);
        }
    }

    public TemporalCRS createTemporalCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(TemporalCRS.class, string, classCastException);
        }
    }

    public VerticalCRS createVerticalCRS(String string) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.createCoordinateReferenceSystem(string);
        try {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(VerticalCRS.class, string, classCastException);
        }
    }

    public ParameterDescriptor<?> createParameterDescriptor(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (ParameterDescriptor)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(ParameterDescriptor.class, string, classCastException);
        }
    }

    public OperationMethod createOperationMethod(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (OperationMethod)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(OperationMethod.class, string, classCastException);
        }
    }

    public CoordinateOperation createCoordinateOperation(String string) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject identifiedObject = this.createObject(string);
        try {
            return (CoordinateOperation)identifiedObject;
        }
        catch (ClassCastException classCastException) {
            throw this.noSuchAuthorityCode(CoordinateOperation.class, string, classCastException);
        }
    }

    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws NoSuchAuthorityCodeException, FactoryException {
        return Collections.emptySet();
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new IdentifiedObjectFinder(this, clazz);
    }

    @Override
    protected void dispose(boolean bl) {
        super.dispose(bl);
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> clazz, String string, ClassCastException classCastException) {
        NoSuchAuthorityCodeException noSuchAuthorityCodeException = this.noSuchAuthorityCode(clazz, string);
        noSuchAuthorityCodeException.initCause(classCastException);
        return noSuchAuthorityCodeException;
    }

    protected String trimAuthority(String string) {
        GenericName genericName = this.nameFactory.parseGenericName(null, string = string.trim());
        if (genericName instanceof ScopedName) {
            GenericName genericName2 = ((ScopedName)genericName).path();
            if (Citations.identifierMatches(this.getAuthority(), ((Object)genericName2).toString())) {
                return ((Object)genericName.tip()).toString().trim();
            }
        }
        return string;
    }

    protected final NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> clazz, String string) {
        InternationalString internationalString = this.getAuthority().getTitle();
        return new NoSuchAuthorityCodeException(Errors.format(165, string, internationalString, clazz), ((Object)internationalString).toString(), this.trimAuthority(string), string);
    }
}

