/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.naming.DefaultNameFactory;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.factory.ReferencingObjectFactory;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.XArrays;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

@ThreadSafe
public class DatumAliases
extends ReferencingFactory
implements DatumFactory {
    private static final String ALIAS_TABLE = "DatumAliasesTable.csv";
    private static final String SEPARATORS = ";";
    private static final Object[] NEED_LOADING = new Object[0];
    private final URL aliasURL;
    private final Map<String, Object[]> aliasMap = new HashMap<String, Object[]>();
    private Citation[] authorities;
    private transient DefaultNameFactory nameFactory;
    private DatumFactory datumFactory;

    public DatumAliases() {
        this.aliasURL = DatumAliases.class.getResource(ALIAS_TABLE);
        if (this.aliasURL == null) {
            throw new NoSuchElementException(ALIAS_TABLE);
        }
    }

    public DatumAliases(DatumFactory datumFactory) {
        this();
        this.datumFactory = datumFactory;
        DatumAliases.ensureNonNull("factory", datumFactory);
    }

    public DatumAliases(DatumFactory datumFactory, URL uRL) {
        DatumAliases.ensureNonNull("factory", datumFactory);
        DatumAliases.ensureNonNull("aliasURL", uRL);
        this.aliasURL = uRL;
        this.datumFactory = datumFactory;
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.before(ReferencingObjectFactory.class, false);
    }

    private synchronized DefaultNameFactory getNameFactory() {
        if (this.nameFactory == null) {
            this.nameFactory = (DefaultNameFactory)FactoryFinder.getNameFactory(new Hints(Hints.NAME_FACTORY, DefaultNameFactory.class));
        }
        return this.nameFactory;
    }

    final synchronized DatumFactory getDatumFactory() throws NoSuchElementException {
        if (this.datumFactory == null) {
            DatumFactory datumFactory;
            Iterator<DatumFactory> iterator = FactoryFinder.getDatumFactories(null).iterator();
            while ((datumFactory = iterator.next()) == this) {
            }
            this.datumFactory = datumFactory;
        }
        return this.datumFactory;
    }

    private static String toCaseless(String string) {
        return string.replace('_', ' ').trim().toLowerCase();
    }

    private static String readLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && ((string = string.trim()).isEmpty() || string.charAt(0) == '#')) {
        }
        return string;
    }

    private void reload() throws IOException {
        String string;
        Serializable serializable;
        Object object;
        assert (Thread.holdsLock(this));
        if (LOGGER.isLoggable(Level.CONFIG)) {
            object = this.aliasURL.getPath();
            int n = ((String)object).indexOf(33);
            if (n >= 1) {
                object = ((String)object).substring(0, n);
            }
            serializable = Loggings.format(Level.CONFIG, 32, object);
            ((LogRecord)serializable).setLoggerName(LOGGER.getName());
            LOGGER.log((LogRecord)serializable);
        }
        if ((string = DatumAliases.readLine((BufferedReader)(object = new BufferedReader(new InputStreamReader(this.aliasURL.openStream()))))) != null) {
            Object object2;
            serializable = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATORS);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken().trim();
                Citation citation = Citations.fromName((String)object2);
                serializable.add(citation);
            }
            this.authorities = serializable.toArray(new Citation[serializable.size()]);
            object2 = new HashMap();
            while ((string = DatumAliases.readLine((BufferedReader)object)) != null) {
                serializable.clear();
                object2.clear();
                stringTokenizer = new StringTokenizer(string, SEPARATORS);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!string2.isEmpty()) {
                        String string3 = object2.put(string2, string2);
                        if (string3 != null) {
                            object2.put(string3, string3);
                            string2 = string3;
                        }
                    } else {
                        string2 = null;
                    }
                    serializable.add(string2);
                }
                int n = serializable.size();
                while (--n >= 0 && serializable.get(n) == null) {
                    serializable.remove(n);
                }
                if (serializable.isEmpty()) continue;
                Object[] objectArray = serializable.toArray(new String[serializable.size()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = objectArray[i];
                    String string5 = DatumAliases.toCaseless(string4);
                    Object[] objectArray2 = this.aliasMap.put(string5, objectArray);
                    if (objectArray2 == null || objectArray2 == NEED_LOADING) continue;
                    if (objectArray2 instanceof GenericName[]) {
                        this.aliasMap.put(string5, objectArray2);
                        continue;
                    }
                    if (Arrays.equals(objectArray2, objectArray)) continue;
                    LOGGER.log(Level.WARNING, "Inconsistent aliases for datum \"{0}\".", string4);
                }
            }
        }
        ((BufferedReader)object).close();
        Threads.executeDisposal(new Runnable(){

            @Override
            public void run() {
                DatumAliases.this.freeUnused();
            }
        }, 10000L);
    }

    private void log(IOException iOException) {
        LogRecord logRecord = Loggings.format(Level.WARNING, 11, this.aliasURL);
        logRecord.setSourceClassName(DatumAliases.class.getName());
        logRecord.setSourceMethodName("reload");
        logRecord.setThrown(iOException);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private synchronized GenericName[] getAliases(String string) {
        Object[] objectArray;
        String string2;
        int n;
        Object[] objectArray2;
        if (this.aliasMap.isEmpty()) {
            try {
                this.reload();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
        if ((objectArray2 = this.aliasMap.get(string = DatumAliases.toCaseless(string))) == null) {
            return null;
        }
        if (objectArray2 == NEED_LOADING) {
            try {
                this.reload();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
            objectArray2 = this.aliasMap.get(string);
            if (objectArray2 == NEED_LOADING) {
                return null;
            }
        }
        if (objectArray2 instanceof GenericName[]) {
            return (GenericName[])objectArray2;
        }
        int n2 = 0;
        GenericName[] genericNameArray = new GenericName[objectArray2.length];
        for (n = 0; n < objectArray2.length; ++n) {
            string2 = (String)objectArray2[n];
            if (string2 == null) continue;
            objectArray = null;
            if (n2 < this.authorities.length) {
                objectArray = this.authorities[n2];
            }
            genericNameArray[n2++] = new NamedIdentifier((Citation)objectArray, string2);
        }
        genericNameArray = XArrays.resize(genericNameArray, n2);
        for (n = 0; n < genericNameArray.length; ++n) {
            string2 = ((Object)genericNameArray[n].tip()).toString();
            objectArray = this.aliasMap.put(DatumAliases.toCaseless(string2), genericNameArray);
            assert (objectArray == genericNameArray || Arrays.equals(objectArray2, objectArray)) : string2;
        }
        return genericNameArray;
    }

    private Map<String, ?> addAliases(Map<String, ?> map) {
        DatumAliases.ensureNonNull("properties", map);
        Object obj = map.get("name");
        DatumAliases.ensureNonNull("name", obj);
        String string = obj instanceof Identifier ? ((Identifier)obj).getCode() : obj.toString();
        GenericName[] genericNameArray = this.getAliases(string);
        if (genericNameArray != null) {
            LinkedHashMap<String, GenericName> linkedHashMap;
            int n = genericNameArray.length;
            obj = map.get("alias");
            if (obj != null) {
                linkedHashMap = new LinkedHashMap();
                DatumAliases.putAll(this.getNameFactory().toArray(obj), linkedHashMap);
                n -= DatumAliases.putAll(genericNameArray, linkedHashMap);
                Collection collection = linkedHashMap.values();
                genericNameArray = collection.toArray(new GenericName[collection.size()]);
            }
            if (n > 0) {
                linkedHashMap = new HashMap(map);
                linkedHashMap.put("alias", (GenericName)genericNameArray);
                map = linkedHashMap;
            }
        }
        return map;
    }

    private static int putAll(GenericName[] genericNameArray, Map<String, GenericName> map) {
        int n = 0;
        for (int i = 0; i < genericNameArray.length; ++i) {
            GenericName genericName = genericNameArray[i];
            GenericName genericName2 = genericName.toFullyQualifiedName();
            String string = DatumAliases.toCaseless(((Object)genericName2).toString());
            GenericName genericName3 = map.put(string, genericName);
            if (!(genericName3 instanceof ScopedName)) continue;
            map.put(string, genericName3);
            ++n;
        }
        return n;
    }

    @Override
    public EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        return this.getDatumFactory().createEngineeringDatum(this.addAliases(map));
    }

    @Override
    public GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        return this.getDatumFactory().createGeodeticDatum(this.addAliases(map), ellipsoid, primeMeridian);
    }

    @Override
    public ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        return this.getDatumFactory().createImageDatum(this.addAliases(map), pixelInCell);
    }

    @Override
    public TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        return this.getDatumFactory().createTemporalDatum(this.addAliases(map), date);
    }

    @Override
    public VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        return this.getDatumFactory().createVerticalDatum(this.addAliases(map), verticalDatumType);
    }

    @Override
    public Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createEllipsoid(map, d, d2, unit);
    }

    @Override
    public Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createFlattenedSphere(map, d, d2, unit);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        return this.getDatumFactory().createPrimeMeridian(map, d, unit);
    }

    final synchronized void freeUnused() {
        for (Map.Entry<String, Object[]> entry : this.aliasMap.entrySet()) {
            Object[] objectArray = entry.getValue();
            if (objectArray instanceof GenericName[]) continue;
            entry.setValue(NEED_LOADING);
        }
    }
}

