/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Collection;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.collection.CheckedHashSet;

public abstract class NotifiedCheckedSet<E>
extends CheckedHashSet<E> {
    public NotifiedCheckedSet(Class<E> type) {
        super(type);
    }

    public NotifiedCheckedSet(Class<E> type, int capacity) {
        super(type, capacity);
    }

    protected abstract void notifyAdd(E var1, NumberRange<Integer> var2);

    protected abstract void notifyAdd(Collection<? extends E> var1, NumberRange<Integer> var2);

    protected abstract void notifyRemove(E var1, NumberRange<Integer> var2);

    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        if (element == null) {
            return false;
        }
        boolean added = super.add(element);
        if (added) {
            this.notifyAdd(element, null);
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyAdd(collection, (NumberRange<Integer>)null);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        boolean removed = super.remove(o);
        if (removed) {
            this.notifyRemove(super.getElementType().cast(o), null);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        boolean valid = false;
        for (Object i : c) {
            boolean val = this.remove(i);
            if (!val) continue;
            valid = val;
        }
        return valid;
    }
}

