/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.IdentityConverter;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.ObjectConverter;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
final class CharSequenceConverter<T>
extends SimpleConverter<CharSequence, T>
implements Serializable {
    private static final long serialVersionUID = 2591675151163578878L;
    static final CharSequenceConverter<String> STRING = new CharSequenceConverter<String>(String.class, IdentityConverter.STRING);
    private final Class<T> targetType;
    private final ObjectConverter<? super String, ? extends T> next;

    private CharSequenceConverter(Class<T> clazz, ObjectConverter<? super String, ? extends T> objectConverter) {
        this.targetType = clazz;
        this.next = objectConverter;
    }

    public static <T> ObjectConverter<? super CharSequence, T> create(Class<T> clazz, ObjectConverter<? super String, ? extends T> objectConverter) {
        assert (clazz.isAssignableFrom(objectConverter.getTargetClass()));
        if (objectConverter.getSourceClass().isAssignableFrom(CharSequence.class)) {
            return objectConverter;
        }
        return new CharSequenceConverter<T>(clazz, objectConverter);
    }

    @Override
    public final Class<CharSequence> getSourceClass() {
        return CharSequence.class;
    }

    @Override
    public final Class<T> getTargetClass() {
        return this.targetType;
    }

    @Override
    public T convert(CharSequence charSequence) throws NonconvertibleObjectException {
        if (this.targetType.isInstance(charSequence)) {
            return this.targetType.cast(charSequence);
        }
        return this.next.convert(charSequence != null ? ((Object)charSequence).toString() : null);
    }
}

