/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.util.NamespaceBindings;
import org.opengis.cite.cat30.util.Records;
import org.opengis.cite.cat30.util.SpatialUtils;
import org.opengis.cite.cat30.util.URIUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.SpatialAssert;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.geometry.Envelope;
import org.opengis.util.FactoryException;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getPackage().getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals(node.getLocalName(), qName.getLocalPart(), ErrorMessage.get("LocalName"));
        String nsName = null != node.getNamespaceURI() ? node.getNamespaceURI() : "";
        Assert.assertEquals(nsName, qName.getNamespaceURI(), ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Element elemNode = Document.class.isInstance(context) ? ((Document)Document.class.cast(context)).getDocumentElement() : (Element)context;
        Assert.assertTrue(result, ErrorMessage.format("XPathResult", elemNode.getNodeName(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(source);
        }
        catch (IOException | SAXException e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator(new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = (DOMResult)validator.validate(xmlSource);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals(features.getLength(), expectedCount, String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertExceptionReport(ClientResponse rsp, String exceptionCode, String locator) {
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.BAD_REQUEST.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document doc = null;
        try {
            doc = rsp.getEntity(Document.class);
        }
        catch (RuntimeException ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed to parse response entity. ");
            msg.append(ex.getMessage()).append('\n');
            byte[] body = rsp.getEntity(byte[].class);
            msg.append(new String(body, StandardCharsets.US_ASCII));
            throw new AssertionError(msg);
        }
        String expr = String.format("//ows:Exception[@exceptionCode = '%s']", exceptionCode);
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(doc, expr, null);
        }
        catch (XPathExpressionException body) {
            // empty catch block
        }
        Assert.assertTrue(nodeList.getLength() > 0, "Expected exception not found in response: " + expr);
        if (null != locator && !locator.isEmpty()) {
            Element exception = (Element)nodeList.item(0);
            String locatorValue = exception.getAttribute("locator").toLowerCase();
            Assert.assertTrue(locatorValue.contains(locator.toLowerCase()), String.format("Expected locator attribute to contain '%s']", locator));
        }
    }

    public static void assertEnvelopeIntersectsBoundingBoxes(Envelope bbox, Source results) {
        NodeList boxNodeList = null;
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.georss.org/georss/10", "georss");
        nsBindings.put("http://www.opengis.net/gml", "gml31");
        try {
            boxNodeList = (NodeList)XMLUtils.evaluateXPath(results, "//ows:BoundingBox | //ows:WGS84BoundingBox | //georss:box | //gml31:Envelope", nsBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertTrue(boxNodeList.getLength() > 0, "No bounding box representations (ows:BoundingBox, ows:WGS84BoundingBox, georss:box, gml31:Envelope) found in results.");
        for (int i = 0; i < boxNodeList.getLength(); ++i) {
            Node bboxNode = boxNodeList.item(i);
            if (bboxNode.getNamespaceURI().equals("http://www.opengis.net/gml")) {
                bboxNode = SpatialUtils.createGML32Envelope(bboxNode);
            }
            try {
                Envelope envelope = bboxNode.getNamespaceURI().equals("http://www.georss.org/georss/10") ? SpatialUtils.envelopeFromSimpleGeoRSSBox(bboxNode) : Extents.createEnvelope(bboxNode);
                SpatialAssert.assertIntersects(bbox, envelope);
                continue;
            }
            catch (FactoryException fex) {
                StringBuilder msg = new StringBuilder("Failed to create envelope from bounding box in result set:\n");
                msg.append(XMLUtils.writeNodeToString(bboxNode));
                throw new AssertionError(msg.toString(), fex);
            }
        }
    }

    public static void assertEmptyResultSet(Document entity) {
        String xpath;
        Element docElem = entity.getDocumentElement();
        switch (docElem.getLocalName()) {
            case "feed": {
                xpath = "os:totalResults = 0 and count(atom:entry) = 0";
                break;
            }
            case "GetRecordsResponse": {
                xpath = "csw:SearchResults/@numberOfRecordsMatched = 0 and count(csw:SearchResults/*) = 0";
                break;
            }
            case "rss": {
                xpath = "channel/os:totalResults = 0 and count(channel/item) = 0";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown content: " + docElem.getNodeName()));
            }
        }
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.w3.org/2005/Atom", "atom");
        nsBindings.put("http://a9.com/-/spec/opensearch/1.1/", "os");
        ETSAssert.assertXPath(xpath, docElem, nsBindings);
    }

    public static void assertAllTermsOccur(NodeList recordList, String ... searchTerms) {
        for (String term : searchTerms) {
            for (int i = 0; i < recordList.getLength(); ++i) {
                Element record = (Element)recordList.item(i);
                String expr = String.format("child::*[(text() | attribute::*)[matches(., '%s', 'i')]]", term);
                try {
                    XdmValue result = XMLUtils.evaluateXPath2(new DOMSource(record), expr, null);
                    Assert.assertTrue(result.size() > 0, ErrorMessage.format("XPathResult", Records.getRecordId(record), expr.replace(term, URIUtils.getPercentEncodedString(term))));
                    LOGR.log(Level.FINE, "In {0} found {1} matching fields for ''{2}'':\n{3}", new Object[]{Records.getRecordId(record), result.size(), term, XMLUtils.writeXdmValueToString(result)});
                    continue;
                }
                catch (SaxonApiException sae) {
                    throw new AssertionError((Object)String.format("Failed to evaluate XPath expression: %s \nReason: %s", expr, sae.getMessage()));
                }
            }
        }
    }
}

