/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.w3c.dom.Document;

public class CSWClient {
    private static final Logger LOGR = Logger.getLogger(CSWClient.class.getName());
    private final Client client = ClientUtils.buildClient();
    private Document cswCapabilities;

    public Document getServiceDescription() {
        return this.cswCapabilities;
    }

    public void setServiceDescription(Document capabilities) {
        if (!capabilities.getDocumentElement().getNamespaceURI().equals("http://www.opengis.net/cat/csw/3.0")) {
            throw new IllegalArgumentException("Expected a CSW v3 capabilities document.");
        }
        this.cswCapabilities = capabilities;
    }

    public File saveFullRecords(int maxRecords, MediaType mediaType) {
        ClientRequest req;
        ClientResponse rsp;
        URI getRecordsURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecords", "GET");
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("maxRecords", Integer.toString(maxRecords));
        qryParams.put("elementSetName", "full");
        if (mediaType.equals(MediaType.APPLICATION_XML_TYPE)) {
            qryParams.put("typeNames", "Record");
        }
        if ((rsp = this.client.handle(req = ClientUtils.buildGetRequest(getRecordsURI, qryParams, mediaType))).getStatus() != ClientResponse.Status.OK.getStatusCode()) {
            return null;
        }
        Document entityDoc = rsp.getEntity(Document.class);
        File outputFile = null;
        try {
            outputFile = File.createTempFile("records-", ".xml");
            FileOutputStream fos = new FileOutputStream(outputFile);
            XMLUtils.writeNode(entityDoc, fos);
            fos.close();
        }
        catch (IOException ex) {
            LOGR.log(Level.WARNING, "Failed to save GetRecords response entity to file.", ex);
        }
        return outputFile;
    }

    public Document getCapabilities(URI uri) {
        if (null == uri || !uri.isAbsolute()) {
            uri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        }
        ClientRequest req = ClientUtils.buildGetRequest(uri, null, MediaType.APPLICATION_XML_TYPE);
        ClientResponse rsp = this.client.handle(req);
        Document capabilitiesDoc = null;
        if (rsp.getStatus() == ClientResponse.Status.OK.getStatusCode() && XMLUtils.isXML(rsp.getType())) {
            capabilitiesDoc = rsp.getEntity(Document.class);
        }
        return capabilitiesDoc;
    }

    public Document getOpenSearchDescription(URI uri) {
        ClientRequest req;
        ClientResponse rsp;
        if (null == uri || !uri.isAbsolute()) {
            uri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        }
        if ((rsp = this.client.handle(req = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf("application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf("application/opensearchdescription+xml")))).getStatus() != ClientResponse.Status.OK.getStatusCode() || !XMLUtils.isXML(rsp.getType())) {
            URI endpoint;
            Set<String> values = ServiceMetadataUtils.getConstraintValues(this.cswCapabilities, "OpenSearchDescriptionDocument");
            if (null != values && !values.isEmpty() && !(endpoint = URI.create(values.iterator().next())).equals(uri)) {
                return this.getOpenSearchDescription(endpoint);
            }
            LOGR.config(rsp.toString());
            return null;
        }
        Document entityDoc = rsp.getEntity(Document.class);
        if (!entityDoc.getDocumentElement().getNamespaceURI().equals("http://a9.com/-/spec/opensearch/1.1/")) {
            LOGR.config(entityDoc.getDocumentElement().getNodeName());
            return null;
        }
        return entityDoc;
    }
}

