/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.opengis.cite.cat30.util.NamespaceBindings;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static final Logger LOGR = Logger.getLogger(XMLUtils.class.getPackage().getName());
    private static final XMLInputFactory STAX_FACTORY = XMLUtils.initXMLInputFactory();
    private static final XPathFactory XPATH_FACTORY = XMLUtils.initXPathFactory();

    private static XPathFactory initXPathFactory() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory;
    }

    private static XMLInputFactory initXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return factory;
    }

    public static String writeNodeToString(Node node) {
        if (null == node) {
            return "";
        }
        Object writer = null;
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "US-ASCII");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            writer = new StringWriter();
            idTransformer.transform(new DOMSource(node), new StreamResult((Writer)writer));
        }
        catch (TransformerException ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize node " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static void writeNode(Node node, OutputStream outputStream) {
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("method", "xml");
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            String nodeName = node.getNodeType() == 9 ? ((Document)Document.class.cast(node)).getDocumentElement().getNodeName() : node.getNodeName();
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize DOM node: " + nodeName, ex);
        }
    }

    public static NodeList evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings) throws XPathExpressionException {
        Object result = XMLUtils.evaluateXPath(new DOMSource(context), expr, namespaceBindings, XPathConstants.NODESET);
        if (!NodeList.class.isInstance(result)) {
            throw new XPathExpressionException("Expression does not evaluate to a NodeList: " + expr);
        }
        return (NodeList)result;
    }

    public static Object evaluateXPath(Source context, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        Node contextNode = null;
        if (DOMSource.class.isInstance(context)) {
            contextNode = ((DOMSource)DOMSource.class.cast(context)).getNode();
        } else {
            try {
                contextNode = XMLUtils.parse(context);
            }
            catch (TransformerException ex) {
                TestSuiteLogger.log(Level.WARNING, "Failed to read context item. ", ex);
            }
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPathFactory factory = XPATH_FACTORY;
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(bindings);
        Object result = xpath.evaluate(expr, contextNode, returnType);
        return result;
    }

    public static XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap(domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    public static XdmValue evaluateXQuery(Source source, String query, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XQueryCompiler xqCompiler = proc.newXQueryCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                xqCompiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XQueryExecutable xqExec = xqCompiler.compile(query);
        XQueryEvaluator xqEval = xqExec.load();
        xqEval.setSource(source);
        return xqEval.evaluate();
    }

    public static Element createElement(QName qName) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element elem = doc.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        return elem;
    }

    public static List<Element> getElementsByNamespaceURI(Node node, String namespaceURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(namespaceURI)) continue;
            list.add((Element)child);
        }
        return list;
    }

    public static Document transform(Source xslt, Node source) {
        Document sourceDoc = null;
        Document resultDoc = null;
        try {
            resultDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (source.getNodeType() == 9) {
                sourceDoc = (Document)source;
            } else {
                sourceDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                sourceDoc.appendChild(sourceDoc.importNode(source, true));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        try {
            XsltExecutable exec = compiler.compile(xslt);
            XsltTransformer transformer = exec.load();
            transformer.setSource(new DOMSource(sourceDoc));
            transformer.setDestination(new DOMDestination(resultDoc));
            transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
        return resultDoc;
    }

    public static String expandReferencesInText(String value) {
        StringBuilder wrapper = new StringBuilder("<value>");
        wrapper.append(value).append("</value>");
        StringReader reader = new StringReader(wrapper.toString());
        String str = null;
        try {
            XMLStreamReader xsr = STAX_FACTORY.createXMLStreamReader(reader);
            xsr.nextTag();
            str = xsr.getElementText();
        }
        catch (XMLStreamException xse) {
            LOGR.log(Level.WARNING, xse.getMessage(), xse);
        }
        return str;
    }

    public static StreamSource toStreamSource(DOMSource domSource) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        try {
            Transformer idt = TransformerFactory.newInstance().newTransformer();
            idt.transform(domSource, result);
        }
        catch (TransformerException tex) {
            LOGR.log(Level.WARNING, "Error serializing DOMSource " + domSource.getSystemId(), tex);
        }
        StreamSource streamSrc = new StreamSource(new ByteArrayInputStream(baos.toByteArray()), domSource.getSystemId());
        return streamSrc;
    }

    public static QName nameOfDocumentElement(Source source) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        QName qName = null;
        try {
            XMLEventReader reader = factory.createXMLEventReader(source);
            StartElement docElem = reader.nextTag().asStartElement();
            qName = docElem.getName();
        }
        catch (XMLStreamException xse) {
            LOGR.log(Level.WARNING, "Failed to read Source.", xse);
        }
        return qName;
    }

    public static Document parse(Source source) throws TransformerException {
        Transformer idt = TransformerFactory.newInstance().newTransformer();
        DOMResult result = new DOMResult();
        idt.transform(source, result);
        Document doc = (Document)result.getNode();
        if (null != doc) {
            doc.setDocumentURI(source.getSystemId());
        }
        return doc;
    }

    public static List<Node> getNodeListAsList(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public static String writeXdmValueToString(XdmValue value) {
        StringBuilder str = new StringBuilder();
        for (XdmItem item : value) {
            if (item.isAtomicValue()) {
                str.append(item.getStringValue());
            } else {
                XdmNode node = (XdmNode)item;
                str.append(node.getNodeName()).append(": ");
                str.append(node.getStringValue());
            }
            str.append('\n');
        }
        return str.toString();
    }

    public static boolean isXML(MediaType mediaType) {
        return mediaType.getSubtype().endsWith("xml");
    }

    public static List<String> getNodeValues(NodeList nodeList) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            valueList.add(nodeList.item(i).getTextContent());
        }
        return valueList;
    }
}

