/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.v321.AngleType;
import org.geotoolkit.gml.xml.v321.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v321.LengthType;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.GeometryCoordinateList;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GmlUtils {
    public static final String SRS_NAME = "srsName";
    public static final String GML_NS = "http://www.opengis.net/gml/3.2";
    static final int TOTAL_ARC_POINTS = 5;
    private static final Unmarshaller GML_UNMARSHALLER = GmlUtils.initGmlUnmarshaller();

    private static Unmarshaller initGmlUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return unmarshaller;
    }

    public static void inferPointsOnArc(AbstractCurveSegment segment, CoordinateReferenceSystem crs, List<Coordinate> coordList) {
        ArcByCenterPointType arc = (ArcByCenterPointType)segment;
        List<Double> centerCoords = null != arc.getPos() ? arc.getPos().getValue() : arc.getPosList().getValue();
        GeneralDirectPosition center = new GeneralDirectPosition(crs);
        center.setLocation(centerCoords.get(0), centerCoords.get(1));
        AngleType startAngle = arc.getStartAngle();
        AngleType endAngle = arc.getEndAngle();
        if (null == startAngle) {
            startAngle = new AngleType();
            startAngle.setValue(0.0);
            endAngle = new AngleType();
            endAngle.setValue(360.0);
        }
        if (endAngle.getValue() == 0.0) {
            endAngle.setValue(360.0);
        }
        LengthType radius = arc.getRadius();
        double radiusInMeters = GmlUtils.lengthInMeters(radius);
        DirectPosition startPos = GeodesyUtils.calculateDestination(center, startAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(startPos.getOrdinate(0), startPos.getOrdinate(1)));
        double delta = (endAngle.getValue() - startAngle.getValue()) / 4.0;
        for (int i = 1; i < 4; ++i) {
            double angle = startAngle.getValue() + delta * (double)i;
            DirectPosition arcPos = GeodesyUtils.calculateDestination(center, angle, radiusInMeters);
            coordList.add(new Coordinate(arcPos.getOrdinate(0), arcPos.getOrdinate(1)));
        }
        DirectPosition endPos = GeodesyUtils.calculateDestination(center, endAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(endPos.getOrdinate(0), endPos.getOrdinate(1)));
    }

    public static Geometry computeConvexHull(AbstractGeometry gmlGeom) {
        GeometryCoordinateList coordSet = new GeometryCoordinateList();
        Coordinate[] pointSet = coordSet.getCoordinateList(gmlGeom);
        ConvexHull hull = new ConvexHull(pointSet, new GeometryFactory());
        return hull.getConvexHull();
    }

    public static void setSrsNameOnCollectionMembers(Node ... geometryNodes) {
        for (Node geomNode : geometryNodes) {
            NodeList members;
            Element geom = (Element)geomNode;
            String geomType = geom.getLocalName();
            String srsName = geom.getAttribute(SRS_NAME);
            if (!geomType.startsWith("Multi") || srsName.isEmpty()) continue;
            String memberType = geomType.substring(5).toLowerCase();
            String expr = String.format("gml:%sMember/* | gml:%<sMembers/*", memberType);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new GmlNamespaceContext());
            try {
                members = (NodeList)xpath.evaluate(expr, geom, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
            for (int i = 0; i < members.getLength(); ++i) {
                Element member = (Element)members.item(i);
                if (!member.getAttribute(SRS_NAME).isEmpty()) continue;
                member.setAttribute(SRS_NAME, srsName);
            }
        }
    }

    public static double lengthInMeters(LengthType length) {
        double lengthInMeters;
        String symbol;
        String uom = length.getUom();
        String string = symbol = uom.indexOf(35) >= 0 ? uom.substring(uom.indexOf(35) + 1) : uom;
        if (symbol.equals("m")) {
            lengthInMeters = length.getValue();
        } else if (symbol.equals("km")) {
            lengthInMeters = length.getValue() * 1000.0;
        } else if (symbol.equals("M") | symbol.equals("NM") | symbol.equals("[nmi_i]")) {
            lengthInMeters = length.getValue() * 1852.0;
        } else if (symbol.equals("mi")) {
            lengthInMeters = length.getValue() * 1609.34;
        } else {
            throw new RuntimeException("Unrecognized unit of length: " + uom);
        }
        return lengthInMeters;
    }

    public static void extractCoordinatesFromPosList(List<Double> tupleList, int crsDim, List<Coordinate> coords) {
        if (null == tupleList || tupleList.isEmpty()) {
            return;
        }
        Double[] values = tupleList.toArray(new Double[0]);
        for (int i = 0; i < values.length; i += crsDim) {
            coords.add(new Coordinate(values[i], values[i + 1]));
        }
    }

    public static int minCurveSegmentLength(String segmentTypeName) {
        int minLength = 2;
        if (segmentTypeName.endsWith("ByCenterPoint")) {
            minLength = 1;
        } else if (segmentTypeName.equals("ArcString") || segmentTypeName.equals("Arc") || segmentTypeName.equals("Circle")) {
            minLength = 3;
        }
        return minLength;
    }

    public static String findCRSReference(Element geom) {
        String srsName;
        String expr = "./ancestor-or-self::*[@srsName][1]/@srsName";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
            if (srsName.isEmpty()) {
                NodeNamespaceContext nsContext = new NodeNamespaceContext(geom);
                String gmlPrefix = nsContext.getPrefix(GML_NS);
                expr = String.format("./ancestor::*[%s:boundedBy][1]/%1$s:boundedBy/%1$s:Envelope/@srsName", gmlPrefix);
                xpath.setNamespaceContext(nsContext);
                srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!srsName.isEmpty()) {
            geom.setAttribute(SRS_NAME, srsName);
        }
        return srsName;
    }

    public static boolean hasChildElement(Element elem, String namespace, String localName) {
        return elem.getElementsByTagNameNS(namespace, localName).getLength() > 0;
    }

    public static AbstractGeometry unmarshalGMLGeometry(URI uriRef) throws Exception {
        if (!uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Not an absolute URI: " + uriRef);
        }
        JAXBElement gmlGeom = null;
        try {
            gmlGeom = (JAXBElement)GML_UNMARSHALLER.unmarshal(uriRef.toURL());
        }
        catch (MalformedURLException | JAXBException x) {
            throw new Exception("Failed to unmarshal GML geometry from resource at " + uriRef, x);
        }
        return (AbstractGeometry)gmlGeom.getValue();
    }

    public static class NodeNamespaceContext
    implements NamespaceContext {
        private Node sourceNode;

        public NodeNamespaceContext(Node node) {
            this.sourceNode = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceNode.lookupNamespaceURI(null);
            }
            return this.sourceNode.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceNode.lookupPrefix(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }

    public static class GmlNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String prefix) {
            String nsName = prefix.equals("gml") ? GmlUtils.GML_NS : "";
            return nsName;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            String prefix = null;
            if (namespaceURI.equals(GmlUtils.GML_NS)) {
                prefix = "gml";
            }
            return prefix;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

