/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry;

import java.util.ArrayList;
import java.util.List;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.PointGrid;

public class JTSPointGrid
implements PointGrid {
    private PointArray[] pointGrid;

    public int width() {
        return this.pointGrid[0].length();
    }

    public int height() {
        return this.pointGrid.length;
    }

    public DirectPosition get(int row, int column) throws IndexOutOfBoundsException {
        return this.getInternal(row, column);
    }

    public DirectPosition get(int row, int column, DirectPosition dest) throws IndexOutOfBoundsException {
        GeneralDirectPosition target = new GeneralDirectPosition(this.getInternal(row, column));
        if (dest == null || !dest.getCoordinateReferenceSystem().equals(target.getCoordinateReferenceSystem())) {
            return target;
        }
        for (int i = 0; i < target.getDimension(); ++i) {
            dest.setOrdinate(i, target.getOrdinate(i));
        }
        return dest;
    }

    DirectPosition getInternal(int row, int column) {
        PointArray pointArray = this.pointGrid[row];
        return (DirectPosition)pointArray.positions().get(column);
    }

    public void set(int row, int column, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        GeneralDirectPosition target = new GeneralDirectPosition(this.getInternal(row, column));
        if (position.getCoordinateReferenceSystem().equals(target.getCoordinateReferenceSystem())) {
            for (int i = 0; i < position.getDimension(); ++i) {
                target.setOrdinate(i, position.getOrdinate(i));
            }
        }
    }

    public PointArray getRow(int row) throws IndexOutOfBoundsException {
        return this.pointGrid[row];
    }

    public List rows() {
        ArrayList<PointArray> returnable = new ArrayList<PointArray>(this.pointGrid.length);
        for (int i = 0; i < this.pointGrid.length; ++i) {
            returnable.add(this.pointGrid[i]);
        }
        return returnable;
    }
}

