/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Validation;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLReader;

public class URIQueryParameters {
    FilenameFilter filter = null;
    Boolean recurse = null;
    Integer validation = null;
    int strip = 3;
    Integer onError = null;
    XMLReader parser = null;
    Boolean xinclude = null;
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String query, Configuration config) {
        if (query != null) {
            StringTokenizer t = new StringTokenizer(query, ";&");
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                int eq = tok.indexOf(61);
                if (eq <= 0 || eq >= tok.length() - 1) continue;
                String keyword = tok.substring(0, eq);
                String value = tok.substring(eq + 1);
                if (keyword.equals("select")) {
                    FastStringBuffer sb = new FastStringBuffer(value.length() + 6);
                    sb.append('^');
                    for (int i = 0; i < value.length(); ++i) {
                        char c = value.charAt(i);
                        if (c == '.') {
                            sb.append("\\.");
                            continue;
                        }
                        if (c == '*') {
                            sb.append(".*");
                            continue;
                        }
                        sb.append(c);
                    }
                    sb.append('$');
                    String s = sb.toString();
                    Pattern pattern = Pattern.compile(s);
                    this.filter = new RegexFilter(pattern);
                    continue;
                }
                if (keyword.equals("recurse")) {
                    this.recurse = "yes".equals(value);
                    continue;
                }
                if (keyword.equals("validation")) {
                    int v = Validation.getCode(value);
                    if (v == -1) continue;
                    this.validation = new Integer(v);
                    continue;
                }
                if (keyword.equals("strip-space")) {
                    if (value.equals("yes")) {
                        this.strip = 2;
                        continue;
                    }
                    if (value.equals("ignorable")) {
                        this.strip = 1;
                        continue;
                    }
                    if (!value.equals("no")) continue;
                    this.strip = 0;
                    continue;
                }
                if (keyword.equals("xinclude")) {
                    if (value.equals("yes")) {
                        this.xinclude = Boolean.TRUE;
                        continue;
                    }
                    if (!value.equals("no")) continue;
                    this.xinclude = Boolean.FALSE;
                    continue;
                }
                if (keyword.equals("on-error")) {
                    if (value.equals("warning")) {
                        this.onError = new Integer(2);
                        continue;
                    }
                    if (value.equals("ignore")) {
                        this.onError = new Integer(3);
                        continue;
                    }
                    if (!value.equals("fail")) continue;
                    this.onError = new Integer(1);
                    continue;
                }
                if (!keyword.equals("parser")) continue;
                try {
                    if (config == null) {
                        config = new Configuration();
                    }
                    this.parser = (XMLReader)config.getInstance(value, null);
                }
                catch (XPathException err) {}
            }
        }
    }

    public int getStripSpace() {
        return this.strip;
    }

    public Integer getValidationMode() {
        return this.validation;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public Boolean getRecurse() {
        return this.recurse;
    }

    public Integer getOnError() {
        return this.onError;
    }

    public Boolean getXInclude() {
        return this.xinclude;
    }

    public XMLReader getXMLReader() {
        return this.parser;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private Pattern pattern;

        public RegexFilter(Pattern regex) {
            this.pattern = regex;
        }

        public boolean accept(File dir2, String name) {
            return new File(dir2, name).isDirectory() || this.pattern.matcher(name).matches();
        }
    }
}

