/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.geotoolkit.console.ReferencingCommands;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.ParameterWriter;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.FallbackAuthorityFactory;
import org.geotoolkit.referencing.factory.epsg.PropertyEpsgFactory;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class ReferencingAction {
    private static final Hints HINTS = null;
    private final ReferencingCommands cmd;
    private final Vocabulary resources;
    private transient WKTFormat format;

    ReferencingAction(ReferencingCommands referencingCommands) {
        this.cmd = referencingCommands;
        this.resources = Vocabulary.getResources(referencingCommands.locale);
    }

    private String bold(int n) {
        return this.cmd.bold(this.resources.getString(n));
    }

    private WKTFormat getWktFormat() {
        if (this.format == null) {
            this.format = new WKTFormat();
            String string = this.cmd.authority;
            if (string != null) {
                this.format.setAuthority(Citations.fromName(string));
            }
            if (Boolean.TRUE.equals(this.cmd.colors)) {
                this.format.setColors(Colors.DEFAULT);
            }
            this.format.setIndentation(this.cmd.indent);
        }
        return this.format;
    }

    private CRSAuthorityFactory getCRSAuthorityFactory() {
        CRSAuthorityFactory cRSAuthorityFactory = CRS.getAuthorityFactory(this.cmd.forcexy);
        String string = this.cmd.authority;
        if (string != null) {
            CRSAuthorityFactory cRSAuthorityFactory2;
            Hints hints = new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, this.cmd.forcexy);
            try {
                cRSAuthorityFactory2 = AuthorityFactoryFinder.getCRSAuthorityFactory(string, hints);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                PrintWriter printWriter = this.cmd.err;
                printWriter.println(factoryNotFoundException.getLocalizedMessage());
                printWriter.println();
                printWriter.flush();
                return cRSAuthorityFactory;
            }
            cRSAuthorityFactory = (CRSAuthorityFactory)FallbackAuthorityFactory.create(CRSAuthorityFactory.class, (AuthorityFactory[])new CRSAuthorityFactory[]{cRSAuthorityFactory2, cRSAuthorityFactory});
        }
        return cRSAuthorityFactory;
    }

    private static char[] getSeparator() {
        char[] cArray = new char[79];
        Arrays.fill(cArray, '\u2500');
        return cArray;
    }

    public void printObjectsWKT(String[] stringArray) {
        PrintWriter printWriter = this.cmd.out;
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        char[] cArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            IdentifiedObject identifiedObject;
            if (cArray == null) {
                cArray = ReferencingAction.getSeparator();
            } else {
                printWriter.println(cArray);
            }
            WKTFormat wKTFormat = this.getWktFormat();
            try {
                identifiedObject = cRSAuthorityFactory.createObject(stringArray[i]);
            }
            catch (FactoryException factoryException) {
                this.cmd.printException(factoryException);
                this.cmd.exit(1);
                return;
            }
            printWriter.println(wKTFormat.format(identifiedObject));
            String string = wKTFormat.getWarning();
            if (string != null) {
                printWriter.println();
                printWriter.print(this.resources.getString(326));
                printWriter.print(": ");
                printWriter.println(string);
            }
            printWriter.flush();
        }
    }

    private void listAuthorities() {
        PrintWriter printWriter = this.cmd.out;
        HashSet<Citation> hashSet = new HashSet<Citation>();
        TableWriter tableWriter = new TableWriter((Writer)printWriter, " \u2502 ");
        TableWriter tableWriter2 = new TableWriter((Writer)printWriter, " ");
        int n = 0;
        tableWriter2.setMultiLinesCells(true);
        tableWriter.setMultiLinesCells(true);
        tableWriter.writeHorizontalSeparator();
        tableWriter.write(this.bold(12));
        tableWriter.nextColumn();
        tableWriter.write(this.bold(75));
        tableWriter.nextColumn();
        tableWriter.write(this.bold(207));
        tableWriter.writeHorizontalSeparator();
        for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(HINTS)) {
            Citation citation = cRSAuthorityFactory.getAuthority();
            Iterator<? extends Identifier> iterator = citation.getIdentifiers().iterator();
            if (!iterator.hasNext() || !hashSet.add(citation)) continue;
            tableWriter.write(iterator.next().getCode());
            tableWriter.nextColumn();
            tableWriter.write(((Object)citation.getTitle()).toString().trim());
            if (cRSAuthorityFactory instanceof AbstractAuthorityFactory) {
                String string;
                try {
                    string = ((AbstractAuthorityFactory)((Object)cRSAuthorityFactory)).getBackingStoreDescription();
                }
                catch (FactoryException factoryException) {
                    string = factoryException.getLocalizedMessage();
                }
                if (string != null) {
                    String string2 = String.valueOf(++n);
                    tableWriter.nextColumn();
                    tableWriter.write(40);
                    tableWriter.write(string2);
                    tableWriter.write(41);
                    tableWriter2.write(40);
                    tableWriter2.write(string2);
                    tableWriter2.write(41);
                    tableWriter2.nextColumn();
                    tableWriter2.write(string.trim());
                    tableWriter2.nextLine();
                }
            }
            tableWriter.nextLine();
        }
        tableWriter.writeHorizontalSeparator();
        try {
            tableWriter.flush();
            tableWriter2.flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void listCodes() {
        String string = this.cmd.authority;
        CRSAuthorityFactory cRSAuthorityFactory = string != null ? AuthorityFactoryFinder.getCRSAuthorityFactory(string, HINTS) : CRS.getAuthorityFactory(this.cmd.forcexy);
        TableWriter tableWriter = new TableWriter(this.cmd.out);
        tableWriter.writeHorizontalSeparator();
        tableWriter.write(this.bold(31));
        tableWriter.nextColumn();
        tableWriter.write(this.bold(75));
        tableWriter.writeHorizontalSeparator();
        try {
            Set<String> set = cRSAuthorityFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
            for (String string2 : set) {
                tableWriter.write(string2);
                tableWriter.nextColumn();
                try {
                    InternationalString internationalString = cRSAuthorityFactory.getDescriptionText(string2);
                    if (internationalString != null) {
                        tableWriter.write(internationalString.toString(this.cmd.locale));
                    }
                }
                catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    // empty catch block
                }
                tableWriter.nextLine();
            }
        }
        catch (FactoryException factoryException) {
            this.cmd.printException(factoryException);
            this.cmd.exit(200);
        }
        tableWriter.writeHorizontalSeparator();
        try {
            tableWriter.flush();
        }
        catch (IOException iOException) {
            this.cmd.printException(iOException);
            this.cmd.exit(100);
        }
    }

    public void list(String[] stringArray) {
        Class<SingleOperation> clazz;
        String string = stringArray[0];
        if (string.equalsIgnoreCase("authorities")) {
            this.listAuthorities();
            return;
        }
        if (string.equalsIgnoreCase("codes")) {
            this.listCodes();
            return;
        }
        if (string.equalsIgnoreCase("operations")) {
            clazz = SingleOperation.class;
        } else if (string.equalsIgnoreCase("conversions")) {
            clazz = Conversion.class;
        } else if (string.equalsIgnoreCase("projections")) {
            clazz = Projection.class;
        } else {
            PrintWriter printWriter = this.cmd.err;
            Errors errors = Errors.getResources(this.cmd.locale);
            printWriter.println(errors.getString(72, "list"));
            printWriter.println(errors.getString(226, string));
            this.cmd.exit(1);
            return;
        }
        String string2 = this.cmd.authority;
        MathTransformFactory mathTransformFactory = FactoryFinder.getMathTransformFactory(HINTS);
        TreeSet<IdentifiedObject> treeSet = new TreeSet<IdentifiedObject>(IdentifiedObjects.NAME_COMPARATOR);
        treeSet.addAll(mathTransformFactory.getAvailableMethods(clazz));
        ParameterWriter parameterWriter = new ParameterWriter(this.cmd.out);
        parameterWriter.setLocale(this.cmd.locale);
        parameterWriter.setColorEnabled(this.cmd.colors);
        parameterWriter.setAuthorities("EPSG:#", string2 != null ? string2 : "Geotk");
        try {
            parameterWriter.summary(treeSet);
        }
        catch (IOException iOException) {
            this.cmd.printException(iOException);
            this.cmd.exit(100);
            return;
        }
    }

    public void bursawolfs(String[] stringArray) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.cmd.locale);
        numberFormat.setMinimumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        TableWriter tableWriter = new TableWriter(this.cmd.out);
        tableWriter.writeHorizontalSeparator();
        String[] stringArray2 = new String[]{this.resources.getString(288), "dx", "dy", "dz", "ex", "ey", "ez", "ppm"};
        for (int i = 0; i < stringArray2.length; ++i) {
            tableWriter.write(this.cmd.bold(stringArray2[i]));
            tableWriter.nextColumn();
            tableWriter.setAlignment(1);
        }
        tableWriter.writeHorizontalSeparator();
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        for (int i = 0; i < stringArray.length; ++i) {
            IdentifiedObject identifiedObject;
            try {
                identifiedObject = cRSAuthorityFactory.createObject(stringArray[i]);
            }
            catch (FactoryException factoryException) {
                this.cmd.printException(factoryException);
                this.cmd.exit(1);
                return;
            }
            if (identifiedObject instanceof CoordinateReferenceSystem) {
                identifiedObject = CRS.getDatum((CoordinateReferenceSystem)identifiedObject);
            }
            if (!(identifiedObject instanceof DefaultGeodeticDatum)) continue;
            BursaWolfParameters[] bursaWolfParametersArray = ((DefaultGeodeticDatum)identifiedObject).getBursaWolfParameters();
            for (int j = 0; j < bursaWolfParametersArray.length; ++j) {
                BursaWolfParameters bursaWolfParameters = bursaWolfParametersArray[j];
                tableWriter.setAlignment(0);
                tableWriter.write(bursaWolfParameters.targetDatum.getName().getCode());
                tableWriter.nextColumn();
                tableWriter.setAlignment(2);
                for (int k = 0; k < 7; ++k) {
                    double d;
                    switch (k) {
                        case 0: {
                            d = bursaWolfParameters.dx;
                            break;
                        }
                        case 1: {
                            d = bursaWolfParameters.dy;
                            break;
                        }
                        case 2: {
                            d = bursaWolfParameters.dz;
                            break;
                        }
                        case 3: {
                            d = bursaWolfParameters.ex;
                            break;
                        }
                        case 4: {
                            d = bursaWolfParameters.ey;
                            break;
                        }
                        case 5: {
                            d = bursaWolfParameters.ez;
                            break;
                        }
                        case 6: {
                            d = bursaWolfParameters.ppm;
                            break;
                        }
                        default: {
                            throw new AssertionError(k);
                        }
                    }
                    tableWriter.write(numberFormat.format(d));
                    tableWriter.nextColumn();
                }
                tableWriter.nextLine();
            }
            tableWriter.writeHorizontalSeparator();
        }
        try {
            tableWriter.flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void operations(String[] stringArray) {
        PrintWriter printWriter = this.cmd.out;
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(this.cmd.authority, HINTS);
        char[] cArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                Set<CoordinateOperation> set;
                try {
                    set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(stringArray[i], stringArray[j]);
                }
                catch (FactoryException factoryException) {
                    this.cmd.printException(factoryException);
                    this.cmd.exit(1);
                    return;
                }
                for (CoordinateOperation coordinateOperation : set) {
                    if (cArray == null) {
                        cArray = ReferencingAction.getSeparator();
                    } else {
                        printWriter.println(cArray);
                    }
                    WKTFormat wKTFormat = this.getWktFormat();
                    printWriter.println(wKTFormat.format(coordinateOperation));
                }
            }
        }
    }

    public void transform(String[] stringArray) {
        PrintWriter printWriter = this.cmd.out;
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        CoordinateOperationFactory coordinateOperationFactory = AuthorityFactoryFinder.getCoordinateOperationFactory(HINTS);
        char[] cArray = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                CoordinateReferenceSystem coordinateReferenceSystem = cRSAuthorityFactory.createCoordinateReferenceSystem(stringArray[i]);
                for (int j = i + 1; j < stringArray.length; ++j) {
                    CoordinateOperation coordinateOperation;
                    CoordinateReferenceSystem coordinateReferenceSystem2 = cRSAuthorityFactory.createCoordinateReferenceSystem(stringArray[j]);
                    try {
                        coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
                    }
                    catch (OperationNotFoundException operationNotFoundException) {
                        printWriter.println(operationNotFoundException.getLocalizedMessage());
                        continue;
                    }
                    if (cArray == null) {
                        cArray = ReferencingAction.getSeparator();
                    } else {
                        printWriter.println(cArray);
                    }
                    WKTFormat wKTFormat = this.getWktFormat();
                    printWriter.println(wKTFormat.format(coordinateOperation.getMathTransform()));
                }
            }
        }
        catch (FactoryException factoryException) {
            this.cmd.printException(factoryException);
            this.cmd.exit(1);
        }
    }

    public void reformat(Reader reader, Writer writer, PrintWriter printWriter) {
        WKTFormat wKTFormat = this.getWktFormat();
        try {
            wKTFormat.reformat(reader, writer, printWriter);
        }
        catch (IOException iOException) {
            this.cmd.printException(iOException);
            this.cmd.exit(100);
        }
    }

    public void test(String[] stringArray) {
        int n;
        PrintWriter printWriter = this.cmd.out;
        String string = stringArray[0];
        if (string.equalsIgnoreCase("all")) {
            n = 0;
        } else if (string.equalsIgnoreCase("creates")) {
            n = 1;
        } else if (string.equalsIgnoreCase("duplicates")) {
            n = 2;
        } else {
            Errors errors = Errors.getResources(this.cmd.locale);
            this.cmd.err.println(errors.getString(73, "test", string));
            this.cmd.exit(1);
            return;
        }
        Hints hints = new Hints(Hints.CRS_AUTHORITY_FACTORY, PropertyEpsgFactory.class);
        for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(hints)) {
            if (!(cRSAuthorityFactory instanceof PropertyEpsgFactory)) continue;
            PropertyEpsgFactory propertyEpsgFactory = (PropertyEpsgFactory)cRSAuthorityFactory;
            try {
                switch (n) {
                    case 0: 
                    case 1: {
                        printWriter.println("CRS failures:");
                        if (propertyEpsgFactory.reportInstantiationFailures(printWriter).isEmpty()) {
                            printWriter.println(this.resources.getString(203));
                        }
                        printWriter.println();
                        if (n != 0) break;
                    }
                    case 2: {
                        printWriter.println("CRS duplicates:");
                        if (propertyEpsgFactory.reportDuplicates(printWriter).isEmpty()) {
                            printWriter.println(this.resources.getString(210));
                        }
                        printWriter.println();
                        if (n == 0) break;
                    }
                }
            }
            catch (FactoryException factoryException) {
                factoryException.printStackTrace(this.cmd.err);
            }
        }
    }
}

