/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ProjectedPathIterator
extends Point2D.Double
implements PathIterator {
    private static final double TOLERANCE = 1.0E-5;
    private final PathIterator iterator;
    private final MathTransform2D projection;
    private final double[] buffer;
    private transient double \u03bb;
    private transient double \u03c6;
    private transient double \u03bb0;
    private transient double \u03c60;
    private transient double x0;
    private transient double y0;
    private transient Matrix derivative;
    private transient double ctrlx1;
    private transient double ctrly1;
    private transient double ctrlx2;
    private transient double ctrly2;
    private transient boolean isClosing;

    ProjectedPathIterator(PathIterator pathIterator, MathTransform2D mathTransform2D) {
        this.iterator = pathIterator;
        this.projection = mathTransform2D;
        this.buffer = new double[2];
    }

    @Override
    public int getWindingRule() {
        return this.iterator.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return !this.isClosing && this.iterator.isDone();
    }

    @Override
    public void next() {
        if (!this.isClosing) {
            this.iterator.next();
        }
    }

    private void transform(double[] dArray, int n) throws TransformException {
        int n2 = n - 1 << 1;
        int n3 = n2 + 1;
        this.\u03bb = dArray[n2];
        this.\u03c6 = dArray[n3];
        this.projection.transform(dArray, 0, dArray, 0, n);
        this.x = dArray[n2];
        this.y = dArray[n3];
        this.derivative = null;
    }

    private void transform(float[] fArray, int n) throws TransformException {
        if (--n != 0) {
            this.projection.transform(fArray, 0, fArray, 0, n);
        }
        int n2 = n << 1;
        int n3 = n2 + 1;
        this.x = this.\u03bb = (double)fArray[n2];
        this.y = this.\u03c6 = (double)fArray[n3];
        Point2D point2D = this.projection.transform(this, this);
        if (point2D != this) {
            this.setLocation(point2D);
        }
        fArray[n2] = (float)this.x;
        fArray[n3] = (float)this.y;
        this.derivative = null;
    }

    @Override
    public int currentSegment(double[] dArray) {
        if (this.isClosing) {
            this.isClosing = false;
            return 4;
        }
        int n = this.iterator.currentSegment(dArray);
        try {
            switch (n) {
                case 0: {
                    this.\u03bb0 = dArray[0];
                    this.\u03c60 = dArray[1];
                    this.transform(dArray, 1);
                    this.x0 = dArray[0];
                    this.y0 = dArray[1];
                    break;
                }
                case 2: {
                    this.transform(dArray, 2);
                    break;
                }
                case 3: {
                    this.transform(dArray, 3);
                    break;
                }
                case 4: {
                    if (this.x0 == this.x && this.y0 == this.y) break;
                    this.isClosing = true;
                    dArray[0] = this.\u03bb0;
                    dArray[1] = this.\u03c60;
                }
                case 1: {
                    double d = this.x;
                    double d2 = this.y;
                    double d3 = dArray[0] - this.\u03bb;
                    double d4 = dArray[1] - this.\u03c6;
                    Matrix matrix = this.derivative;
                    if (matrix == null) {
                        this.x = this.\u03bb;
                        this.y = this.\u03c6;
                        matrix = this.projection.derivative(this);
                    }
                    this.\u03bb = dArray[0];
                    this.\u03c6 = dArray[1];
                    this.derivativeAndTransform(dArray);
                    n = this.transformSegment(d3, d4, d, d2, matrix);
                    int n2 = 0;
                    switch (n) {
                        case 3: {
                            dArray[n2++] = this.ctrlx1;
                            dArray[n2++] = this.ctrly1;
                        }
                        case 2: {
                            dArray[n2++] = this.ctrlx2;
                            dArray[n2++] = this.ctrly2;
                        }
                        case 1: {
                            dArray[n2++] = this.x;
                            dArray[n2++] = this.y;
                        }
                    }
                    break;
                }
            }
        }
        catch (TransformException transformException) {
            IllegalPathStateException illegalPathStateException = new IllegalPathStateException(transformException.getLocalizedMessage());
            illegalPathStateException.initCause(transformException);
            throw illegalPathStateException;
        }
        return n;
    }

    @Override
    public int currentSegment(float[] fArray) {
        if (this.isClosing) {
            this.isClosing = false;
            return 4;
        }
        int n = this.iterator.currentSegment(fArray);
        try {
            switch (n) {
                case 0: {
                    this.\u03bb0 = fArray[0];
                    this.\u03c60 = fArray[1];
                    this.transform(fArray, 1);
                    this.x0 = fArray[0];
                    this.y0 = fArray[1];
                    break;
                }
                case 2: {
                    this.transform(fArray, 2);
                    break;
                }
                case 3: {
                    this.transform(fArray, 3);
                    break;
                }
                case 4: {
                    if (this.x0 == this.x && this.y0 == this.y) break;
                    this.isClosing = true;
                    fArray[0] = (float)this.\u03bb0;
                    fArray[1] = (float)this.\u03c60;
                }
                case 1: {
                    double d = this.x;
                    double d2 = this.y;
                    double d3 = (double)fArray[0] - this.\u03bb;
                    double d4 = (double)fArray[1] - this.\u03c6;
                    Matrix matrix = this.derivative;
                    if (matrix == null) {
                        this.x = this.\u03bb;
                        this.y = this.\u03c6;
                        matrix = this.projection.derivative(this);
                    }
                    this.buffer[0] = this.\u03bb = (double)fArray[0];
                    this.buffer[1] = this.\u03c6 = (double)fArray[1];
                    this.derivativeAndTransform(this.buffer);
                    n = this.transformSegment(d3, d4, d, d2, matrix);
                    int n2 = 0;
                    switch (n) {
                        case 3: {
                            fArray[n2++] = (float)this.ctrlx1;
                            fArray[n2++] = (float)this.ctrly1;
                        }
                        case 2: {
                            fArray[n2++] = (float)this.ctrlx2;
                            fArray[n2++] = (float)this.ctrly2;
                        }
                        case 1: {
                            fArray[n2++] = (float)this.x;
                            fArray[n2++] = (float)this.y;
                        }
                    }
                    break;
                }
            }
        }
        catch (TransformException transformException) {
            IllegalPathStateException illegalPathStateException = new IllegalPathStateException(transformException.getLocalizedMessage());
            illegalPathStateException.initCause(transformException);
            throw illegalPathStateException;
        }
        return n;
    }

    private void derivativeAndTransform(double[] dArray) throws TransformException {
        this.derivative = MathTransforms.derivativeAndTransform(this.projection, dArray, 0, dArray, 0);
        if (this.derivative == null) {
            throw new TransformException(Errors.format(21));
        }
        this.x = dArray[0];
        this.y = dArray[1];
    }

    private int transformSegment(double d, double d2, double d3, double d4, Matrix matrix) {
        double d5 = this.x;
        double d6 = this.y;
        Matrix matrix2 = this.derivative;
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        double d9 = Math.hypot(d7, d8);
        double d10 = matrix.getElement(0, 0) * d + matrix.getElement(0, 1) * d2;
        double d11 = matrix.getElement(1, 0) * d + matrix.getElement(1, 1) * d2;
        double d12 = matrix2.getElement(0, 0) * d + matrix2.getElement(0, 1) * d2;
        double d13 = matrix2.getElement(1, 0) * d + matrix2.getElement(1, 1) * d2;
        double d14 = Math.hypot(d10, d11);
        double d15 = Math.hypot(d12, d13);
        double d16 = (d7 * d10 + d8 * d11) / (d9 * d14);
        double d17 = (d7 * d12 + d8 * d13) / (d9 * d15);
        if (!(Math.abs(Math.abs(d16) - 1.0) > 1.0E-5) && !(Math.abs(Math.abs(d17) - 1.0) > 1.0E-5)) {
            return 1;
        }
        if (d16 >= 0.7071067811865476 && Math.abs(d16 - d17) <= 1.0E-5) {
            double d18 = Math.abs((d13 * d7 - d12 * d8) / (d13 * d10 - d12 * d11));
            this.ctrlx2 = d3 + d10 * d18;
            this.ctrly2 = d4 + d11 * d18;
            return 2;
        }
        this.ctrlx1 = d3 + d10 / 3.0;
        this.ctrly1 = d4 + d11 / 3.0;
        this.ctrlx2 = d5 - d12 / 3.0;
        this.ctrly2 = d6 - d13 / 3.0;
        return 3;
    }
}

