/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry;

import javax.measure.unit.NonSI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.GeometryUtils;
import org.geotoolkit.internal.jaxb.DirectPositionAdapter;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlType(name="EnvelopeType", namespace="http://www.opengis.net/gml")
public class JTSEnvelope
implements Envelope {
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    private final DirectPosition lowerCorner;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    private final DirectPosition upperCorner;

    public JTSEnvelope() {
        this.lowerCorner = null;
        this.upperCorner = null;
    }

    public JTSEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) {
        this.lowerCorner = new GeneralDirectPosition(lowerCorner);
        this.upperCorner = new GeneralDirectPosition(upperCorner);
    }

    @Override
    public final int getDimension() {
        return this.upperCorner.getDimension();
    }

    @Override
    public final double getMinimum(int dimension) {
        return this.lowerCorner.getOrdinate(dimension);
    }

    @Override
    public final double getMaximum(int dimension) {
        return this.upperCorner.getOrdinate(dimension);
    }

    @Override
    public final double getMedian(int dimension) {
        return 0.5 * (this.upperCorner.getOrdinate(dimension) + this.lowerCorner.getOrdinate(dimension));
    }

    @Override
    public final double getSpan(int dimension) {
        return this.upperCorner.getOrdinate(dimension) - this.lowerCorner.getOrdinate(dimension);
    }

    @Override
    public final DirectPosition getUpperCorner() {
        return new GeneralDirectPosition(this.upperCorner);
    }

    @Override
    public final DirectPosition getLowerCorner() {
        return new GeneralDirectPosition(this.lowerCorner);
    }

    public String toString() {
        double[] bbox = GeometryUtils.getBBox(this, NonSI.DEGREE_ANGLE);
        StringBuffer returnable = new StringBuffer("Envelope[").append(bbox[0]);
        for (int i = 1; i < bbox.length; ++i) {
            returnable.append(",").append(bbox[i]);
        }
        return returnable.append("]").toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Envelope)) {
            return false;
        }
        Envelope that = (Envelope)obj;
        return GeometryUtils.equals(this, that);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.lowerCorner != null ? ((Object)this.lowerCorner).hashCode() : 0);
        hash = 17 * hash + (this.upperCorner != null ? ((Object)this.upperCorner).hashCode() : 0);
        return hash;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getUpperCorner().getCoordinateReferenceSystem();
    }
}

