/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.MatrixParameterDescriptors;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class MatrixParameters
extends ParameterGroup
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -7747712999115044943L;
    private ParameterValue<Double>[][] matrixValues;
    private ParameterValue<Integer> numRow = Parameters.cast((ParameterValue)this.parameter(0), Integer.class);
    private ParameterValue<Integer> numCol = Parameters.cast((ParameterValue)this.parameter(1), Integer.class);

    public MatrixParameters(MatrixParameterDescriptors matrixParameterDescriptors) {
        super(matrixParameterDescriptors);
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this;
    }

    @Override
    public ReferenceIdentifier getName() {
        return this.descriptor.getName();
    }

    @Override
    public Collection<GenericName> getAlias() {
        return this.descriptor.getAlias();
    }

    @Override
    public Set<ReferenceIdentifier> getIdentifiers() {
        return this.descriptor.getIdentifiers();
    }

    @Override
    public InternationalString getRemarks() {
        return this.descriptor.getRemarks();
    }

    @Override
    public int getMinimumOccurs() {
        return this.descriptor.getMinimumOccurs();
    }

    @Override
    public int getMaximumOccurs() {
        return this.descriptor.getMaximumOccurs();
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        return ((MatrixParameterDescriptors)this.descriptor).descriptor(string, this.numRow.intValue(), this.numCol.intValue());
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        int n;
        ArgumentChecks.ensureNonNull("name", string);
        string = string.trim();
        MatrixParameterDescriptors matrixParameterDescriptors = (MatrixParameterDescriptors)this.descriptor;
        String string2 = matrixParameterDescriptors.prefix;
        RuntimeException runtimeException = null;
        if (string.regionMatches(true, 0, string2, 0, string2.length()) && (n = string.indexOf(matrixParameterDescriptors.separator, string2.length())) >= 0) {
            try {
                int n2 = Integer.parseInt(string.substring(string2.length(), n));
                int n3 = Integer.parseInt(string.substring(n + 1));
                return this.parameter(n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                runtimeException = numberFormatException;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                runtimeException = indexOutOfBoundsException;
            }
        }
        try {
            return super.parameter(string);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            if (runtimeException != null) {
                try {
                    parameterNotFoundException.initCause(runtimeException);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            throw parameterNotFoundException;
        }
    }

    public final ParameterValue<Double> parameter(int n, int n2) throws IndexOutOfBoundsException {
        return this.parameter(n, n2, this.numRow.intValue(), this.numCol.intValue());
    }

    private ParameterValue<Double> parameter(int n, int n2, int n3, int n4) throws IndexOutOfBoundsException {
        FloatParameter floatParameter;
        ParameterValue<Double>[] parameterValueArray;
        MatrixParameterDescriptors.checkIndice("row", n, n3);
        MatrixParameterDescriptors.checkIndice("column", n2, n4);
        if (this.matrixValues == null) {
            this.matrixValues = new ParameterValue[n3][];
        }
        if (n >= this.matrixValues.length) {
            this.matrixValues = (ParameterValue[][])Arrays.copyOf(this.matrixValues, n3);
        }
        if ((parameterValueArray = this.matrixValues[n]) == null) {
            parameterValueArray = new ParameterValue[n4];
            this.matrixValues[n] = parameterValueArray;
        }
        if (n2 >= parameterValueArray.length) {
            parameterValueArray = Arrays.copyOf(parameterValueArray, n4);
            this.matrixValues[n] = parameterValueArray;
        }
        if ((floatParameter = parameterValueArray[n2]) == null) {
            parameterValueArray[n2] = floatParameter = new FloatParameter(((MatrixParameterDescriptors)this.descriptor).descriptor(n, n2, n3, n4));
        }
        return floatParameter;
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        return ((MatrixParameterDescriptors)this.descriptor).descriptors(this.numRow.intValue(), this.numCol.intValue());
    }

    @Override
    public List<GeneralParameterValue> values() {
        int n = this.numRow.intValue();
        int n2 = this.numCol.intValue();
        ParameterValue[] parameterValueArray = new ParameterValue[n * n2 + 2];
        int n3 = 0;
        parameterValueArray[n3++] = this.numRow;
        parameterValueArray[n3++] = this.numCol;
        if (this.matrixValues != null) {
            int n4 = Math.min(n, this.matrixValues.length);
            for (int i = 0; i < n4; ++i) {
                ParameterValue<Double>[] parameterValueArray2 = this.matrixValues[i];
                if (parameterValueArray2 == null) continue;
                int n5 = Math.min(n2, parameterValueArray2.length);
                for (int j = 0; j < n5; ++j) {
                    ParameterValue<Double> parameterValue = parameterValueArray2[j];
                    if (parameterValue == null) continue;
                    parameterValueArray[n3++] = parameterValue;
                }
            }
        }
        return UnmodifiableArrayList.wrap((GeneralParameterValue[])XArrays.resize(parameterValueArray, n3));
    }

    @Override
    public ParameterValueGroup createValue() {
        return (ParameterValueGroup)this.descriptor.createValue();
    }

    public Matrix getMatrix() {
        int n = this.numRow.intValue();
        int n2 = this.numCol.intValue();
        XMatrix xMatrix = Matrices.create(n, n2);
        if (this.matrixValues != null) {
            for (int i = 0; i < n; ++i) {
                ParameterValue<Double>[] parameterValueArray = this.matrixValues[i];
                if (parameterValueArray == null) continue;
                for (int j = 0; j < n2; ++j) {
                    ParameterValue<Double> parameterValue = parameterValueArray[j];
                    if (parameterValue == null) continue;
                    xMatrix.setElement(i, j, parameterValue.doubleValue());
                }
            }
        }
        return xMatrix;
    }

    public void setMatrix(Matrix matrix) {
        MatrixParameterDescriptors matrixParameterDescriptors = (MatrixParameterDescriptors)this.descriptor;
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        this.numRow.setValue(n);
        this.numCol.setValue(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ParameterDescriptor<Double> parameterDescriptor;
                double d;
                double d2 = matrix.getElement(i, j);
                if (d2 == (d = (parameterDescriptor = matrixParameterDescriptors.descriptor(i, j)).getDefaultValue().doubleValue()) || Double.isNaN(d2) && Double.isNaN(d)) {
                    if (this.matrixValues == null || this.matrixValues[i] == null) continue;
                    this.matrixValues[i][j] = null;
                    continue;
                }
                if (this.matrixValues == null) {
                    this.matrixValues = new ParameterValue[n][];
                }
                if (this.matrixValues[i] == null) {
                    this.matrixValues[i] = new ParameterValue[n2];
                }
                this.matrixValues[i][j] = new FloatParameter(parameterDescriptor, d2);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MatrixParameters matrixParameters = (MatrixParameters)object;
            int n = this.numRow.intValue();
            int n2 = this.numCol.intValue();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (Utilities.equals(this.parameter(i, j, n, n2), matrixParameters.parameter(i, j, n, n2))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public MatrixParameters clone() {
        MatrixParameters matrixParameters = (MatrixParameters)super.clone();
        if (matrixParameters.matrixValues != null) {
            matrixParameters.numRow = (ParameterValue)matrixParameters.parameter(0);
            matrixParameters.numCol = (ParameterValue)matrixParameters.parameter(1);
            matrixParameters.matrixValues = (ParameterValue[][])matrixParameters.matrixValues.clone();
            for (int i = 0; i < matrixParameters.matrixValues.length; ++i) {
                ParameterValue<Double>[] parameterValueArray = matrixParameters.matrixValues[i];
                if (parameterValueArray == null) continue;
                parameterValueArray = (ParameterValue[])parameterValueArray.clone();
                matrixParameters.matrixValues[i] = parameterValueArray;
                for (int j = 0; j < parameterValueArray.length; ++j) {
                    if (parameterValueArray[j] == null) continue;
                    parameterValueArray[j] = parameterValueArray[j].clone();
                }
            }
        }
        return matrixParameters;
    }

    @Override
    protected void write(TableWriter tableWriter) throws IOException {
        tableWriter.write(MatrixParameters.getName(this.descriptor));
        tableWriter.nextColumn();
        tableWriter.write(61);
        tableWriter.nextColumn();
        tableWriter.write(this.getMatrix().toString());
        tableWriter.nextLine();
    }
}

