/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.AbstractReferenceSystem;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;

@Immutable
public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    private CoordinateSystem coordinateSystem;

    private AbstractCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public AbstractCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        super(coordinateReferenceSystem);
        this.coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
    }

    public AbstractCRS(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        super(map);
        ArgumentChecks.ensureNonNull("cs", coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    static Map<String, ?> name(int n) {
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", ((Object)internationalString).toString());
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        if (this.coordinateSystem != NilReferencingObject.INSTANCE) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull("cs", coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    final Unit<?> getUnit() {
        return CRSUtilities.getUnit(this.coordinateSystem);
    }

    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (this.coordinateSystem instanceof AbstractCS) {
            return ((AbstractCS)this.coordinateSystem).distance(dArray, dArray2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractCRS abstractCRS = (AbstractCRS)object;
                    return Utilities.equals(this.coordinateSystem, abstractCRS.coordinateSystem);
                }
            }
            CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)object;
            return Utilities.deepEquals(this.getCoordinateSystem(), coordinateReferenceSystem.getCoordinateSystem(), comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.coordinateSystem, super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        this.formatDefaultWKT(formatter);
        return super.formatWKT(formatter);
    }

    void formatDefaultWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append(unit);
        int n = this.coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(CoordinateReferenceSystem.class);
        }
    }
}

