/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.EquidistantCylindrical;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class CassiniSoldner
extends MapProjection {
    private static final long serialVersionUID = -2473637102471705721L;
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptor<Double> FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public CassiniSoldner() {
        super(PARAMETERS);
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.CassiniSoldner.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.NETCDF};
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of natural origin", "central_meridian", "Central_Meridian", "NatOriginLong");
        LATITUDE_OF_ORIGIN = UniversalParameters.LATITUDE_OF_ORIGIN.select(citationArray, "Latitude of natural origin", "latitude_of_origin", "Latitude_Of_Origin", "NatOriginLat");
        SCALE_FACTOR = UniversalParameters.SCALE_FACTOR.select(citationArray, "Scale factor at natural origin", "ScaleAtNatOrigin");
        FALSE_EASTING = EquidistantCylindrical.FALSE_EASTING;
        FALSE_NORTHING = EquidistantCylindrical.FALSE_NORTHING;
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Cassini_Soldner"), new NamedIdentifier(Citations.EPSG, "Cassini-Soldner"), new IdentifierCode(Citations.EPSG, 9806), new NamedIdentifier(Citations.ESRI, "Cassini"), new NamedIdentifier(Citations.GEOTIFF, "CT_CassiniSoldner"), new IdentifierCode(Citations.GEOTIFF, 18), new NamedIdentifier(Citations.PROJ4, "cass"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational(25))}, null, new ParameterDescriptor[]{CassiniSoldner.sameParameterAs(EquidistantCylindrical.PARAMETERS, "semi_major"), CassiniSoldner.sameParameterAs(EquidistantCylindrical.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

