/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.LambertConformal2SP;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.referencing.operation.provider.ObliqueMercator;
import org.geotoolkit.referencing.operation.provider.PseudoMercator;
import org.geotoolkit.referencing.operation.provider.Stereographic;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class PolarStereographic
extends Stereographic {
    private static final long serialVersionUID = 9124091259039220308L;
    @Deprecated
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptorGroup PARAMETERS;

    public PolarStereographic() {
        super(PARAMETERS);
    }

    PolarStereographic(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.PolarStereographic.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF};
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of natural origin", "central_meridian", "StraightVertPoleLong");
        LATITUDE_OF_ORIGIN = Mercator1SP.LATITUDE_OF_ORIGIN;
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Polar_Stereographic"), new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant A)"), new IdentifierCode(Citations.EPSG, 9810), new NamedIdentifier(Citations.GEOTIFF, "CT_PolarStereographic"), new IdentifierCode(Citations.GEOTIFF, 15), PolarStereographic.sameNameAs(Citations.PROJ4, Stereographic.PARAMETERS), PolarStereographic.sameNameAs(Citations.GEOTOOLKIT, Stereographic.PARAMETERS)}, citationArray, new ParameterDescriptor[]{PolarStereographic.sameParameterAs(Mercator1SP.PARAMETERS, "semi_major"), PolarStereographic.sameParameterAs(Mercator1SP.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, Mercator1SP.FALSE_EASTING, Mercator1SP.FALSE_NORTHING}, 1);
    }

    @Immutable
    public static class South
    extends PolarStereographic {
        private static final long serialVersionUID = 6537800238416448564L;
        @Deprecated
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
        public static final ParameterDescriptorGroup PARAMETERS;

        public South() {
            super(PARAMETERS);
        }

        static {
            Citation[] citationArray = new Citation[]{Citations.EPSG, Citations.OGC, Citations.NETCDF, Citations.GEOTIFF, Citations.PROJ4};
            STANDARD_PARALLEL = UniversalParameters.STANDARD_PARALLEL_1.select(false, -90.0, citationArray, null, "Standard_Parallel_1");
            PARAMETERS = UniversalParameters.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_South_Pole"), South.sameNameAs(Citations.GEOTOOLKIT, PARAMETERS)}, null, new ParameterDescriptor[]{South.sameParameterAs(North.PARAMETERS, "semi_major"), South.sameParameterAs(North.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, South.sameParameterAs(North.PARAMETERS, "central_meridian"), STANDARD_PARALLEL, South.sameParameterAs(North.PARAMETERS, "scale_factor"), South.sameParameterAs(North.PARAMETERS, "false_easting"), South.sameParameterAs(North.PARAMETERS, "false_northing")}, 1);
        }
    }

    @Immutable
    public static class North
    extends PolarStereographic {
        private static final long serialVersionUID = 657493908431273866L;
        @Deprecated
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
        public static final ParameterDescriptorGroup PARAMETERS;

        public North() {
            super(PARAMETERS);
        }

        static {
            Citation[] citationArray = new Citation[]{Citations.EPSG, Citations.OGC, Citations.NETCDF, Citations.GEOTIFF, Citations.PROJ4};
            STANDARD_PARALLEL = UniversalParameters.STANDARD_PARALLEL_1.select(false, 90.0, citationArray, null, "Standard_Parallel_1");
            PARAMETERS = UniversalParameters.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_North_Pole"), North.sameNameAs(Citations.GEOTOOLKIT, PARAMETERS)}, citationArray, new ParameterDescriptor[]{North.sameParameterAs(ObliqueMercator.TwoPoint.PARAMETERS, "semi_major"), North.sameParameterAs(ObliqueMercator.TwoPoint.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, Stereographic.CENTRAL_MERIDIAN, STANDARD_PARALLEL, North.sameParameterAs(LambertConformal2SP.PARAMETERS, "scale_factor"), North.sameParameterAs(ObliqueMercator.TwoPoint.PARAMETERS, "false_easting"), North.sameParameterAs(ObliqueMercator.TwoPoint.PARAMETERS, "false_northing")}, 1);
        }
    }

    @Immutable
    public static class VariantB
    extends PolarStereographic {
        private static final long serialVersionUID = 5188231050523249971L;
        @Deprecated
        public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
        @Deprecated
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
        public static final ParameterDescriptorGroup PARAMETERS;

        public VariantB() {
            super(PARAMETERS);
        }

        static {
            Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF, Citations.GEOTIFF, Citations.PROJ4};
            CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of origin", "central_meridian");
            STANDARD_PARALLEL = UniversalParameters.STANDARD_PARALLEL_1.select(false, 90.0, citationArray, null, "Latitude of standard parallel", "standard_parallel_1");
            PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant B)"), new IdentifierCode(Citations.EPSG, 9829), VariantB.sameNameAs(Citations.GEOTOOLKIT, PARAMETERS)}, citationArray, new ParameterDescriptor[]{VariantB.sameParameterAs(PseudoMercator.PARAMETERS, "semi_major"), VariantB.sameParameterAs(PseudoMercator.PARAMETERS, "semi_minor"), ROLL_LONGITUDE, CENTRAL_MERIDIAN, STANDARD_PARALLEL, VariantB.sameParameterAs(PseudoMercator.PARAMETERS, "false_easting"), VariantB.sameParameterAs(PseudoMercator.PARAMETERS, "false_northing")}, 1);
        }
    }
}

