/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

@Immutable
public class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform,
Parameterized,
Formattable,
Cloneable {
    private static final long serialVersionUID = -5299837898367149069L;
    private volatile transient AffineTransform2D inverse;
    transient boolean mutable;

    AffineTransform2D() {
    }

    public AffineTransform2D(AffineTransform affineTransform) {
        super(affineTransform);
        this.mutable = true;
        this.forcePositiveZeros();
        this.mutable = false;
    }

    public AffineTransform2D(double d, double d2, double d3, double d4, double d5, double d6) {
        super(AffineTransform2D.pz(d), AffineTransform2D.pz(d2), AffineTransform2D.pz(d3), AffineTransform2D.pz(d4), AffineTransform2D.pz(d5), AffineTransform2D.pz(d6));
    }

    private static double pz(double d) {
        return d != 0.0 ? d : 0.0;
    }

    final void forcePositiveZeros() {
        super.setTransform(AffineTransform2D.pz(super.getScaleX()), AffineTransform2D.pz(super.getShearY()), AffineTransform2D.pz(super.getShearX()), AffineTransform2D.pz(super.getScaleY()), AffineTransform2D.pz(super.getTranslateX()), AffineTransform2D.pz(super.getTranslateY()));
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        if (!this.mutable) {
            super.checkPermission();
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        ArgumentChecks.ensureDimensionMatches("ptSrc", directPosition, 2);
        if (directPosition2 == directPosition) {
            if (directPosition instanceof Point2D) {
                Point2D point2D = (Point2D)((Object)directPosition);
                super.transform(point2D, point2D);
                return directPosition;
            }
        } else {
            if (directPosition2 == null) {
                DirectPosition2D directPosition2D = new DirectPosition2D(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                super.transform(directPosition2D, directPosition2D);
                return directPosition2D;
            }
            ArgumentChecks.ensureDimensionMatches("ptDst", directPosition2, 2);
            if (directPosition2 instanceof Point2D) {
                Point2D point2D = (Point2D)((Object)directPosition2);
                point2D.setLocation(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                super.transform(point2D, point2D);
                return directPosition2;
            }
        }
        Point2D.Double double_ = new Point2D.Double(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
        super.transform(double_, double_);
        directPosition2.setOrdinate(0, double_.x);
        directPosition2.setOrdinate(1, double_.y);
        return directPosition2;
    }

    @Override
    public Shape createTransformedShape(Shape shape) {
        return AffineTransform2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix3(this);
    }

    @Override
    public Matrix derivative(Point2D point2D) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (super.isIdentity()) {
                this.inverse = this;
            } else {
                AffineTransform2D affineTransform2D = this;
                synchronized (affineTransform2D) {
                    if (this.inverse == null) {
                        try {
                            AffineTransform2D affineTransform2D2 = new AffineTransform2D(this);
                            affineTransform2D2.mutable = true;
                            affineTransform2D2.invert();
                            affineTransform2D2.forcePositiveZeros();
                            affineTransform2D2.mutable = false;
                            affineTransform2D2.inverse = this;
                            this.inverse = affineTransform2D2;
                        }
                        catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                            throw new NoninvertibleTransformException(noninvertibleTransformException.getLocalizedMessage(), noninvertibleTransformException);
                        }
                    }
                }
            }
        }
        return this.inverse;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (comparisonMode == ComparisonMode.STRICT) {
            return this.equals(object);
        }
        return object == this || AbstractMathTransform.equals(this, object, comparisonMode);
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!super.equals(object)) {
                return false;
            }
            if (object instanceof AffineTransform2D) {
                return object.getClass() == this.getClass();
            }
        }
        return true;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    @Override
    public String formatWKT(Formatter formatter) {
        ParameterValueGroup parameterValueGroup = this.getParameterValues();
        formatter.append(formatter.getName(parameterValueGroup.getDescriptor()));
        formatter.append(parameterValueGroup);
        return "PARAM_MT";
    }

    @Override
    public String toWKT() {
        Formatter formatter = new Formatter();
        formatter.append(this);
        return formatter.toString();
    }

    @Override
    public String toString() {
        return this.toWKT();
    }
}

