/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.cat30.Namespaces;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.URIUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidationUtils {
    static final String ROOT_PKG = "/org/opengis/cite/cat30/";
    static final String FACTORY_RELAXNG_COMPACT = "com.thaiopensource.relaxng.jaxp.CompactSyntaxSchemaFactory";
    private static final XMLCatalogResolver SCH_RESOLVER = ValidationUtils.initCatalogResolver();

    private static XMLCatalogResolver initCatalogResolver() {
        return (XMLCatalogResolver)ValidationUtils.createSchemaResolver(Namespaces.SCH);
    }

    public static LSResourceResolver createSchemaResolver(URI schemaLanguage) {
        String catalogFileName = schemaLanguage.equals(Namespaces.XSD) ? "schema-catalog.xml" : "schematron-catalog.xml";
        URL catalogURL = ValidationUtils.class.getResource(ROOT_PKG + catalogFileName);
        XMLCatalogResolver resolver2 = new XMLCatalogResolver();
        resolver2.setCatalogList(new String[]{catalogURL.toString()});
        return resolver2;
    }

    public static SchematronValidator buildSchematronValidator(String schemaRef, String phase) {
        StreamSource source = null;
        try {
            String catalogRef = SCH_RESOLVER.resolveSystem(schemaRef);
            source = null != catalogRef ? new StreamSource(URI.create(catalogRef).toString()) : new StreamSource(schemaRef);
        }
        catch (IOException x) {
            TestSuiteLogger.log(Level.WARNING, "Error reading Schematron schema catalog.", x);
        }
        SchematronValidator validator = null;
        try {
            validator = new SchematronValidator(source, phase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Error creating Schematron validator.", e);
        }
        return validator;
    }

    public static Set<URI> extractSchemaReferences(Source source, String baseURI) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(source);
        StartElement docElem = reader.nextTag().asStartElement();
        Attribute schemaLoc = docElem.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        if (null == schemaLoc) {
            throw new RuntimeException("No xsi:schemaLocation attribute found. See ISO 19136, A.3.1.");
        }
        Object[] uriValues = schemaLoc.getValue().split("\\s+");
        if (uriValues.length % 2 != 0) {
            throw new RuntimeException("xsi:schemaLocation attribute contains an odd number of URI values:\n" + Arrays.toString(uriValues));
        }
        HashSet<URI> schemaURIs = new HashSet<URI>();
        for (int i = 0; i < uriValues.length; i += 2) {
            URI schemaURI = null;
            if (!URI.create((String)uriValues[i + 1]).isAbsolute() && null != source.getSystemId()) {
                String schemaRef = URIUtils.resolveRelativeURI(source.getSystemId(), (String)uriValues[i + 1]).toString();
                if (schemaRef.startsWith("file") && !new File(schemaRef).exists() && null != baseURI) {
                    schemaRef = URIUtils.resolveRelativeURI(baseURI, (String)uriValues[i + 1]).toString();
                }
                schemaURI = URI.create(schemaRef);
            } else {
                schemaURI = URI.create((String)uriValues[i + 1]);
            }
            schemaURIs.add(schemaURI);
        }
        return schemaURIs;
    }

    public static Schema createCSWSchema() {
        URL entityCatalog = ValidationUtils.class.getResource("/org/opengis/cite/cat30/schema-catalog.xml");
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(entityCatalog);
        Schema appSchema = null;
        try {
            URL schemaRef = ValidationUtils.class.getResource("/org/opengis/cite/cat30/xsd/opengis/cat/csw/3.0/csw-3.0.xsd");
            StreamSource xsdSource = new StreamSource(schemaRef.toString());
            appSchema = xsdCompiler.compileXmlSchema(xsdSource);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create CSW Schema object.", e);
        }
        return appSchema;
    }

    public static Schema createAtomSchema() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.iana.org/assignments/media-types/application/relax-ng-compact-syntax", FACTORY_RELAXNG_COMPACT, null);
        URL schemaRef = ValidationUtils.class.getResource("/org/opengis/cite/cat30/rnc/atom.rnc");
        Schema schema = null;
        try {
            schema = factory.newSchema(schemaRef);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create Atom Schema object from RELAX NG (compact) grammar", e);
        }
        return schema;
    }

    public static Schema createOpenSearchSchema() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.iana.org/assignments/media-types/application/relax-ng-compact-syntax", FACTORY_RELAXNG_COMPACT, null);
        URL schemaRef = ValidationUtils.class.getResource("/org/opengis/cite/cat30/rnc/osd-1.1-draft5.rnc");
        Schema schema = null;
        try {
            schema = factory.newSchema(schemaRef);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create OpenSearch Schema object from RELAX NG (compact) grammar", e);
        }
        return schema;
    }
}

