/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.storage;

import java.util.HashSet;
import java.util.Set;
import org.geotoolkit.storage.StorageEvent;
import org.geotoolkit.storage.StorageListener;

public abstract class AbstractStorage {
    protected final Set<StorageListener> listeners = new HashSet<StorageListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStorageListener(StorageListener listener) {
        Set<StorageListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorageListener(StorageListener listener) {
        Set<StorageListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStructureEvent(StorageEvent event) {
        StorageListener[] lst;
        Set<StorageListener> set = this.listeners;
        synchronized (set) {
            lst = this.listeners.toArray(new StorageListener[this.listeners.size()]);
        }
        for (StorageListener listener : lst) {
            listener.structureChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendContentEvent(StorageEvent event) {
        StorageListener[] lst;
        Set<StorageListener> set = this.listeners;
        synchronized (set) {
            lst = this.listeners.toArray(new StorageListener[this.listeners.size()]);
        }
        for (StorageListener listener : lst) {
            listener.contentChanged(event);
        }
    }

    public void forwardStructureEvent(StorageEvent event) {
        this.sendStructureEvent(event.copy(this));
    }

    public void forwardContentEvent(StorageEvent event) {
        this.sendContentEvent(event.copy(this));
    }
}

