/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.EpsgScriptRunner;
import org.geotoolkit.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.NullArgumentException;
import org.opengis.util.FactoryException;

@ThreadSafe
public class EpsgInstaller
implements Callable<Result> {
    public static final String DEFAULT_SCHEMA = "epsg";
    private String schema = "epsg";
    private File scriptsDirectory;
    private String databaseURL;
    private String user;
    private String password;
    private Connection userConnection;

    public synchronized void setScriptDirectory(File file) {
        this.scriptsDirectory = file;
    }

    public synchronized void setDatabase(String string) {
        this.databaseURL = string;
        this.userConnection = null;
    }

    public synchronized void setDatabase(String string, String string2, String string3) {
        this.databaseURL = string;
        this.user = string2;
        this.password = string3;
        this.userConnection = null;
    }

    public synchronized void setDatabase(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"connection"));
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.databaseURL = databaseMetaData.getURL();
        this.user = databaseMetaData.getUserName();
        this.password = null;
        this.userConnection = connection;
    }

    public synchronized void setSchema(String string) {
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        this.schema = string;
    }

    private String getSchema(DatabaseMetaData databaseMetaData) throws SQLException {
        if (!databaseMetaData.supportsSchemasInTableDefinitions() || !databaseMetaData.supportsSchemasInDataManipulation()) {
            return null;
        }
        String string = this.schema;
        if (string == null) {
            string = "";
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string = string.toUpperCase(Locale.CANADA);
        } else if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string = string.toLowerCase(Locale.CANADA);
        }
        return string;
    }

    private Connection getConnection(boolean bl) throws IOException, SQLException {
        if (this.databaseURL == null) {
            this.databaseURL = ThreadedEpsgFactory.getDefaultURL(bl);
        }
        Connection connection = this.user == null ? DriverManager.getConnection(this.databaseURL) : DriverManager.getConnection(this.databaseURL, this.user, this.password);
        return connection;
    }

    private static void shutdown(Connection connection, String string) throws SQLException {
        Dialect dialect = Dialect.forURL((String)string);
        if (dialect != null) {
            dialect.shutdown(connection, string, true);
        } else {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean exists() throws FactoryException {
        Exception exception;
        block8: {
            boolean bl;
            Connection connection = null;
            connection = this.getConnection(false);
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                bl = AnsiDialectEpsgFactory.exists(databaseMetaData, this.getSchema(databaseMetaData));
            }
            catch (Throwable throwable) {
                try {
                    connection.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    exception = iOException;
                    break block8;
                }
                catch (SQLTransientException sQLTransientException) {
                    exception = sQLTransientException;
                    break block8;
                }
                catch (SQLException sQLException) {
                    if (connection == null) {
                        return false;
                    }
                    exception = sQLException;
                }
            }
            connection.close();
            return bl;
        }
        throw new FactoryException(exception.getLocalizedMessage(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Result call() throws FactoryException {
        String string;
        Exception exception;
        EpsgScriptRunner epsgScriptRunner;
        block10: {
            Result result;
            block9: {
                epsgScriptRunner = null;
                Connection connection = this.userConnection;
                if (connection == null) {
                    connection = this.getConnection(true);
                }
                try {
                    epsgScriptRunner = new EpsgScriptRunner(connection);
                    result = this.call(epsgScriptRunner);
                    if (connection == this.userConnection) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != this.userConnection) {
                            EpsgInstaller.shutdown(connection, this.databaseURL);
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        exception = sQLException;
                        break block10;
                    }
                    catch (IOException iOException) {
                        exception = iOException;
                    }
                }
                EpsgInstaller.shutdown(connection, this.databaseURL);
            }
            return result;
        }
        String string2 = exception.getLocalizedMessage();
        if (epsgScriptRunner != null && (string = epsgScriptRunner.getCurrentPosition()) != null) {
            string2 = string2 + '\n' + string;
        }
        throw new FactoryException(string2, exception);
    }

    final synchronized Result call(EpsgScriptRunner epsgScriptRunner) throws SQLException, IOException {
        long l = System.currentTimeMillis();
        int n = 0;
        if (this.schema != null) {
            epsgScriptRunner.setSchema(this.schema);
        }
        if (this.scriptsDirectory != null) {
            n += epsgScriptRunner.run(this.scriptsDirectory);
        } else {
            LogRecord logRecord = Loggings.format((Level)Level.INFO, (int)20, (Object)"7.09");
            logRecord.setSourceMethodName("call");
            logRecord.setSourceClassName(EpsgInstaller.class.getName());
            logRecord.setLoggerName(ThreadedEpsgFactory.LOGGER.getName());
            ThreadedEpsgFactory.LOGGER.log(logRecord);
            for (String string : epsgScriptRunner.getScriptFiles()) {
                InputStream inputStream = EpsgScriptRunner.class.getResourceAsStream(string = string + ".sql");
                if (inputStream == null) {
                    throw new FileNotFoundException(Errors.format((int)64, (Object)string));
                }
                n += epsgScriptRunner.run(inputStream);
            }
        }
        epsgScriptRunner.close(this.userConnection == null);
        return new Result(n, System.currentTimeMillis() - l);
    }

    public static final class Result {
        public final int numRows;
        public final long elapsedTime;

        Result(int n, long l) {
            this.numRows = n;
            this.elapsedTime = l;
        }

        public String toString() {
            return Descriptions.format((int)9, (Object)this.numRows, (Object)((double)this.elapsedTime / 1000.0));
        }
    }
}

