/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.XArrays;

public final class Listeners
extends Static {
    private Listeners() {
    }

    public static ChangeListener[] addListener(ChangeListener changeListener, ChangeListener[] changeListenerArray) {
        int n;
        ArgumentChecks.ensureNonNull("listener", changeListener);
        if (changeListenerArray == null) {
            n = 0;
            changeListenerArray = new ChangeListener[1];
        } else {
            n = changeListenerArray.length;
            changeListenerArray = Arrays.copyOf(changeListenerArray, n + 1);
        }
        changeListenerArray[n] = changeListener;
        return changeListenerArray;
    }

    public static ChangeListener[] removeListener(ChangeListener changeListener, ChangeListener[] changeListenerArray) {
        if (changeListenerArray != null) {
            for (int i = 0; i < changeListenerArray.length; ++i) {
                if (changeListenerArray[i] != changeListener) continue;
                if ((changeListenerArray = XArrays.remove(changeListenerArray, i, 1)).length != 0) break;
                changeListenerArray = null;
                break;
            }
        }
        return changeListenerArray;
    }

    public static void fireChanged(Object object, ChangeListener[] changeListenerArray) {
        if (changeListenerArray != null) {
            ChangeEvent changeEvent = new ChangeEvent(object);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

