/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.measure.RangeSymbols;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.DateRange;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.AnyConverter;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;

public class RangeFormat
extends Format {
    private static final long serialVersionUID = 6700474540675919894L;
    public static final int MIN_VALUE_FIELD = 0;
    public static final int MAX_VALUE_FIELD = 0x40000000;
    public static final int UNIT_FIELD = 0x20000000;
    private RangeSymbols symbols;
    private final char minusSign;
    private final String infinity;
    protected final Class<?> elementClass;
    protected final Format elementFormat;
    protected final UnitFormat unitFormat;
    private transient AnyConverter converter;

    public static RangeFormat getInstance() {
        return new RangeFormat();
    }

    public static RangeFormat getInstance(Locale locale) {
        return new RangeFormat(locale);
    }

    public RangeFormat() {
        this(Locale.getDefault());
    }

    public RangeFormat(Locale locale) {
        this(locale, Number.class);
    }

    public RangeFormat(Locale locale, TimeZone timeZone) {
        this(locale, Date.class);
        ((DateFormat)this.elementFormat).setTimeZone(timeZone);
    }

    public RangeFormat(Locale locale, Class<?> clazz) throws IllegalArgumentException {
        this.elementClass = clazz;
        if (Angle.class.isAssignableFrom(clazz)) {
            this.elementFormat = AngleFormat.getInstance(locale);
            this.unitFormat = null;
        } else if (Number.class.isAssignableFrom(clazz)) {
            this.elementFormat = NumberFormat.getNumberInstance(locale);
            this.unitFormat = UnitFormat.getInstance((Locale)locale);
        } else if (Date.class.isAssignableFrom(clazz)) {
            this.elementFormat = DateFormat.getDateTimeInstance(3, 3, locale);
            this.unitFormat = null;
        } else {
            throw new IllegalArgumentException(Errors.format(226, clazz));
        }
        DecimalFormatSymbols decimalFormatSymbols = this.elementFormat instanceof DecimalFormat ? ((DecimalFormat)this.elementFormat).getDecimalFormatSymbols() : DecimalFormatSymbols.getInstance(locale);
        this.minusSign = decimalFormatSymbols.getMinusSign();
        this.infinity = decimalFormatSymbols.getInfinity();
        this.symbols = new RangeSymbols();
    }

    public RangeSymbols getSymbols() {
        return this.symbols.clone();
    }

    public void setSymbols(RangeSymbols rangeSymbols) {
        this.symbols = rangeSymbols.clone();
    }

    public String getElementPattern(boolean bl) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            return bl ? decimalFormat.toLocalizedPattern() : decimalFormat.toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            return bl ? simpleDateFormat.toLocalizedPattern() : simpleDateFormat.toPattern();
        }
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        return null;
    }

    public void setElementPattern(String string, boolean bl) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            if (bl) {
                decimalFormat.applyLocalizedPattern(string);
            } else {
                decimalFormat.applyPattern(string);
            }
        } else if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            if (bl) {
                simpleDateFormat.applyLocalizedPattern(string);
            } else {
                simpleDateFormat.applyPattern(string);
            }
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(string);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Unit<?> unit;
        boolean bl;
        FieldPosition fieldPosition2;
        FieldPosition fieldPosition3;
        if (!(object instanceof Range)) {
            String string = object == null ? Errors.format(172, "range") : Errors.format(256, "range", object.getClass(), Range.class);
            throw new IllegalArgumentException(string);
        }
        Range range = (Range)object;
        RangeSymbols rangeSymbols = this.symbols;
        if (range.isEmpty()) {
            stringBuffer.append(rangeSymbols.openInclusive);
            int n = stringBuffer.length();
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(n);
            return stringBuffer.append(rangeSymbols.closeInclusive);
        }
        int n = fieldPosition.getField();
        if ((n & 0x40000000) == 0) {
            fieldPosition3 = fieldPosition;
            fieldPosition2 = new FieldPosition(n);
        } else {
            fieldPosition2 = fieldPosition3 = new FieldPosition(n & 0xBFFFFFFF);
        }
        Object t = range.getMinValue();
        Object t2 = range.getMaxValue();
        if (t != null && t.equals(t2)) {
            this.elementFormat.format(t, stringBuffer, fieldPosition3);
        } else {
            stringBuffer.append(range.isMinIncluded() ? rangeSymbols.openInclusive : rangeSymbols.openExclusive);
            if (t == null) {
                stringBuffer.append(this.minusSign);
                fieldPosition3.setBeginIndex(stringBuffer.length());
                stringBuffer.append(this.infinity);
                fieldPosition3.setEndIndex(stringBuffer.length());
            } else {
                this.elementFormat.format(t, stringBuffer, fieldPosition3);
            }
            stringBuffer.append(' ').append(rangeSymbols.separator).append(' ');
            if (t2 == null) {
                fieldPosition2.setBeginIndex(stringBuffer.length());
                stringBuffer.append(this.infinity);
                fieldPosition2.setEndIndex(stringBuffer.length());
            } else {
                this.elementFormat.format(t2, stringBuffer, fieldPosition2);
            }
            stringBuffer.append(range.isMaxIncluded() ? rangeSymbols.closeInclusive : rangeSymbols.closeExclusive);
        }
        if (fieldPosition != fieldPosition3) {
            fieldPosition.setBeginIndex(fieldPosition2.getBeginIndex());
            fieldPosition.setEndIndex(fieldPosition2.getEndIndex());
        }
        boolean bl2 = bl = fieldPosition.getField() == 0x20000000;
        if (this.unitFormat != null && object instanceof MeasurementRange && (unit = ((MeasurementRange)object).getUnits()) != null) {
            stringBuffer.append(' ');
            if (bl) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            this.unitFormat.format(unit, stringBuffer, fieldPosition);
            if (bl) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            return stringBuffer;
        }
        if (bl) {
            int n2 = stringBuffer.length();
            fieldPosition.setBeginIndex(n2);
            fieldPosition.setEndIndex(n2);
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.parse(string);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Range<?> parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        NonconvertibleObjectException nonconvertibleObjectException = null;
        try {
            Range<?> range = this.tryParse(string, parsePosition);
            if (range != null) {
                return range;
            }
        }
        catch (NonconvertibleObjectException nonconvertibleObjectException2) {
            nonconvertibleObjectException = nonconvertibleObjectException2;
        }
        int n = parsePosition.getErrorIndex();
        ParseException parseException = new ParseException(Errors.format(233, string, Strings.token(string, n)), n);
        parseException.initCause(nonconvertibleObjectException);
        throw parseException;
    }

    public Range<?> parse(String string, ParsePosition parsePosition) {
        Range<?> range;
        int n = parsePosition.getIndex();
        try {
            range = this.tryParse(string, parsePosition);
        }
        catch (NonconvertibleObjectException nonconvertibleObjectException) {
            range = null;
        }
        if (range != null) {
            parsePosition.setErrorIndex(-1);
        } else {
            parsePosition.setIndex(n);
        }
        return range;
    }

    private Range<?> tryParse(String string, ParsePosition parsePosition) throws NonconvertibleObjectException {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        Object object4;
        char c;
        int n = string.length();
        int n2 = parsePosition.getIndex();
        do {
            if (n2 < n) continue;
            parsePosition.setErrorIndex(n);
            return null;
        } while (Character.isWhitespace(c = string.charAt(n2++)));
        RangeSymbols rangeSymbols = this.symbols;
        if (!rangeSymbols.isOpen(c)) {
            parsePosition.setIndex(n2 - 1);
            object4 = this.elementFormat.parseObject(string, parsePosition);
            if (object4 == null) {
                return null;
            }
            parsePosition.setErrorIndex(n2 - 1);
            object2 = object3 = this.convert(object4);
            bl2 = true;
            bl = true;
            n2 = parsePosition.getIndex();
        } else {
            boolean bl3 = bl = c == rangeSymbols.openInclusive;
            do {
                if (n2 < n) continue;
                parsePosition.setErrorIndex(n);
                return null;
            } while (Character.isWhitespace(c = string.charAt(n2++)));
            if (rangeSymbols.isClose(c)) {
                parsePosition.setIndex(n2);
                parsePosition.setErrorIndex(n2 - 1);
                object2 = object3 = this.convert(0);
                bl2 = false;
            } else {
                parsePosition.setIndex(n2 - 1);
                object4 = this.elementFormat.parseObject(string, parsePosition);
                if (object4 == null) {
                    if (c != this.minusSign) {
                        --n2;
                    }
                    if (!string.regionMatches(n2, this.infinity, 0, this.infinity.length())) {
                        return null;
                    }
                    parsePosition.setIndex(n2 += this.infinity.length());
                }
                parsePosition.setErrorIndex(n2 - 1);
                object2 = this.convert(object4);
                n2 = parsePosition.getIndex();
                do {
                    if (n2 < n) continue;
                    parsePosition.setErrorIndex(n);
                    return null;
                } while (Character.isWhitespace(c = string.charAt(n2++)));
                object = rangeSymbols.separator;
                if (string.regionMatches(n2 - 1, (String)object, 0, ((String)object).length())) {
                    n2 += ((String)object).length() - 1;
                    do {
                        if (n2 < n) continue;
                        parsePosition.setErrorIndex(n);
                        return null;
                    } while (Character.isWhitespace(c = string.charAt(n2++)));
                    parsePosition.setIndex(n2 - 1);
                    object4 = this.elementFormat.parseObject(string, parsePosition);
                    if (object4 == null) {
                        if (!string.regionMatches(--n2, this.infinity, 0, this.infinity.length())) {
                            return null;
                        }
                        parsePosition.setIndex(n2 += this.infinity.length());
                    }
                    parsePosition.setErrorIndex(n2 - 1);
                    object3 = this.convert(object4);
                    n2 = parsePosition.getIndex();
                    do {
                        if (n2 < n) continue;
                        parsePosition.setErrorIndex(n);
                        return null;
                    } while (Character.isWhitespace(c = string.charAt(n2++)));
                } else {
                    object3 = object2;
                }
                if (!rangeSymbols.isClose(c)) {
                    parsePosition.setErrorIndex(n2 - 1);
                    return null;
                }
                bl2 = c == rangeSymbols.closeInclusive;
            }
            parsePosition.setIndex(n2);
        }
        object4 = null;
        if (this.unitFormat != null) {
            while (n2 < n) {
                if (Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                    continue;
                }
                parsePosition.setIndex(n2);
                break;
            }
        }
        if (Number.class.isAssignableFrom(this.elementClass)) {
            object = this.elementClass;
            Number number = (Number)object2;
            Number number2 = (Number)object3;
            if (object == Number.class) {
                object = Numbers.widestClass(Numbers.finestClass(number), Numbers.finestClass(number2));
                number = Numbers.cast(number, object);
                number2 = Numbers.cast(number2, object);
            }
            if (number.doubleValue() == Double.NEGATIVE_INFINITY) {
                number = null;
            }
            if (number2.doubleValue() == Double.POSITIVE_INFINITY) {
                number2 = null;
            }
            if (object4 != null) {
                MeasurementRange<Number> measurementRange = new MeasurementRange<Number>((Class<Number>)object, number, bl, number2, bl2, (Unit<?>)object4);
                return measurementRange;
            }
            NumberRange<Number> numberRange = new NumberRange<Number>((Class<Number>)object, number, bl, number2, bl2);
            return numberRange;
        }
        if (Date.class.isAssignableFrom(this.elementClass)) {
            object = (Date)object2;
            Date date = (Date)object3;
            return new DateRange((Date)object, bl, date, bl2);
        }
        object = this.elementClass;
        Comparable comparable = (Comparable)object2;
        Comparable comparable2 = (Comparable)object3;
        Range<Comparable> range = new Range<Comparable>((Class<Comparable>)object, comparable, bl, comparable2, bl2);
        return range;
    }

    private Object convert(Object object) throws NonconvertibleObjectException {
        if (this.elementClass.isInstance(object)) {
            return object;
        }
        if (this.converter == null) {
            this.converter = new AnyConverter();
        }
        return this.converter.convert(object, this.elementClass);
    }
}

