/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.util.logging.Logger;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.geotoolkit.gml.xml.v311.CurveType;
import org.geotoolkit.gml.xml.v311.LineStringType;
import org.geotoolkit.gml.xml.v311.MultiCurveType;
import org.geotoolkit.gml.xml.v311.MultiGeometryType;
import org.geotoolkit.gml.xml.v311.MultiLineStringType;
import org.geotoolkit.gml.xml.v311.MultiPointType;
import org.geotoolkit.gml.xml.v311.MultiPolygonType;
import org.geotoolkit.gml.xml.v311.MultiSolidType;
import org.geotoolkit.gml.xml.v311.MultiSurfaceType;
import org.geotoolkit.gml.xml.v311.ObjectFactory;
import org.geotoolkit.gml.xml.v311.PointType;
import org.geotoolkit.gml.xml.v311.PolygonType;
import org.geotoolkit.gml.xml.v311.SurfaceType;
import org.geotoolkit.internal.jaxb.RegisterableAdapter;
import org.geotoolkit.internal.jaxb.geometry.GM_Object;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.Geometry;

public final class GmlGeometryAdapter
extends GM_Object
implements RegisterableAdapter {
    private static final Logger LOGGER = Logging.getLogger(GmlGeometryAdapter.class);

    public GmlGeometryAdapter() {
    }

    protected GmlGeometryAdapter(Geometry metadata) {
        ObjectFactory factory = new ObjectFactory();
        if (metadata instanceof PointType) {
            this.geometry = factory.createPoint((PointType)metadata);
        } else if (metadata instanceof MultiSurfaceType) {
            this.geometry = factory.createMultiSurface((MultiSurfaceType)metadata);
        } else if (metadata instanceof CurveType) {
            this.geometry = factory.createCurve((CurveType)metadata);
        } else if (metadata instanceof LineStringType) {
            this.geometry = factory.createLineString((LineStringType)metadata);
        } else if (metadata instanceof MultiLineStringType) {
            this.geometry = factory.createMultiLineString((MultiLineStringType)metadata);
        } else if (metadata instanceof MultiPointType) {
            this.geometry = factory.createMultiPoint((MultiPointType)metadata);
        } else if (metadata instanceof MultiCurveType) {
            this.geometry = factory.createMultiCurve((MultiCurveType)metadata);
        } else if (metadata instanceof MultiGeometryType) {
            this.geometry = factory.createMultiGeometry((MultiGeometryType)metadata);
        } else if (metadata instanceof MultiSolidType) {
            this.geometry = factory.createMultiSolid((MultiSolidType)metadata);
        } else if (metadata instanceof MultiPolygonType) {
            this.geometry = factory.createMultiPolygon((MultiPolygonType)metadata);
        } else if (metadata instanceof MultiPolygonType) {
            this.geometry = factory.createMultiPolygon((MultiPolygonType)metadata);
        } else if (metadata instanceof PolygonType) {
            this.geometry = factory.createPolygon((PolygonType)metadata);
        } else if (metadata instanceof SurfaceType) {
            this.geometry = factory.createSurface((SurfaceType)metadata);
        } else if (metadata != null) {
            LOGGER.warning("Unexpected geometry class in geometryAdpater:" + metadata.getClass().getName());
        }
    }

    public void register(Marshaller marshaller) {
        marshaller.setAdapter(GM_Object.class, (XmlAdapter)this);
    }

    public void register(Unmarshaller unmarshaller) {
        unmarshaller.setAdapter(GM_Object.class, (XmlAdapter)this);
    }

    @Override
    protected GM_Object wrap(Geometry value) {
        return new GmlGeometryAdapter(value);
    }
}

