/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.internal.referencing.DeprecatedName;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.MapProjectionDescriptor;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public final class UniversalParameters
extends DefaultParameterDescriptor<Double> {
    private static final long serialVersionUID = -4608976443553166518L;
    public static final UniversalParameters SEMI_MAJOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier((Citation)Citations.EPSG, "Semi-major axis"), new NamedIdentifier(Citations.ESRI, "Semi_Major"), new NamedIdentifier(Citations.NETCDF, "semi_major_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMajor"), new NamedIdentifier((Citation)Citations.PROJ4, "a")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
    public static final UniversalParameters SEMI_MINOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier((Citation)Citations.EPSG, "Semi-minor axis"), new NamedIdentifier(Citations.ESRI, "Semi_Minor"), new NamedIdentifier(Citations.NETCDF, "semi_minor_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMinor"), new NamedIdentifier((Citation)Citations.PROJ4, "b")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
    static final ParameterDescriptor<Double> EARTH_RADIUS = UniversalParameters.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.NETCDF, "earth_radius")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE, false);
    static final ParameterDescriptor<Double> INVERSE_FLATTENING = UniversalParameters.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.NETCDF, "inverse_flattening")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, Unit.ONE, false);
    public static final ParameterDescriptor<Boolean> ROLL_LONGITUDE = new DefaultParameterDescriptor<Object>(Citations.GEOTOOLKIT, "roll_longitude", Boolean.class, null, null, null, null, null, false);
    public static final UniversalParameters CENTRAL_MERIDIAN = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "central_meridian"), new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier((Citation)Citations.EPSG, "Longitude of origin"), new NamedIdentifier((Citation)Citations.EPSG, "Longitude of false origin"), new NamedIdentifier((Citation)Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier((Citation)Citations.EPSG, "Spherical longitude of origin"), new NamedIdentifier((Citation)Citations.EPSG, "Longitude of projection centre"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(Citations.NETCDF, "longitude_of_projection_origin"), new NamedIdentifier(Citations.NETCDF, "longitude_of_central_meridian"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLong"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginLong"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLong"), new NamedIdentifier(Citations.GEOTIFF, "CenterLong"), new NamedIdentifier(Citations.GEOTIFF, "StraightVertPoleLong"), new NamedIdentifier((Citation)Citations.PROJ4, "lon_0")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
    public static final UniversalParameters LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<double[]> STANDARD_PARALLEL;
    public static final UniversalParameters STANDARD_PARALLEL_1;
    public static final UniversalParameters STANDARD_PARALLEL_2;
    public static final UniversalParameters LAT_OF_1ST_POINT;
    public static final UniversalParameters LONG_OF_1ST_POINT;
    public static final UniversalParameters LAT_OF_2ND_POINT;
    public static final UniversalParameters LONG_OF_2ND_POINT;
    public static final UniversalParameters AZIMUTH;
    public static final UniversalParameters RECTIFIED_GRID_ANGLE;
    public static final UniversalParameters SCALE_FACTOR;
    public static final UniversalParameters X_SCALE;
    public static final UniversalParameters Y_SCALE;
    public static final UniversalParameters FALSE_EASTING;
    public static final UniversalParameters FALSE_NORTHING;
    private final NamedIdentifier[] identifiers;
    private final Map<String, NamedIdentifier> identifiersMap;
    private final Map<NamedIdentifier, NamedIdentifier> nextSameName;

    private UniversalParameters(NamedIdentifier[] namedIdentifierArray, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        super(UniversalParameters.toMap((ReferenceIdentifier[])namedIdentifierArray), Double.class, null, Double.isNaN(d) ? null : Double.valueOf(d), d2 == Double.NEGATIVE_INFINITY ? null : Double.valueOf(d2), d3 == Double.POSITIVE_INFINITY ? null : Double.valueOf(d3), unit, bl);
        this.identifiers = namedIdentifierArray;
        this.identifiersMap = new HashMap<String, NamedIdentifier>(XCollections.hashMapCapacity((int)namedIdentifierArray.length));
        IdentityHashMap<NamedIdentifier, NamedIdentifier> identityHashMap = null;
        int n = namedIdentifierArray.length;
        while (--n >= 0) {
            NamedIdentifier namedIdentifier = namedIdentifierArray[n];
            NamedIdentifier namedIdentifier2 = this.identifiersMap.put(namedIdentifier.getCode(), namedIdentifier);
            if (namedIdentifier2 == null) continue;
            if (identityHashMap == null) {
                identityHashMap = new IdentityHashMap<NamedIdentifier, NamedIdentifier>(4);
            }
            identityHashMap.put(namedIdentifier, namedIdentifier2);
        }
        this.nextSameName = identityHashMap;
    }

    final ParameterDescriptor<Double> select(Citation[] citationArray, String ... stringArray) {
        return this.select(this.getMinimumOccurs() != 0, (Double)this.getDefaultValue(), citationArray, null, stringArray);
    }

    final ParameterDescriptor<Double> select(Boolean bl, Double d, Citation[] citationArray, String[] stringArray, String ... stringArray2) {
        Object object2;
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        Object[] objectArray = new NamedIdentifier[this.identifiers.length];
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        NamedIdentifier[] namedIdentifierArray = this.identifiers;
        int n2 = namedIdentifierArray.length;
        for (int i = 0; i < n2; ++i) {
            object2 = namedIdentifierArray[i];
            Citation object3 = object2.getAuthority();
            if (XArrays.contains((Object[])citationArray, (Object)object3)) continue;
            objectArray[n] = object2;
            String string = object2.getCode();
            int n3 = stringArray2.length;
            while (--n3 >= 0) {
                if (!string.equals(stringArray2[n3])) continue;
                if (hashMap.put(object3, Boolean.TRUE) != null) {
                    throw new IllegalArgumentException(Errors.format((int)245, (Object)object3));
                }
                l2 |= (long)(1 << n3);
                l |= (long)(1 << n);
                break;
            }
            ++n;
        }
        if (l2 != (long)((1 << stringArray2.length) - 1)) {
            throw new IllegalArgumentException(Errors.format((int)223, (Object)stringArray2[Long.numberOfTrailingZeros(l2 ^ 0xFFFFFFFFFFFFFFFFL)]));
        }
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            Boolean bl2;
            NamedIdentifier namedIdentifier = objectArray[n2];
            if ((l & (long)(1 << n2)) == 0L && (bl2 = hashMap.put(object2 = namedIdentifier.getAuthority(), Boolean.FALSE)) != null) {
                if (bl2.booleanValue()) {
                    hashMap.put(object2, Boolean.TRUE);
                    continue;
                }
                throw new IllegalStateException(String.valueOf(namedIdentifier));
            }
            objectArray[n4++] = namedIdentifier;
        }
        if (stringArray != null) {
            objectArray = (NamedIdentifier[])XArrays.resize((Object[])objectArray, (int)(n4 + stringArray.length));
            for (String string : stringArray) {
                objectArray[n4++] = new DeprecatedName((ReferenceIdentifier)((Object)this.identifiersMap.get(string)));
            }
        }
        objectArray = (NamedIdentifier[])XArrays.resize((Object[])objectArray, (int)n4);
        return new DefaultParameterDescriptor<Double>(UniversalParameters.toMap((ReferenceIdentifier[])objectArray), Double.class, null, d != null ? d : (Double)this.getDefaultValue(), this.getMinimumValue(), this.getMaximumValue(), this.getUnit(), bl != null ? bl : this.getMinimumOccurs() != 0);
    }

    public ParameterDescriptor<?> find(Collection<GeneralParameterDescriptor> collection) throws IllegalArgumentException {
        ParameterDescriptor parameterDescriptor = null;
        block0: for (GeneralParameterDescriptor generalParameterDescriptor : collection) {
            ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
            NamedIdentifier namedIdentifier = this.identifiersMap.get(referenceIdentifier.getCode());
            while (namedIdentifier != null) {
                Citation citation = referenceIdentifier.getAuthority();
                if ((citation == null || Citations.identifierMatches((Citation)citation, (Citation)namedIdentifier.getAuthority())) && generalParameterDescriptor instanceof ParameterDescriptor) {
                    if (parameterDescriptor != null) {
                        throw new IllegalArgumentException(Errors.format((int)1, (Object)this.getName().getCode()) + IdentifiedObjects.toString(parameterDescriptor.getName()) + ", " + IdentifiedObjects.toString(generalParameterDescriptor.getName()));
                    }
                    parameterDescriptor = (ParameterDescriptor)generalParameterDescriptor;
                    continue block0;
                }
                if (this.nextSameName == null) continue block0;
                namedIdentifier = this.nextSameName.get(namedIdentifier);
            }
        }
        return parameterDescriptor;
    }

    static ParameterDescriptor<Double> createDescriptor(ReferenceIdentifier[] referenceIdentifierArray, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        return DefaultParameterDescriptor.create(UniversalParameters.toMap(referenceIdentifierArray), d, d2, d3, unit, bl);
    }

    static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] referenceIdentifierArray, Citation[] citationArray, ParameterDescriptor<?>[] parameterDescriptorArray, int n) {
        Map<String, Object> map;
        if (citationArray != null) {
            map = new HashMap<String, Object>();
            for (int i = 0; i < parameterDescriptorArray.length; ++i) {
                Object[] objectArray;
                ParameterDescriptor<?> parameterDescriptor = parameterDescriptorArray[i];
                if (parameterDescriptor.getValueClass() != Double.class) continue;
                map.putAll(IdentifiedObjects.getProperties(parameterDescriptor));
                boolean bl = false;
                boolean bl2 = false;
                do {
                    String string;
                    if ((objectArray = (Object[])map.get(string = bl ? "alias" : "identifiers")) == null) continue;
                    int n2 = 0;
                    for (Object object : objectArray) {
                        if (object instanceof ReferenceIdentifier && XArrays.contains((Object[])citationArray, (Object)((ReferenceIdentifier)object).getAuthority())) continue;
                        objectArray[n2++] = object;
                    }
                    if (n2 == objectArray.length) continue;
                    map.put(string, Arrays.copyOf(objectArray, n2));
                    bl2 = true;
                } while (bl = !bl);
                if (bl2) {
                    map.put("name", objectArray[0]);
                    parameterDescriptorArray[i] = new DefaultParameterDescriptor<Double>(map, Double.class, null, (Double)parameterDescriptor.getDefaultValue(), (Comparable<Double>)parameterDescriptor.getMinimumValue(), (Comparable<Double>)parameterDescriptor.getMaximumValue(), parameterDescriptor.getUnit(), parameterDescriptor.getMinimumOccurs() != 0);
                }
                map.clear();
            }
        }
        map = UniversalParameters.toMap(referenceIdentifierArray);
        return n == 0 ? new DefaultParameterDescriptorGroup(map, (GeneralParameterDescriptor[])parameterDescriptorArray) : new MapProjectionDescriptor(map, parameterDescriptorArray, n);
    }

    private static Map<String, Object> toMap(ReferenceIdentifier[] referenceIdentifierArray) {
        int n = 0;
        int n2 = 0;
        GenericName[] genericNameArray = null;
        ReferenceIdentifier[] referenceIdentifierArray2 = null;
        for (int i = 0; i < referenceIdentifierArray.length; ++i) {
            ReferenceIdentifier referenceIdentifier = referenceIdentifierArray[i];
            if (referenceIdentifier instanceof GenericName) {
                if (genericNameArray == null) {
                    genericNameArray = new GenericName[referenceIdentifierArray.length - i];
                }
                genericNameArray[n2++] = (GenericName)((Object)referenceIdentifier);
                continue;
            }
            if (referenceIdentifierArray2 == null) {
                referenceIdentifierArray2 = new ReferenceIdentifier[referenceIdentifierArray.length - i];
            }
            referenceIdentifierArray2[n++] = referenceIdentifier;
        }
        referenceIdentifierArray2 = (ReferenceIdentifier[])XArrays.resize(referenceIdentifierArray2, (int)n);
        genericNameArray = (GenericName[])XArrays.resize(genericNameArray, (int)n2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("identifiers", referenceIdentifierArray2);
        hashMap.put("alias", genericNameArray);
        return hashMap;
    }

    static {
        NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1");
        NamedIdentifier namedIdentifier2 = new NamedIdentifier((Citation)Citations.EPSG, "Latitude of 1st standard parallel");
        NamedIdentifier namedIdentifier3 = new NamedIdentifier(Citations.NETCDF, "standard_parallel");
        LATITUDE_OF_ORIGIN = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier((Citation)Citations.EPSG, "Latitude of false origin"), new NamedIdentifier((Citation)Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier((Citation)Citations.EPSG, "Spherical latitude of origin"), new NamedIdentifier((Citation)Citations.EPSG, "Latitude of projection centre"), namedIdentifier2, new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), namedIdentifier, new NamedIdentifier(Citations.NETCDF, "latitude_of_projection_origin"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLat"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginLat"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLat"), new NamedIdentifier(Citations.GEOTIFF, "CenterLat"), new NamedIdentifier((Citation)Citations.PROJ4, "lat_0")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        STANDARD_PARALLEL = new DefaultParameterDescriptor<Object>(Collections.singletonMap("name", namedIdentifier3), double[].class, null, null, null, null, NonSI.DEGREE_ANGLE, false);
        STANDARD_PARALLEL_1 = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.OGC, "pseudo_standard_parallel_1"), new NamedIdentifier((Citation)Citations.EPSG, "Latitude of standard parallel"), namedIdentifier2, new NamedIdentifier((Citation)Citations.EPSG, "Latitude of pseudo standard parallel"), new NamedIdentifier(Citations.ESRI, "Pseudo_Standard_Parallel_1"), namedIdentifier, new NamedIdentifier(Citations.NETCDF, "standard_parallel[1]"), namedIdentifier3, new NamedIdentifier(Citations.GEOTIFF, "StdParallel1"), new NamedIdentifier((Citation)Citations.PROJ4, "lat_1")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, false);
        STANDARD_PARALLEL_2 = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_2"), new NamedIdentifier((Citation)Citations.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_2"), new NamedIdentifier(Citations.NETCDF, "standard_parallel[2]"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel2"), new NamedIdentifier((Citation)Citations.PROJ4, "lat_2")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, false);
        LAT_OF_1ST_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_1st_Point")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        LONG_OF_1ST_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_1st_Point")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
        LAT_OF_2ND_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_2nd_Point")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        LONG_OF_2ND_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_2nd_Point")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
        AZIMUTH = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "azimuth"), new NamedIdentifier((Citation)Citations.EPSG, "Azimuth of initial line"), new NamedIdentifier((Citation)Citations.EPSG, "Co-latitude of cone axis"), new NamedIdentifier(Citations.ESRI, "Azimuth"), new NamedIdentifier(Citations.GEOTIFF, "AzimuthAngle")}, Double.NaN, -360.0, 360.0, NonSI.DEGREE_ANGLE, true);
        RECTIFIED_GRID_ANGLE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "rectified_grid_angle"), new NamedIdentifier((Citation)Citations.EPSG, "Angle from Rectified to Skew Grid"), new NamedIdentifier(Citations.ESRI, "XY_Plane_Rotation"), new NamedIdentifier(Citations.GEOTIFF, "RectifiedGridAngle")}, Double.NaN, -360.0, 360.0, NonSI.DEGREE_ANGLE, false);
        SCALE_FACTOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier((Citation)Citations.EPSG, "Scale factor at natural origin"), new NamedIdentifier((Citation)Citations.EPSG, "Scale factor on initial line"), new NamedIdentifier((Citation)Citations.EPSG, "Scale factor on pseudo standard parallel"), new NamedIdentifier(Citations.ESRI, "Scale_Factor"), new NamedIdentifier(Citations.NETCDF, "scale_factor_at_projection_origin"), new NamedIdentifier(Citations.NETCDF, "scale_factor_at_central_meridian"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter"), new NamedIdentifier((Citation)Citations.PROJ4, "k")}, 1.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE, true);
        X_SCALE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "X_Scale")}, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE, false);
        Y_SCALE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Y_Scale")}, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE, false);
        FALSE_EASTING = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_easting"), new NamedIdentifier((Citation)Citations.EPSG, "False easting"), new NamedIdentifier((Citation)Citations.EPSG, "Easting at false origin"), new NamedIdentifier((Citation)Citations.EPSG, "Easting at projection centre"), new NamedIdentifier(Citations.ESRI, "False_Easting"), new NamedIdentifier(Citations.NETCDF, "false_easting"), new NamedIdentifier(Citations.GEOTIFF, "FalseEasting"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginEasting"), new NamedIdentifier((Citation)Citations.PROJ4, "x_0")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
        FALSE_NORTHING = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_northing"), new NamedIdentifier((Citation)Citations.EPSG, "False northing"), new NamedIdentifier((Citation)Citations.EPSG, "Northing at false origin"), new NamedIdentifier((Citation)Citations.EPSG, "Northing at projection centre"), new NamedIdentifier(Citations.ESRI, "False_Northing"), new NamedIdentifier(Citations.NETCDF, "false_northing"), new NamedIdentifier(Citations.GEOTIFF, "FalseNorthing"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginNorthing"), new NamedIdentifier((Citation)Citations.PROJ4, "y_0")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
    }
}

