/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.util.CSWClient;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OpenSearchDescriptionTests
extends CommonFixture {
    private RelaxNGValidator osdValidator;
    private URI baseUri;
    private static final String SCHEMATRON_OPENSEARCH_DESCR = "/org/opengis/cite/cat30/sch/opensearch-1.1.sch";
    public static final String OPENSEARCH_CONSTRAINT = "OpenSearchDescriptionDocument";

    @BeforeClass
    public void initFixture(ITestContext testContext) {
        URL rncSchema = this.getClass().getResource("/org/opengis/cite/cat30/rnc/osd-1.1-draft5.rnc");
        try {
            this.osdValidator = new RelaxNGValidator(rncSchema);
        }
        catch (IOException | SAXException ex) {
            TestSuiteLogger.log(Level.WARNING, this.getClass().getName(), ex);
        }
        this.baseUri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
    }

    @Test(description="Requirements: 008; Tests: 008")
    public void preferOpenSearchDescription() {
        String xmlNotPreferred = "application/xml; q=0.5";
        this.request = ClientUtils.buildGetRequest(this.baseUri, null, MediaType.valueOf((String)xmlNotPreferred), MediaType.valueOf((String)"application/opensearchdescription+xml"));
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)XMLUtils.isXML(this.response.getType()), (String)ErrorMessage.format("NotXML", this.response.getType()));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        QName osdDocElemName = new QName("http://a9.com/-/spec/opensearch/1.1/", "OpenSearchDescription");
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), osdDocElemName);
    }

    @Test(description="Requirements: 021; Tests: 021")
    public void validOpenSearchDescription() throws SAXException, IOException {
        this.request = ClientUtils.buildGetRequest(this.baseUri, null, MediaType.valueOf((String)"application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf((String)"application/opensearchdescription+xml"));
        this.response = this.client.handle(this.request);
        Assert.assertTrue((boolean)XMLUtils.isXML(this.response.getType()), (String)ErrorMessage.format("NotXML", this.response.getType()));
        Source entity = ClientUtils.getResponseEntityAsSource(this.response, null);
        this.osdValidator.validate(entity);
        ValidationErrorHandler err = this.osdValidator.getErrorHandler();
        Assert.assertFalse((boolean)err.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
        URL schemaUrl = this.getClass().getResource(SCHEMATRON_OPENSEARCH_DESCR);
        ETSAssert.assertSchematronValid(schemaUrl, entity);
    }

    @Test(description="[CAT-HTTP]: 6.5.6.2, Table 16")
    public void getOpenSearchDescriptionFromCapabilities() {
        URI getCapabilitiesEndpoint = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        CSWClient cswClient = new CSWClient();
        Document capabilitiesDoc = cswClient.getCapabilities(getCapabilitiesEndpoint);
        Assert.assertNotNull((Object)capabilitiesDoc, (String)("Failed to retrieve capabilities document as 'application/xml' from " + getCapabilitiesEndpoint));
        Set<String> values = ServiceMetadataUtils.getConstraintValues(capabilitiesDoc, OPENSEARCH_CONSTRAINT);
        if (null == values || values.isEmpty()) {
            throw new AssertionError((Object)ErrorMessage.format("NamedItemNotFound", OPENSEARCH_CONSTRAINT));
        }
        URI uri = URI.create(values.iterator().next());
        this.request = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)"application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf((String)"application/opensearchdescription+xml"));
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)XMLUtils.isXML(this.response.getType()), (String)ErrorMessage.format("NotXML", this.response.getType()));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        QName osdDocElemName = new QName("http://a9.com/-/spec/opensearch/1.1/", "OpenSearchDescription");
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), osdDocElemName);
    }
}

