/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.geotoolkit.console.Action;
import org.geotoolkit.console.HelpAction;
import org.geotoolkit.console.Option;
import org.geotoolkit.console.VersionAction;
import org.geotoolkit.io.X364;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.logging.Logging;

public abstract class CommandLine
implements Runnable {
    public static final int ILLEGAL_ARGUMENT_EXIT_CODE = 1;
    public static final int ABORT_EXIT_CODE = 2;
    public static final int BAD_CONTENT_EXIT_CODE = 3;
    public static final int IO_EXCEPTION_EXIT_CODE = 100;
    public static final int SQL_EXCEPTION_EXIT_CODE = 101;
    public static final int ILLEGAL_STATE_EXIT_CODE = 190;
    public static final int INTERNAL_ERROR_EXIT_CODE = 200;
    static final String OPTION_PREFIX = "--";
    @Option
    protected boolean debug;
    @Option(examples={"fr", "fr_CA", "US"})
    protected Locale locale;
    @Option(examples={"UTF-8", "ISO-8859-1"})
    protected Charset encoding;
    @Option
    protected Boolean colors;
    protected Reader in;
    protected PrintWriter out;
    protected PrintWriter err;
    protected String[] arguments;
    private final String command;
    transient boolean ignoreMandatoryOption;
    transient boolean consoleRunning;

    protected CommandLine(String string, String[] stringArray) {
        this.arguments = stringArray;
        if (string == null) {
            string = "java " + this.getClass().getCanonicalName();
        }
        this.command = string;
    }

    protected <T> T convert(String string, Class<T> clazz) throws NonconvertibleObjectException {
        return ConverterRegistry.system().converter(String.class, clazz).convert(string);
    }

    final void initialize() {
        this.arguments = this.arguments != null ? (String[])this.arguments.clone() : Strings.EMPTY;
        Exception exception = this.assignValues(this.getClass());
        boolean bl = this.encoding != null;
        Console console = System.console();
        if (!bl && console != null) {
            if (this.in == null) {
                this.in = console.reader();
            }
            if (this.out == null) {
                this.out = console.writer();
            }
            if (this.err == null) {
                this.err = console.writer();
            }
        } else {
            if (this.in == null) {
                InputStreamReader inputStreamReader = this.encoding != null ? new InputStreamReader(System.in, this.encoding) : new InputStreamReader(System.in);
                this.in = new LineNumberReader(inputStreamReader);
            }
            if (this.out == null) {
                this.out = this.writer(System.out);
            }
            if (this.err == null) {
                this.err = this.writer(System.err);
            }
        }
        if (this.colors == null) {
            this.colors = console != null && X364.isSupported();
        }
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        int n = 0;
        for (int i = 0; i < this.arguments.length; ++i) {
            String string = this.arguments[i];
            if (string == null) continue;
            this.arguments[n++] = string;
            if (exception != null || !(string = string.trim()).startsWith(OPTION_PREFIX)) continue;
            exception = new IllegalArgumentException(this.error(223, string));
        }
        this.arguments = XArrays.resize(this.arguments, n);
        Logging.GEOTOOLKIT.forceMonolineConsoleOutput(this.debug ? Level.FINER : null);
        if (bl) {
            for (Handler handler : Logging.getLogger(Logging.GEOTOOLKIT.name).getHandlers()) {
                if (handler.getClass() != ConsoleHandler.class) continue;
                try {
                    ((ConsoleHandler)handler).setEncoding(this.encoding.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logging.unexpectedException(CommandLine.class, "initialize", unsupportedEncodingException);
                }
            }
        }
        if (exception != null) {
            this.printException(exception);
            this.exit(1);
        }
    }

    private PrintWriter writer(OutputStream outputStream) {
        if (this.encoding != null) {
            return new PrintWriter((Writer)new OutputStreamWriter(outputStream, this.encoding), true);
        }
        return new PrintWriter(outputStream, true);
    }

    private String error(int n, Object object) {
        return Errors.getResources(this.locale).getString(n, object);
    }

    private String error(int n, Object object, Object object2) {
        return Errors.getResources(this.locale).getString(n, object, object2);
    }

    private Exception assignValues(Class<?> clazz) {
        Exception exception = null;
        Class<?> clazz2 = clazz.getSuperclass();
        if (CommandLine.class.isAssignableFrom(clazz2)) {
            exception = this.assignValues(clazz2);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Object object;
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            String string = option.name().trim();
            if (string.isEmpty()) {
                string = field.getName();
            }
            string = OPTION_PREFIX + string;
            Class<String> clazz3 = field.getType();
            if (Boolean.TYPE.equals(clazz3)) {
                object = this.isEnabled(string);
            } else {
                String string2;
                clazz3 = Numbers.primitiveToWrapper(clazz3);
                try {
                    string2 = this.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (exception != null) continue;
                    exception = illegalArgumentException;
                    continue;
                }
                if (string2 == null && option.mandatory() && exception == null) {
                    if (this.ignoreMandatoryOption) continue;
                    exception = new IllegalArgumentException(this.error(119, string));
                    continue;
                }
                if (clazz3.isAssignableFrom(String.class)) {
                    object = string2;
                } else {
                    try {
                        object = this.convert(string2, clazz3);
                    }
                    catch (NonconvertibleObjectException nonconvertibleObjectException) {
                        if (exception != null) continue;
                        exception = nonconvertibleObjectException;
                        continue;
                    }
                }
            }
            if (object == null) continue;
            field.setAccessible(true);
            try {
                field.set(this, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnsupportedOperationException(illegalAccessException);
            }
        }
        return exception;
    }

    private boolean isEnabled(String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String string2 = this.arguments[i];
            if (string2 == null || !(string2 = string2.trim()).equalsIgnoreCase(string)) continue;
            this.arguments[i] = null;
            return true;
        }
        return false;
    }

    private String valueOf(String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String string2 = this.arguments[i];
            if (string2 == null) continue;
            string2 = string2.trim();
            String string3 = "";
            int n = string2.indexOf(61);
            if (n >= 0) {
                string3 = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            this.arguments[i] = null;
            if (!string3.isEmpty()) {
                return string3;
            }
            while (++i < this.arguments.length) {
                string3 = this.arguments[i];
                this.arguments[i] = null;
                if (string3 == null) break;
                string3 = string3.trim();
                if (n >= 0) {
                    return string3;
                }
                if (!string3.equals("=")) {
                    return string3.startsWith("=") ? string3.substring(1).trim() : string3;
                }
                n = 0;
            }
            throw new IllegalArgumentException(this.error(120, string2));
        }
        return null;
    }

    @Override
    public void run() {
        String[] stringArray;
        if (this.arguments == null || this.arguments.length == 0) {
            this.ignoreMandatoryOption = true;
        } else if (this.arguments.length == 1 && (stringArray = this.arguments[0]) != null && (stringArray.equalsIgnoreCase("help") || stringArray.equalsIgnoreCase("version"))) {
            this.ignoreMandatoryOption = true;
        }
        this.initialize();
        if (this.arguments == null || this.arguments.length == 0) {
            this.unknownAction(null);
            return;
        }
        stringArray = this.arguments;
        String string = stringArray[0].trim();
        this.arguments = XArrays.remove(stringArray, 0, 1);
        Class<?> clazz = this.getClass();
        do {
            for (Method method : clazz.getDeclaredMethods()) {
                Action action = method.getAnnotation(Action.class);
                if (action == null) continue;
                String string2 = action.name().trim();
                if (string2.isEmpty()) {
                    string2 = method.getName();
                }
                if (!string.equalsIgnoreCase(string2)) continue;
                int n = this.arguments.length;
                int n2 = action.minimalArgumentCount();
                if (n < n2) {
                    this.err.println(this.error(200, n2, n));
                    this.exit(1);
                    return;
                }
                n2 = action.maximalArgumentCount();
                if (n > n2) {
                    this.err.println(this.error(201, n2, n));
                    this.exit(1);
                    return;
                }
                method.setAccessible(true);
                try {
                    method.invoke((Object)this, (Object[])null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.printException(illegalAccessException);
                    this.exit(200);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    int n3 = throwable instanceof IOException ? 100 : (throwable instanceof SQLException ? 101 : 200);
                    this.printException(throwable);
                    this.exit(n3);
                }
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.err != null) {
                    this.err.flush();
                }
                return;
            }
        } while (CommandLine.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        this.arguments = stringArray;
        this.unknownAction(string);
    }

    protected void unknownAction(String string) {
        if (string == null) {
            this.summary();
            this.exit(0);
        } else {
            this.err.println(this.error(218, string));
            this.exit(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void summary() {
        PrintWriter printWriter = this.out;
        Descriptions descriptions = Descriptions.getResources(this.locale);
        printWriter.println(descriptions.getString(3, this.command));
        Vocabulary vocabulary = Vocabulary.getResources(this.locale);
        TreeSet<String> treeSet = new TreeSet<String>();
        boolean bl = true;
        do {
            Class clazz = bl ? Action.class : Option.class;
            Class<?> clazz2 = this.getClass();
            do {
                for (AccessibleObject accessibleObject : bl ? clazz2.getDeclaredMethods() : clazz2.getDeclaredFields()) {
                    Action action = accessibleObject.getAnnotation(clazz);
                    if (action == null) continue;
                    String string = bl ? action.name() : ((Option)((Object)action)).name();
                    if ((string = string.trim()).isEmpty()) {
                        string = ((Member)((Object)accessibleObject)).getName();
                    }
                    treeSet.add(string);
                }
            } while (CommandLine.class.isAssignableFrom(clazz2 = clazz2.getSuperclass()));
            printWriter.print(vocabulary.getString(bl ? 38 : 216));
            String string = ": ";
            String string2 = bl ? " | " : ", ";
            for (String string3 : treeSet) {
                void object;
                printWriter.print((String)object);
                if (!bl) {
                    printWriter.print(OPTION_PREFIX);
                }
                printWriter.print(string3);
                String string4 = string2;
            }
            treeSet.clear();
            printWriter.println();
        } while (!(bl = !bl));
        printWriter.println(descriptions.getString(14));
    }

    @Action(maximalArgumentCount=0)
    protected void version() {
        VersionAction.version(this.out, this.colors, this.locale);
    }

    @Action(maximalArgumentCount=0)
    protected void help() {
        new HelpAction(this).help(this.command);
    }

    final void color(StringBuilder stringBuilder, X364 x364) {
        if (Boolean.TRUE.equals(this.colors)) {
            stringBuilder.append(x364.sequence());
        }
    }

    final String bold(String string) {
        if (Boolean.TRUE.equals(this.colors)) {
            string = X364.BOLD.sequence() + string + X364.NORMAL.sequence();
        }
        return string;
    }

    Map<String, String> examples() {
        return Collections.emptyMap();
    }

    protected void printException(Throwable throwable) {
        this.out.flush();
        this.err.flush();
        if (this.debug) {
            throwable.printStackTrace(this.err);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string = Classes.getShortClassName(throwable);
            String string2 = throwable.getLocalizedMessage();
            if (string2 == null) {
                string2 = Vocabulary.getResources(this.locale).getString(209, string);
            } else {
                this.color(stringBuilder, X364.FOREGROUND_RED);
                this.color(stringBuilder, X364.BOLD);
                stringBuilder.append(string).append(": ");
                this.color(stringBuilder, X364.RESET);
            }
            this.err.println(stringBuilder.append(string2));
        }
    }

    protected void exit(int n) {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
        if (!this.consoleRunning) {
            System.exit(n);
        }
    }
}

