/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.geotoolkit.internal.jaxb.gco.ObjectIdentification;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.xml.IdentifiedObject;
import org.geotoolkit.xml.NilObject;
import org.geotoolkit.xml.NilObjectHandler;
import org.geotoolkit.xml.NilReason;
import org.geotoolkit.xml.XLink;
import org.opengis.metadata.Identifier;

public class ObjectLinker {
    public static final ObjectLinker DEFAULT = new ObjectLinker();

    protected ObjectLinker() {
    }

    public <T> T newIdentifiedObject(Class<T> clazz, Identifier ... identifierArray) {
        if (NilObjectHandler.isIgnoredInterface(clazz)) {
            throw new IllegalArgumentException(Errors.format(73, "type", clazz));
        }
        return (T)Proxy.newProxyInstance(ObjectLinker.class.getClassLoader(), new Class[]{clazz, IdentifiedObject.class, NilObject.class, LenientComparable.class}, (InvocationHandler)new NilObjectHandler(Identifier.class, identifierArray));
    }

    public <T> T resolve(Class<T> clazz, UUID uUID) {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("uuid", uUID);
        Object object = ObjectIdentification.UUIDs.lookup(uUID);
        return (T)(clazz.isInstance(object) ? object : null);
    }

    public <T> T resolve(Class<T> clazz, XLink xLink) {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("xlink", xLink);
        return null;
    }

    public <T> T resolve(Class<T> clazz, NilReason nilReason) {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("nilReason", nilReason);
        return nilReason.createNilObject(clazz);
    }

    public <T> boolean canUseReference(Class<T> clazz, T t, UUID uUID) {
        return false;
    }
}

