/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.StringDataValue;

public final class SQLReal
extends NumberDataType {
    static final int REAL_LENGTH = 16;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLReal.class);
    private float value;
    private boolean isnull;

    public int getInt() throws StandardException {
        if ((double)this.value > 2.147483648E9 || (double)this.value < -2.147483649E9) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    public byte getByte() throws StandardException {
        if ((double)this.value > 128.0 || (double)this.value < -129.0) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() throws StandardException {
        if ((double)this.value > 32768.0 || (double)this.value < -32769.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    public long getLong() throws StandardException {
        if ((double)this.value > 9.223372036854776E18 || (double)this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        return (long)this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public int typeToBigDecimal() {
        return 1;
    }

    public boolean getBoolean() {
        return this.value != 0.0f;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.value);
    }

    public int getLength() {
        return 16;
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    public String getTypeName() {
        return "REAL";
    }

    public int getTypeFormatId() {
        return 81;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readFloat();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0.0f;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        float f;
        float f2 = this.getFloat();
        if (f2 == (f = NumberDataType.normalizeREAL(dataValueDescriptor.getFloat()))) {
            return 0;
        }
        if (f2 > f) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        SQLReal sQLReal = new SQLReal();
        sQLReal.value = this.value;
        sQLReal.isnull = this.isnull;
        return sQLReal;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLReal();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws StandardException, SQLException {
        float f = resultSet.getFloat(n);
        if (bl && resultSet.wasNull()) {
            this.restoreToNull();
        } else {
            this.setValue(f);
        }
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 7);
            return;
        }
        preparedStatement.setFloat(n, this.value);
    }

    public final void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateFloat(n, this.value);
    }

    public SQLReal() {
        this.isnull = true;
    }

    public SQLReal(float f) throws StandardException {
        this.value = NumberDataType.normalizeREAL(f);
    }

    public SQLReal(Float f) throws StandardException {
        this.isnull = f == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeREAL(f.floatValue());
        }
    }

    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0.0f;
            this.isnull = true;
        } else {
            try {
                this.setValue(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
        }
    }

    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.floatValue());
    }

    public void setBigDecimal(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        float f = number.floatValue();
        if (f == 0.0f) {
            boolean bl;
            boolean bl2 = bl = ((BigDecimal)number).compareTo(BigDecimal.ZERO) == 0;
            if (!bl) {
                throw StandardException.newException("22003", "REAL");
            }
        }
        this.setValue(f);
    }

    public void setValue(float f) throws StandardException {
        this.value = NumberDataType.normalizeREAL(f);
        this.isnull = false;
    }

    public void setValue(int n) {
        this.value = n;
        this.isnull = false;
    }

    public void setValue(long l) {
        this.value = l;
        this.isnull = false;
    }

    public void setValue(double d) throws StandardException {
        float f = (float)d;
        if (f == 0.0f && d != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        this.setValue(f);
    }

    public void setValue(boolean bl) {
        this.value = bl ? 1.0f : 0.0f;
        this.isnull = false;
    }

    void setObject(Object object) throws StandardException {
        this.setValue(((Float)object).floatValue());
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof StringDataValue) {
            this.setValue(dataValueDescriptor.getString());
        } else if (dataValueDescriptor instanceof SQLDouble) {
            this.setValue(dataValueDescriptor.getDouble());
        } else {
            this.setValue(dataValueDescriptor.getFloat());
        }
    }

    public int typePrecedence() {
        return 80;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() == dataValueDescriptor2.getFloat());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() != dataValueDescriptor2.getFloat());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() < dataValueDescriptor2.getFloat());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() > dataValueDescriptor2.getFloat());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() <= dataValueDescriptor2.getFloat());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() >= dataValueDescriptor2.getFloat());
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue.getDouble() + numberDataValue2.getDouble();
        numberDataValue3.setValue(d);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue.getDouble() - numberDataValue2.getDouble();
        numberDataValue3.setValue(d);
        return numberDataValue3;
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        double d;
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d2 = numberDataValue.getDouble();
        double d3 = d2 * (d = numberDataValue2.getDouble());
        if (d3 == 0.0 && d2 != 0.0 && d != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        numberDataValue3.setValue(d3);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d = numberDataValue2.getDouble();
        if (d == 0.0) {
            throw StandardException.newException("22012");
        }
        double d2 = numberDataValue.getDouble();
        double d3 = d2 / d;
        if (Double.isNaN(d3)) {
            throw StandardException.newException("22012");
        }
        if (d3 == 0.0 && d2 != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        numberDataValue3.setValue(d3);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLReal();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        float f = -this.getFloat();
        numberDataValue.setValue(f);
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0f;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Float.toString(this.value);
    }

    public int hashCode() {
        long l = (long)this.value;
        if ((float)l != this.value) {
            l = Double.doubleToLongBits(this.value);
        }
        return (int)(l ^ l >> 32);
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

