/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.AbstractFeature;
import org.geotoolkit.gml.xml.v321.AbstractCoverageType;
import org.geotoolkit.gml.xml.v321.AbstractFeatureCollectionType;
import org.geotoolkit.gml.xml.v321.AbstractGMLType;
import org.geotoolkit.gml.xml.v321.BoundedFeatureType;
import org.geotoolkit.gml.xml.v321.BoundingShapeType;
import org.geotoolkit.gml.xml.v321.DynamicFeatureType;
import org.geotoolkit.gml.xml.v321.LocationPropertyType;
import org.geotoolkit.gml.xml.v321.ObjectFactory;
import org.geotoolkit.gml.xml.v321.ObservationType;
import org.geotoolkit.gml.xml.v321.PriorityLocationPropertyType;
import org.geotoolkit.gml.xml.v321.ReferenceType;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractFeatureType", propOrder={"boundedBy", "location"})
@XmlSeeAlso(value={ObservationType.class, AbstractFeatureCollectionType.class, AbstractCoverageType.class, DynamicFeatureType.class, BoundedFeatureType.class})
public abstract class AbstractFeatureType
extends AbstractGMLType
implements AbstractFeature {
    @XmlElement(nillable=true)
    private BoundingShapeType boundedBy;
    @XmlElementRef(name="location", namespace="http://www.opengis.net/gml/3.2", type=JAXBElement.class)
    private JAXBElement<? extends LocationPropertyType> location;

    public AbstractFeatureType() {
    }

    public AbstractFeatureType(AbstractFeature af) {
        super(af);
        if (af != null) {
            if (af.getBoundedBy() != null) {
                this.boundedBy = new BoundingShapeType(af.getBoundedBy());
            }
            if (af.getLocation() != null) {
                ObjectFactory factory = new ObjectFactory();
                if (af.getLocation() instanceof LocationPropertyType) {
                    this.location = factory.createLocation((LocationPropertyType)af.getLocation());
                } else if (af.getLocation() instanceof PriorityLocationPropertyType) {
                    this.location = factory.createPriorityLocation((PriorityLocationPropertyType)af.getLocation());
                } else {
                    throw new IllegalArgumentException("LocationProperty clone not implemented yet");
                }
            }
        }
    }

    public AbstractFeatureType(String id, String name, String description) {
        super(id, name, description, null);
    }

    public AbstractFeatureType(String id, String name, String description, ReferenceType descriptionReference, BoundingShapeType boundedBy) {
        super(id, name, description, descriptionReference);
        this.boundedBy = boundedBy == null ? new BoundingShapeType("not_bounded") : boundedBy;
    }

    @Override
    public BoundingShapeType getBoundedBy() {
        return this.boundedBy;
    }

    public void setBoundedBy(BoundingShapeType value) {
        this.boundedBy = value;
    }

    public JAXBElement<? extends LocationPropertyType> getjbLocation() {
        return this.location;
    }

    @Override
    public LocationPropertyType getLocation() {
        if (this.location != null) {
            return (LocationPropertyType)this.location.getValue();
        }
        return null;
    }

    public void setLocation(JAXBElement<? extends LocationPropertyType> value) {
        this.location = value;
    }

    @Override
    public List<String> getSrsName() {
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append("\n");
        if (this.location != null) {
            sb.append("location:\n").append(this.location.getValue()).append('\n');
        }
        if (this.boundedBy != null) {
            sb.append("boundedBy: ").append(this.boundedBy).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractFeatureType && super.equals(object, mode)) {
            AbstractFeatureType that = (AbstractFeatureType)object;
            boolean loc = false;
            if (this.location != null && that.location != null) {
                loc = Utilities.equals(this.location.getValue(), that.location.getValue());
            } else if (this.location == null && that.location == null) {
                loc = true;
            }
            return Utilities.equals(this.boundedBy, that.boundedBy) && loc;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + super.hashCode();
        hash = 83 * hash + (this.boundedBy != null ? this.boundedBy.hashCode() : 0);
        hash = 83 * hash + (this.location != null ? this.location.hashCode() : 0);
        return hash;
    }
}

