/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.jaxb.gco.StringAdapter;
import org.geotoolkit.internal.jaxb.metadata.CI_Citation;
import org.geotoolkit.internal.jaxb.metadata.ReferenceSystemMetadata;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.Deprecable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@Immutable
@XmlRootElement(name="RS_Identifier", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultReferenceIdentifier
implements ReferenceIdentifier,
Deprecable,
Serializable {
    private static final long serialVersionUID = 2004263079254434562L;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=StringAdapter.class)
    final String code;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=StringAdapter.class)
    final String codeSpace;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=CI_Citation.class)
    final Citation authority;
    @XmlElement(namespace="http://www.isotc211.org/2005/gmd")
    private final String version;
    private final InternationalString remarks;

    private DefaultReferenceIdentifier() {
        this.code = null;
        this.codeSpace = null;
        this.authority = null;
        this.version = null;
        this.remarks = null;
    }

    public DefaultReferenceIdentifier(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("identifier", referenceIdentifier);
        this.code = referenceIdentifier.getCode();
        this.codeSpace = referenceIdentifier.getCodeSpace();
        this.authority = referenceIdentifier.getAuthority();
        this.version = referenceIdentifier.getVersion();
        this.remarks = referenceIdentifier instanceof DefaultReferenceIdentifier ? ((DefaultReferenceIdentifier)referenceIdentifier).getRemarks() : null;
    }

    public DefaultReferenceIdentifier(Citation citation, String string, String string2) {
        this(citation, string, string2, null, null);
    }

    public DefaultReferenceIdentifier(Citation citation, String string, String string2, String string3, InternationalString internationalString) {
        ArgumentChecks.ensureNonNull("code", string2);
        this.code = string2;
        this.codeSpace = string;
        this.authority = citation;
        this.version = string3;
        this.remarks = internationalString;
    }

    public DefaultReferenceIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        this(map, true);
    }

    DefaultReferenceIdentifier(Map<String, ?> map, boolean bl) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("properties", map);
        Object object = null;
        String string = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        DefaultInternationalString defaultInternationalString = null;
        String string2 = null;
        Object object5 = null;
        block10: for (Map.Entry<String, ?> entry : map.entrySet()) {
            string2 = entry.getKey().trim().toLowerCase();
            object5 = entry.getValue();
            switch (string2.hashCode()) {
                case 3373707: {
                    if (bl || !string2.equals("name")) break;
                    object = object5;
                    continue block10;
                }
                case 3059181: {
                    if (!string2.equals("code")) break;
                    object = object5;
                    continue block10;
                }
                case -1108676807: {
                    if (!string2.equals("codespace")) break;
                    string = object5;
                    continue block10;
                }
                case 351608024: {
                    if (!string2.equals("version")) break;
                    object2 = object5;
                    continue block10;
                }
                case 1475610435: {
                    if (!string2.equals("authority")) break;
                    if (object5 instanceof String) {
                        object5 = Citations.fromName(object5.toString());
                    }
                    object3 = object5;
                    continue block10;
                }
                case 1091415283: {
                    if (!bl || !string2.equals("remarks") || !(object5 instanceof InternationalString)) break;
                    object4 = object5;
                    continue block10;
                }
            }
            if (!bl || !(object5 instanceof String)) continue;
            if (defaultInternationalString == null) {
                defaultInternationalString = object4 instanceof DefaultInternationalString ? (DefaultInternationalString)object4 : new DefaultInternationalString();
            }
            defaultInternationalString.add("remarks", string2, object5.toString());
        }
        if (defaultInternationalString != null && !defaultInternationalString.getLocales().isEmpty()) {
            if (object4 == null) {
                object4 = defaultInternationalString;
            } else {
                Logging.log(DefaultReferenceIdentifier.class, "<init>", Loggings.format(Level.WARNING, 33));
            }
        }
        if (string == null && object3 instanceof Citation) {
            string = DefaultReferenceIdentifier.getCodeSpace((Citation)object3);
        }
        try {
            string2 = "code";
            object5 = object;
            this.code = (String)object5;
            string2 = "version";
            object5 = object2;
            this.version = (String)object5;
            string2 = "codespace";
            object5 = string;
            this.codeSpace = object5;
            string2 = "authority";
            object5 = object3;
            this.authority = (Citation)object5;
            string2 = "remarks";
            object5 = object4;
            this.remarks = (InternationalString)object5;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidParameterValueException(Errors.format(73, string2, object5), (Throwable)classCastException, string2, object5);
        }
        ArgumentChecks.ensureNonNull("code", object);
    }

    static InternationalString getShortestTitle(Citation citation) {
        InternationalString internationalString = citation.getTitle();
        int n = internationalString.length();
        Collection<? extends InternationalString> collection = citation.getAlternateTitles();
        if (collection != null) {
            for (InternationalString internationalString2 : collection) {
                int n2 = internationalString2.length();
                if (n2 <= 0 || n2 >= n) continue;
                internationalString = internationalString2;
                n = n2;
            }
        }
        return internationalString;
    }

    static String getCodeSpace(Citation citation) {
        if (citation != null) {
            Object object;
            Collection<? extends Identifier> collection = citation.getIdentifiers();
            if (collection != null) {
                object = collection.iterator();
                while (object.hasNext()) {
                    Identifier identifier = (Identifier)object.next();
                    String string = identifier.getCode();
                    if (!DefaultReferenceIdentifier.isValidCodeSpace(string)) continue;
                    return string;
                }
            }
            if (DefaultReferenceIdentifier.isValidCodeSpace((String)(object = DefaultReferenceIdentifier.getShortestTitle(citation).toString(null)))) {
                return object;
            }
        }
        return null;
    }

    private static boolean isValidCodeSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        while (--n >= 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codeSpace;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    public int hashCode() {
        int n = -882629886;
        if (this.code != null) {
            n ^= this.code.hashCode();
        }
        if (this.codeSpace != null) {
            n = n * 31 + this.codeSpace.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultReferenceIdentifier defaultReferenceIdentifier = (DefaultReferenceIdentifier)object;
            return Utilities.equals(this.code, defaultReferenceIdentifier.code) && Utilities.equals(this.codeSpace, defaultReferenceIdentifier.codeSpace) && Utilities.equals(this.authority, defaultReferenceIdentifier.authority) && Utilities.equals(this.version, defaultReferenceIdentifier.version) && Utilities.equals(this.remarks, defaultReferenceIdentifier.remarks);
        }
        return false;
    }

    public String toString() {
        return ReferenceSystemMetadata.toString("IDENTIFIER", this.authority, this.codeSpace, this.code, this.isDeprecated());
    }
}

