/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.DynamicFactoryRegistry;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.FactoryUtilities;
import org.geotoolkit.internal.referencing.Identifier3D;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

@ThreadSafe
public class ReferencingFactoryContainer
extends ReferencingFactory {
    private static FactoryRegistry cache;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencingFactoryContainer instance(Hints hints) {
        if (hints == null) {
            hints = new Hints();
        }
        Class<FactoryFinder> clazz = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            if (cache == null) {
                cache = new DynamicFactoryRegistry(ReferencingFactoryContainer.class);
                cache.registerServiceProvider(new ReferencingFactoryContainer(null), ReferencingFactoryContainer.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache.getServiceProvider(ReferencingFactoryContainer.class, null, hints, null);
        }
    }

    public ReferencingFactoryContainer(Hints hints) {
        if (hints != null) {
            hints = hints.clone();
            this.datumFactory = (DatumFactory)ReferencingFactoryContainer.getFactory(hints, Hints.DATUM_FACTORY);
            this.csFactory = (CSFactory)ReferencingFactoryContainer.getFactory(hints, Hints.CS_FACTORY);
            this.crsFactory = (CRSFactory)ReferencingFactoryContainer.getFactory(hints, Hints.CRS_FACTORY);
            this.mtFactory = (MathTransformFactory)ReferencingFactoryContainer.getFactory(hints, Hints.MATH_TRANSFORM_FACTORY);
            if (this.datumFactory != null) {
                hints.remove(Hints.DATUM_FACTORY);
            }
            if (this.csFactory != null) {
                hints.remove(Hints.CS_FACTORY);
            }
            if (this.crsFactory != null) {
                hints.remove(Hints.CRS_FACTORY);
            }
            if (this.mtFactory != null) {
                hints.remove(Hints.MATH_TRANSFORM_FACTORY);
            }
            if (!hints.isEmpty()) {
                this.declaredFactoryHints(hints);
                FactoryUtilities.addImplementationHints(hints, this.hints);
                this.fetchAllFactories();
                this.hints.clear();
            }
        }
    }

    private static Factory getFactory(Map<?, ?> map, Hints.Key key) {
        Object obj = map.get(key);
        return obj instanceof Factory ? (Factory)obj : null;
    }

    private void fetchAllFactories() {
        this.mtFactory = this.getMathTransformFactory();
        this.datumFactory = this.getDatumFactory();
        this.csFactory = this.getCSFactory();
        this.crsFactory = this.getCRSFactory();
    }

    private void declaredFactoryHints(Map<? super RenderingHints.Key, Object> map) {
        if (this.crsFactory != null) {
            map.put(Hints.CRS_FACTORY, this.crsFactory);
        }
        if (this.csFactory != null) {
            map.put(Hints.CS_FACTORY, this.csFactory);
        }
        if (this.datumFactory != null) {
            map.put(Hints.DATUM_FACTORY, this.datumFactory);
        }
        if (this.mtFactory != null) {
            map.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
        }
    }

    @Override
    public synchronized Map<RenderingHints.Key, ?> getImplementationHints() {
        if (this.hints.isEmpty()) {
            this.fetchAllFactories();
            this.declaredFactoryHints(this.hints);
        }
        return super.getImplementationHints();
    }

    private Hints getCurrentHints() {
        Hints hints = EMPTY_HINTS.clone();
        assert (Thread.holdsLock(this));
        hints.putAll((Map<?, ?>)this.hints);
        this.declaredFactoryHints(hints);
        return hints;
    }

    public synchronized DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = FactoryFinder.getDatumFactory(this.getCurrentHints());
        }
        return this.datumFactory;
    }

    public synchronized CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = FactoryFinder.getCSFactory(this.getCurrentHints());
        }
        return this.csFactory;
    }

    public synchronized CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = FactoryFinder.getCRSFactory(this.getCurrentHints());
        }
        return this.crsFactory;
    }

    public synchronized MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = FactoryFinder.getMathTransformFactory(this.getCurrentHints());
        }
        return this.mtFactory;
    }

    public SingleCRS toGeodetic3D(SingleCRS singleCRS) throws FactoryException {
        if (singleCRS instanceof GeographicCRS || singleCRS instanceof ProjectedCRS) {
            switch (singleCRS.getCoordinateSystem().getDimension()) {
                case 2: {
                    CoordinateSystemAxis coordinateSystemAxis = DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT;
                    Unit<Length> unit = ((GeodeticDatum)singleCRS.getDatum()).getEllipsoid().getAxisUnit();
                    if (!SI.METRE.equals(unit)) {
                        coordinateSystemAxis = this.getCSFactory().createCoordinateSystemAxis(IdentifiedObjects.getProperties(coordinateSystemAxis), coordinateSystemAxis.getAbbreviation(), coordinateSystemAxis.getDirection(), unit);
                    }
                    singleCRS = this.toGeodetic3D(null, singleCRS, coordinateSystemAxis, true);
                }
                case 3: {
                    return singleCRS;
                }
            }
        }
        throw new FactoryException(Errors.format(238, singleCRS.getName()));
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS compoundCRS) throws FactoryException {
        int n;
        SingleCRS singleCRS = null;
        VerticalCRS verticalCRS = null;
        int n2 = -2;
        int n3 = -2;
        ArrayList<SingleCRS> arrayList = new ArrayList<SingleCRS>(DefaultCompoundCRS.getSingleCRS(compoundCRS));
        int n4 = n = arrayList.size();
        while (--n4 >= 0) {
            VerticalCRS verticalCRS2;
            SingleCRS singleCRS2 = (SingleCRS)arrayList.get(n4);
            if (singleCRS2 instanceof GeographicCRS || singleCRS2 instanceof ProjectedCRS) {
                if (singleCRS2.getCoordinateSystem().getDimension() == 2) {
                    singleCRS = singleCRS2;
                    n2 = n4;
                }
            } else if (singleCRS2 instanceof VerticalCRS && VerticalDatumTypes.ELLIPSOIDAL.equals((verticalCRS2 = (VerticalCRS)singleCRS2).getDatum().getVerticalDatumType())) {
                verticalCRS = verticalCRS2;
                n3 = n4;
            }
            if (Math.abs(n3 - n2) != 1) continue;
            boolean bl = n2 < n3;
            int n5 = bl ? n2 : n3;
            arrayList.remove(n5);
            arrayList.set(n5, this.toGeodetic3D(CRS.getCompoundCRS(compoundCRS, singleCRS, verticalCRS), singleCRS, verticalCRS.getCoordinateSystem().getAxis(0), bl));
        }
        n4 = arrayList.size();
        if (n4 == 1) {
            return (CoordinateReferenceSystem)arrayList.get(0);
        }
        if (n4 == n) {
            return compoundCRS;
        }
        return this.getCRSFactory().createCompoundCRS(IdentifiedObjects.getProperties(compoundCRS), arrayList.toArray(new SingleCRS[arrayList.size()]));
    }

    private SingleCRS toGeodetic3D(CompoundCRS compoundCRS, SingleCRS singleCRS, CoordinateSystemAxis coordinateSystemAxis, boolean bl) throws FactoryException {
        Map<String, ?> map;
        Map<String, ?> map2;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[3];
        CoordinateSystem coordinateSystem = singleCRS.getCoordinateSystem();
        coordinateSystemAxisArray[bl ? 0 : 1] = coordinateSystem.getAxis(0);
        coordinateSystemAxisArray[bl ? 1 : 2] = coordinateSystem.getAxis(1);
        coordinateSystemAxisArray[bl ? 2 : 0] = coordinateSystemAxis;
        if (compoundCRS != null) {
            map2 = IdentifiedObjects.getProperties(compoundCRS.getCoordinateSystem());
            map = IdentifiedObjects.getProperties(compoundCRS);
        } else {
            map2 = ReferencingFactoryContainer.getTemporaryName(coordinateSystem);
            map = ReferencingFactoryContainer.getTemporaryName(singleCRS);
        }
        map = Identifier3D.addHorizontalCRS(map, singleCRS);
        CSFactory cSFactory = this.getCSFactory();
        CRSFactory cRSFactory = this.getCRSFactory();
        if (singleCRS instanceof GeographicCRS) {
            GeographicCRS geographicCRS = (GeographicCRS)singleCRS;
            EllipsoidalCS ellipsoidalCS = cSFactory.createEllipsoidalCS(map2, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            return cRSFactory.createGeographicCRS(map, geographicCRS.getDatum(), ellipsoidalCS);
        }
        if (singleCRS instanceof ProjectedCRS) {
            ProjectedCRS projectedCRS = (ProjectedCRS)singleCRS;
            CartesianCS cartesianCS = cSFactory.createCartesianCS(map2, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
            GeographicCRS geographicCRS2 = (GeographicCRS)this.toGeodetic3D(null, geographicCRS, coordinateSystemAxis, bl);
            Matrix matrix = ReferencingFactoryContainer.toStandard(geographicCRS, true);
            Matrix matrix2 = ReferencingFactoryContainer.toStandard(projectedCRS, false);
            Conversion conversion = projectedCRS.getConversionFromBase();
            if (!matrix.isIdentity() || !matrix2.isIdentity()) {
                MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
                MathTransform mathTransform = conversion.getMathTransform();
                mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createAffineTransform(matrix), mathTransform), mathTransformFactory.createAffineTransform(matrix2));
                conversion = new DefiningConversion(IdentifiedObjects.getProperties(conversion), conversion.getMethod(), mathTransform);
            }
            return cRSFactory.createProjectedCRS(map, geographicCRS2, conversion, cartesianCS);
        }
        throw new AssertionError(singleCRS.getClass());
    }

    private static Matrix toStandard(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        Exception exception;
        try {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            CoordinateSystem coordinateSystem2 = AbstractCS.standard(coordinateSystem);
            if (bl) {
                return AbstractCS.swapAndScaleAxis(coordinateSystem2, coordinateSystem);
            }
            return AbstractCS.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (ConversionException conversionException) {
            exception = conversionException;
        }
        throw new FactoryException(Errors.format(238, coordinateReferenceSystem.getName()), exception);
    }

    public CoordinateReferenceSystem separate(CoordinateReferenceSystem coordinateReferenceSystem, int ... nArray) throws FactoryException {
        int n = nArray.length;
        int n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n == 0 || nArray[0] < 0 || nArray[n - 1] >= n2 || !XArrays.isSorted(nArray, true)) {
            throw new IllegalArgumentException(Errors.format(72, "dimension"));
        }
        if (n == n2) {
            return coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            List<CoordinateReferenceSystem> list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
            block4: for (CoordinateReferenceSystem coordinateReferenceSystem2 : list) {
                int n6 = n4 + coordinateReferenceSystem2.getCoordinateSystem().getDimension();
                if (n5 == nArray.length) break;
                while (nArray[n5] < n4) {
                    if (++n5 != nArray.length) continue;
                    break block4;
                }
                int n7 = n5;
                while (nArray[n7] < n6 && ++n7 != nArray.length) {
                }
                if (n5 != n7) {
                    int[] nArray2 = new int[n7 - n5];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = nArray[i + n5] - n4;
                    }
                    coordinateReferenceSystemArray[n3++] = this.separate(coordinateReferenceSystem2, nArray2);
                }
                n4 = n6;
                n5 = n7;
            }
            if (n3 == 1) {
                return coordinateReferenceSystemArray[0];
            }
            return this.getCRSFactory().createCompoundCRS(ReferencingFactoryContainer.getTemporaryName(coordinateReferenceSystem), XArrays.resize(coordinateReferenceSystemArray, n3));
        }
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, DefaultGeographicCRS.WGS84_3D)) {
            switch (nArray.length) {
                case 2: {
                    if (nArray[0] != 0 || nArray[1] != 1) break;
                    return DefaultGeographicCRS.WGS84;
                }
                case 1: {
                    if (nArray[0] != 2) break;
                    return DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
                }
            }
        }
        throw new FactoryException(Errors.format(38, coordinateReferenceSystem.getName().getCode()));
    }

    private static Map<String, ?> getTemporaryName(IdentifiedObject identifiedObject) {
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        return Collections.singletonMap("name", new DefaultReferenceIdentifier(null, referenceIdentifier.getCodeSpace(), referenceIdentifier.getCode() + " (3D)"));
    }
}

