/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.DeprecatedName;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Mercator1SP
extends MapProjection {
    private static final long serialVersionUID = -5886510621481710072L;
    @Deprecated
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    @Deprecated
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Mercator1SP() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF};
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of natural origin", "central_meridian", "NatOriginLong");
        LATITUDE_OF_ORIGIN = UniversalParameters.LATITUDE_OF_ORIGIN.select(citationArray, "Latitude of natural origin", "latitude_of_origin", "NatOriginLat");
        SCALE_FACTOR = UniversalParameters.SCALE_FACTOR.select(citationArray, "Scale factor at natural origin", "ScaleAtNatOrigin");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(citationArray, "False easting", "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(citationArray, "False northing", "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Mercator_1SP"), new NamedIdentifier(Citations.EPSG, "Mercator (variant A)"), new NamedIdentifier(Citations.EPSG, "Mercator (Spherical)"), new DeprecatedName(Citations.EPSG, "Mercator (1SP)"), new DeprecatedName(Citations.EPSG, "Mercator (1SP) (Spherical)"), new IdentifierCode(Citations.EPSG, 9804), new IdentifierCode(Citations.EPSG, 1026), new IdentifierCode(Citations.EPSG, 9841, 1026), new NamedIdentifier(Citations.GEOTIFF, "CT_Mercator"), new IdentifierCode(Citations.GEOTIFF, 7), new NamedIdentifier(Citations.PROJ4, "merc"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational(52))}, citationArray, new ParameterDescriptor[]{MapProjection.SEMI_MAJOR, MapProjection.SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

