/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SingletonIterator<E>
implements Iterator<E> {
    private final E singleton;
    private boolean hasNext = true;

    private SingletonIterator(E singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            return this.singleton;
        }
        throw new NoSuchElementException("Out of iterator limit.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing object from a singleton iterator is not authorized.");
    }

    public static <T> Iterator<T> wrap(T singleton) {
        return new SingletonIterator<T>(singleton);
    }
}

