/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.util.FactoryException;
import org.testng.IExecutionListener;

public class TestRunListener
implements IExecutionListener {
    private static final String DATA_SOURCE = "jdbc/EPSG";

    @Override
    public void onExecutionStart() {
        this.lookupDataSource(DATA_SOURCE);
    }

    @Override
    public void onExecutionFinish() {
    }

    void lookupDataSource(String dsName) {
        DataSource epsgDataSource = null;
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:/comp/env");
            epsgDataSource = (DataSource)envContext.lookup(dsName);
        }
        catch (NamingException nx) {
            TestSuiteLogger.log(Level.CONFIG, String.format("JNDI DataSource %s not found. An embedded database will be created if necessary.", dsName, nx.getMessage()));
        }
        if (null != epsgDataSource) {
            try (Connection conn = epsgDataSource.getConnection();){
                EpsgInstaller dbInstaller = new EpsgInstaller();
                dbInstaller.setDatabase(conn);
                if (!dbInstaller.exists()) {
                    dbInstaller.call();
                }
            }
            catch (SQLException | FactoryException e) {
                TestSuiteLogger.log(Level.CONFIG, String.format("Failed to access DataSource %s .\n %s", dsName, e.getMessage()));
            }
            Hints.putSystemDefault(Hints.EPSG_DATA_SOURCE, epsgDataSource);
        }
    }
}

