/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.Records;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.URIUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.geomatics.Extents;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.TransformException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicSearchTests
extends CommonFixture {
    private URI getURI;
    private Envelope geoExtent;
    private DatasetInfo datasetInfo;
    private List<String> recordTitles;
    private List<String> recordIdentifiers;
    private List<String> recordTopics;

    void setExtent(Envelope extent) {
        this.geoExtent = extent;
    }

    void setGetEndpoint(URI uri) {
        this.getURI = uri;
    }

    @BeforeClass
    public void findRequestEndpoints(ITestContext testContext) {
        this.getURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecords", "GET");
        if (null == this.getURI.getScheme()) {
            throw new SkipException("GET endpoint for GetRecords request not found.");
        }
    }

    @BeforeClass
    public void getDatasetInfo(ITestContext testContext) {
        DatasetInfo dataset = (DatasetInfo)testContext.getSuite().getAttribute(SuiteAttribute.DATASET.getName());
        if (null == dataset) {
            throw new SkipException("Dataset info not found in test context.");
        }
        this.datasetInfo = dataset;
        Envelope env = this.datasetInfo.getGeographicExtent();
        this.setExtent(env);
        this.recordTitles = this.datasetInfo.getRecordTitles();
        this.recordIdentifiers = this.datasetInfo.getRecordIdentifiers();
        this.recordTopics = this.datasetInfo.getRecordTopics();
    }

    @Test(description="Requirements: 017")
    public void getRecordsByBBOXWithUnsupportedCRS() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "brief");
        qryParams.put("bbox", "472944,5363287,492722,5455253,urn:ogc:def:crs:EPSG::0000");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "bbox");
    }

    @Test(description="Requirements: 017; Tests: 017")
    public void getBriefRecordsByBBOX() {
        if (null == this.geoExtent) {
            throw new SkipException("Could not determine extent of sample data.");
        }
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "brief");
        Envelope bbox = this.geoExtent;
        qryParams.put("bbox", Extents.envelopeToString(bbox));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        DOMSource results = new DOMSource(entity);
        ETSAssert.assertEnvelopeIntersectsBoundingBoxes(bbox, results);
    }

    @Test(description="Requirements: 017; Tests: 017")
    public void getSummaryRecordsByWGS84BBOX() {
        if (null == this.geoExtent) {
            throw new SkipException("Could not determine extent of sample data.");
        }
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        Envelope bbox = this.geoExtent;
        try {
            if (!bbox.getCoordinateReferenceSystem().equals(DefaultGeographicCRS.WGS84)) {
                bbox = new GeneralEnvelope(Envelopes.transform(bbox, DefaultGeographicCRS.WGS84));
            }
        }
        catch (TransformException ex) {
            throw new RuntimeException("Failed to create WGS84 envelope.", ex);
        }
        qryParams.put("bbox", Extents.envelopeToString(bbox));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        DOMSource results = new DOMSource(entity);
        ETSAssert.assertEnvelopeIntersectsBoundingBoxes(bbox, results);
    }

    @Test(description="OGC 12-176, Table 6 - Record search")
    public void getMultipleRecordsById() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.recordIdentifiers.get(0));
        StringBuilder paramValue = new StringBuilder();
        paramValue.append((String)idList.get(0)).append(',');
        idList.add(this.recordIdentifiers.get(this.recordIdentifiers.size() - 1));
        paramValue.append((String)idList.get(1));
        qryParams.put("recordIds", paramValue.toString());
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        QName recordName = new QName("http://www.opengis.net/cat/csw/3.0", "SummaryRecord");
        NodeList recordList = entity.getElementsByTagNameNS(recordName.getNamespaceURI(), recordName.getLocalPart());
        Assert.assertEquals(recordList.getLength(), 2, ErrorMessage.format("ResultSetSize", recordName));
        for (int i = 0; i < recordList.getLength(); ++i) {
            Element record = (Element)recordList.item(i);
            NodeList identifiers = record.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/", "identifier");
            List<String> recIdList = XMLUtils.getNodeValues(identifiers);
            recIdList.retainAll(idList);
            Assert.assertFalse(recIdList.isEmpty(), ErrorMessage.format("IdNotFound", Records.getRecordId(record)));
        }
    }

    @Test(description="OGC 12-176, Table 6 - Text search")
    public void singleTermTextSearch() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "full");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String title = this.recordTitles.get(random.nextInt(this.recordTitles.size()));
        while (title.isEmpty()) {
            title = this.recordTitles.get(random.nextInt(this.recordTitles.size()));
        }
        String[] titleWords = title.split("\\s+");
        String keyword = titleWords[titleWords.length - 1];
        keyword = keyword.replaceAll("[()]", "");
        qryParams.put("q", URIUtils.getPercentEncodedString(keyword));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        QName recordName = new QName("http://www.opengis.net/cat/csw/3.0", "Record");
        NodeList recordList = entity.getElementsByTagNameNS(recordName.getNamespaceURI(), recordName.getLocalPart());
        Assert.assertTrue(recordList.getLength() > 0, ErrorMessage.format("EmptyResultSet", recordName));
    }

    @Test(description="Requirements: 086")
    public void getRecordsBySubjectWithoutResults() {
        if (this.recordTopics.isEmpty()) {
            throw new SkipException("No dc:subject elements found in sample records.");
        }
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("maxRecords", "0");
        qryParams.put("elementSetName", "summary");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.recordTopics.size());
        String[] subjectWords = this.recordTopics.get(randomIndex).split("\\s+");
        String subject = subjectWords[subjectWords.length - 1];
        qryParams.put("q", subject);
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Element results = (Element)entity.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SearchResults").item(0);
        Assert.assertNotNull(results, ErrorMessage.format("MissingInfosetItem", "csw:SearchResults"));
        Assert.assertEquals(results.getChildNodes().getLength(), 0, ErrorMessage.format("ResultSetSize", "csw:SummaryRecord"));
        Assert.assertEquals(Integer.parseInt(results.getAttribute("numberOfRecordsReturned")), 0, ErrorMessage.format("InfosetItemValue", "@numberOfRecordsReturned"));
        Assert.assertTrue(Integer.parseInt(results.getAttribute("numberOfRecordsMatched")) > 0, ErrorMessage.format("ConstraintViolation", "numberOfRecordsMatched > 0"));
    }

    @Test(description="OGC 12-176, Table 6 - Text search")
    public void textSearchProducesEmptyResultSet() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "full");
        qryParams.put("q", Records.generateRandomText());
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        ETSAssert.assertEmptyResultSet(entity);
    }

    @Test(description="OGC 12-176, Table 6 - Text search")
    public void multipleTermTextSearch() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        QName titleName = new QName("http://purl.org/dc/elements/1.1/", "title");
        QName subjectName = new QName("http://purl.org/dc/elements/1.1/", "subject");
        String searchTerms = Records.findMatchingSearchTerms(this.datasetInfo.getDataFile(), titleName, subjectName);
        qryParams.put("q", URIUtils.getPercentEncodedString(searchTerms));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        QName recordName = new QName("http://www.opengis.net/cat/csw/3.0", "SummaryRecord");
        NodeList recordList = entity.getElementsByTagNameNS(recordName.getNamespaceURI(), recordName.getLocalPart());
        Assert.assertTrue(recordList.getLength() > 0, ErrorMessage.format("EmptyResultSet", recordName));
    }

    @Test(description="Requirements: Table 6")
    public void getRecordsByBBOXAndTitle() {
        if (null == this.geoExtent) {
            throw new SkipException("Could not determine extent of sample data.");
        }
        int maxRecords = 15;
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        qryParams.put("maxRecords", Integer.toString(maxRecords));
        Envelope bbox = this.geoExtent;
        try {
            if (!bbox.getCoordinateReferenceSystem().equals(DefaultGeographicCRS.WGS84)) {
                bbox = new GeneralEnvelope(Envelopes.transform(bbox, DefaultGeographicCRS.WGS84));
            }
        }
        catch (TransformException ex) {
            throw new RuntimeException("Failed to create WGS84 envelope.", ex);
        }
        qryParams.put("bbox", Extents.envelopeToString(bbox));
        String titleWord = null;
        try {
            XdmValue titles = this.datasetInfo.findItems("//csw:Record[ows:BoundingBox or ows:WGS84BoundingBox]/dc:title", null);
            for (XdmItem title : titles) {
                if (title.getStringValue().isEmpty()) continue;
                String[] titleWords = title.getStringValue().trim().split("\\s+");
                titleWord = titleWords[0];
                break;
            }
        }
        catch (SaxonApiException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        titleWord = titleWord.replaceAll("[()]", "");
        qryParams.put("q", titleWord);
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Element results = (Element)entity.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SearchResults").item(0);
        Assert.assertNotNull(results, ErrorMessage.format("MissingInfosetItem", "csw:SearchResults"));
        String numReturned = results.getAttribute("numberOfRecordsReturned");
        Assert.assertTrue(Integer.parseInt(numReturned) <= maxRecords, ErrorMessage.format("ConstraintViolation", "numberOfRecordsReturned <= maxRecords"));
        ETSAssert.assertEnvelopeIntersectsBoundingBoxes(bbox, new DOMSource(results));
        QName recordName = new QName("http://www.opengis.net/cat/csw/3.0", "SummaryRecord");
        NodeList recordList = results.getElementsByTagNameNS(recordName.getNamespaceURI(), recordName.getLocalPart());
        Assert.assertTrue(recordList.getLength() > 0, ErrorMessage.format("EmptyResultSet", recordName));
        ETSAssert.assertAllTermsOccur(recordList, titleWord);
    }
}

