/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.OpenSearchTemplateUtils;
import org.opengis.cite.cat30.util.Records;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.URIUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpenSearchCoreTests
extends CommonFixture {
    private String searchTerm;
    private static final QName SEARCH_TERMS_PARAM = new QName("http://a9.com/-/spec/opensearch/1.1/", "searchTerms");
    private Document openSearchDescr;
    private List<Node> templates;
    private List<Node> searchTermsTemplates;
    private DatasetInfo datasetInfo;
    private List<String> recordTitles;

    void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    @BeforeClass
    public void initOpenSearchCoreTestsFixture(ITestContext testContext) {
        this.openSearchDescr = (Document)testContext.getSuite().getAttribute(SuiteAttribute.OPENSEARCH_DESCR.getName());
        if (null == this.openSearchDescr) {
            throw new SkipException("OpenSearch description not found in test context.");
        }
        this.templates = ServiceMetadataUtils.getOpenSearchURLTemplates(this.openSearchDescr);
        QName searchTermsParam = new QName("http://a9.com/-/spec/opensearch/1.1/", "searchTerms");
        this.searchTermsTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.templates, searchTermsParam);
        DatasetInfo dataset = (DatasetInfo)testContext.getSuite().getAttribute(SuiteAttribute.DATASET.getName());
        if (null == dataset) {
            throw new SkipException("Dataset info not found in test context.");
        }
        this.datasetInfo = dataset;
        this.recordTitles = dataset.getRecordTitles();
    }

    @Test(description="OGC 12-176, Table 6: Text search")
    public void keywordSearch_emptyResultSet() {
        if (this.searchTermsTemplates.isEmpty()) {
            throw new AssertionError((Object)"No URL templates containing {searchTerms} parameter.");
        }
        HashMap<QName, String> values = new HashMap<QName, String>();
        values.put(SEARCH_TERMS_PARAM, Records.generateRandomText());
        for (Node template : this.searchTermsTemplates) {
            Element urlElem = (Element)template;
            String mediaType = urlElem.getAttribute("type");
            if (!mediaType.contains("xml")) continue;
            URI targetURI = OpenSearchTemplateUtils.buildRequestURI(urlElem, values);
            this.request = ClientUtils.buildGetRequest(targetURI, null, MediaType.valueOf(mediaType));
            this.response = this.client.handle(this.request);
            Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
            Document entity = this.getResponseEntityAsDocument(this.response, null);
            ETSAssert.assertEmptyResultSet(entity);
        }
    }

    @Test(description="OGC 12-176, Table 6: Text search")
    public void singleKeywordSearch() {
        if (this.searchTermsTemplates.isEmpty()) {
            throw new AssertionError((Object)"No URL templates containing {searchTerms} parameter.");
        }
        if (null == this.searchTerm || this.searchTerm.isEmpty()) {
            this.searchTerm = this.randomlySelectTitleWord(this.recordTitles);
        }
        HashMap<QName, String> values = new HashMap<QName, String>();
        values.put(SEARCH_TERMS_PARAM, URIUtils.getPercentEncodedString(this.searchTerm));
        for (Node template : this.searchTermsTemplates) {
            NodeList records;
            Element urlElem = (Element)template;
            try {
                records = this.invokeQuery(urlElem, values);
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
            Assert.assertTrue(records.getLength() > 0, ErrorMessage.format("EmptyResultSet", Records.getRecordName(urlElem.getAttribute("type"))));
            Document entity = this.getResponseEntityAsDocument(this.response, null);
            if (!entity.getDocumentElement().getNamespaceURI().equals("http://www.w3.org/2005/Atom")) continue;
            URL schemaUrl = this.getClass().getResource("/org/opengis/cite/cat30/sch/atom-feed.sch");
            ETSAssert.assertSchematronValid(schemaUrl, new DOMSource(entity));
        }
    }

    @Test(description="OGC 12-176, Table 6: Text search")
    public void multipleKeywordSearch() {
        if (this.searchTermsTemplates.isEmpty()) {
            throw new AssertionError((Object)"No URL templates containing {searchTerms} parameter.");
        }
        QName titleName = new QName("http://purl.org/dc/elements/1.1/", "title");
        QName subjectName = new QName("http://purl.org/dc/elements/1.1/", "subject");
        String searchTerms = Records.findMatchingSearchTerms(this.datasetInfo.getDataFile(), titleName, subjectName);
        HashMap<QName, String> params = new HashMap<QName, String>();
        params.put(SEARCH_TERMS_PARAM, URIUtils.getPercentEncodedString(searchTerms));
        for (Node template : this.searchTermsTemplates) {
            NodeList records;
            Element urlElem = (Element)template;
            try {
                records = this.invokeQuery(urlElem, params);
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
            Assert.assertTrue(records.getLength() > 0, ErrorMessage.format("EmptyResultSet", Records.getRecordName(urlElem.getAttribute("type"))));
        }
    }

    @Test(description="Requirements: 022,023")
    public void sliceResults() {
        QName countParam = new QName("http://a9.com/-/spec/opensearch/1.1/", "count");
        List<Node> templatesWithCountParam = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.templates, countParam);
        if (templatesWithCountParam.isEmpty()) {
            throw new AssertionError((Object)"No URL templates containing {count} parameter.");
        }
        int count = 4;
        HashMap<QName, String> params = new HashMap<QName, String>();
        params.put(countParam, Integer.toString(count));
        QName startIndexParam = new QName("http://a9.com/-/spec/opensearch/1.1/", "startIndex");
        int startIndex = 3;
        params.put(startIndexParam, Integer.toString(startIndex));
        block10: for (Node template : templatesWithCountParam) {
            String namespaceURI;
            NodeList records;
            Element urlTemplate = (Element)template;
            try {
                records = this.invokeQuery(urlTemplate, params);
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
            Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
            Assert.assertTrue(records.getLength() > 0, ErrorMessage.get("EmptyResultSet"));
            Document entity = this.getResponseEntityAsDocument(this.response, null);
            switch (namespaceURI = entity.getDocumentElement().getNamespaceURI()) {
                case "http://www.w3.org/2005/Atom": {
                    Node itemsPerPage = entity.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "itemsPerPage").item(0);
                    Assert.assertNotNull(itemsPerPage, ErrorMessage.format("MissingInfosetItem", "os:itemsPerPage"));
                    Assert.assertEquals(Integer.parseInt(itemsPerPage.getTextContent()), count, ErrorMessage.format("InfosetItemValue", "os:itemsPerPage"));
                    Node startIndexNode = entity.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "startIndex").item(0);
                    Assert.assertNotNull(startIndexNode, ErrorMessage.format("MissingInfosetItem", "os:startIndex"));
                    Assert.assertEquals(Integer.parseInt(startIndexNode.getTextContent()), startIndex, ErrorMessage.format("InfosetItemValue", "os:startIndex"));
                    continue block10;
                }
                case "http://www.opengis.net/cat/csw/3.0": {
                    Node resultsNode = entity.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SearchResults").item(0);
                    Assert.assertNotNull(resultsNode, ErrorMessage.format("MissingInfosetItem", "csw:SearchResults"));
                    Element results = (Element)resultsNode;
                    int nRecordsReturned = Integer.parseInt(results.getAttribute("numberOfRecordsReturned"));
                    Assert.assertEquals(nRecordsReturned, count, ErrorMessage.format("InfosetItemValue", "@numberOfRecordsReturned"));
                    int nextRecord = Integer.parseInt(results.getAttribute("nextRecord"));
                    Assert.assertEquals(nextRecord, startIndex + count, ErrorMessage.format("InfosetItemValue", "@nextRecord"));
                    continue block10;
                }
            }
            throw new SkipException("Unrecognized namespace: " + namespaceURI);
        }
    }

    @Test(description="OpenSearchDescription: Query element")
    public void executeExampleQueries() {
        List<Node> exampleQueryList = ServiceMetadataUtils.getOpenSearchQueriesByRole(this.openSearchDescr, new QName("http://a9.com/-/spec/opensearch/1.1/", "example"));
        if (exampleQueryList.isEmpty()) {
            throw new SkipException("No example queries found in OpenSearch description.");
        }
        for (Node query : exampleQueryList) {
            Map<QName, String> params = OpenSearchTemplateUtils.getQueryParameters(query);
            List<Node> qryTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.templates, params.keySet().iterator().next());
            for (Node template : qryTemplates) {
                NodeList records;
                Element qryTemplate = (Element)template;
                try {
                    records = this.invokeQuery(qryTemplate, params);
                }
                catch (UnsupportedOperationException e) {
                    continue;
                }
                Assert.assertEquals(this.response.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
                Assert.assertTrue(records.getLength() > 0, ErrorMessage.format("EmptyResultSet", Records.getRecordName(qryTemplate.getAttribute("type"))));
            }
        }
    }

    NodeList invokeQuery(Element qryTemplate, Map<QName, String> parameters) {
        String mediaType = qryTemplate.getAttribute("type");
        if (!mediaType.contains("xml")) {
            throw new UnsupportedOperationException("URL template does not produce XML results: " + mediaType);
        }
        URI targetURI = OpenSearchTemplateUtils.buildRequestURI(qryTemplate, parameters);
        TestSuiteLogger.log(Level.FINE, "invokeQuery target URI: " + targetURI);
        this.request = ClientUtils.buildGetRequest(targetURI, null, MediaType.valueOf(mediaType));
        this.response = this.client.handle(this.request);
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        QName recordName = Records.getRecordName(mediaType);
        NodeList records = entity.getElementsByTagNameNS(recordName.getNamespaceURI(), recordName.getLocalPart());
        return records;
    }

    String randomlySelectTitleWord(List<String> titles) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String title = titles.get(random.nextInt(titles.size()));
        while (title.isEmpty()) {
            title = titles.get(random.nextInt(titles.size()));
        }
        String[] titleWords = title.split("\\s+");
        String word = titleWords[titleWords.length - 1];
        word = word.replaceAll("[()]", "");
        return word;
    }
}

