/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.OperationType;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Progress;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="MI_Operation_Type", propOrder={"description", "citation", "identifier", "status", "type", "childOperations", "objectives", "parentOperation", "plan", "platforms", "significantEvents"})
@XmlRootElement(name="MI_Operation")
public class DefaultOperation
extends MetadataEntity
implements Operation {
    private static final long serialVersionUID = -4247450339144267883L;
    private InternationalString description;
    private Citation citation;
    private Progress status;
    private OperationType type;
    private Collection<Operation> childOperations;
    private Collection<Objective> objectives;
    private Operation parentOperation;
    private Plan plan;
    private Collection<Platform> platforms;
    private Collection<Event> significantEvents;

    public DefaultOperation() {
    }

    public DefaultOperation(Operation operation) {
        super(operation);
    }

    public static DefaultOperation castOrCopy(Operation operation) {
        return operation == null || operation instanceof DefaultOperation ? (DefaultOperation)operation : new DefaultOperation(operation);
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="citation")
    public synchronized Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    public synchronized void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        NonMarshalledAuthority.setMarshallable(super.getIdentifiers(), identifier);
    }

    @Override
    @XmlElement(name="status", required=true)
    public synchronized Progress getStatus() {
        return this.status;
    }

    public synchronized void setStatus(Progress progress) {
        this.checkWritePermission();
        this.status = progress;
    }

    @Override
    @XmlElement(name="type")
    public synchronized OperationType getType() {
        return this.type;
    }

    public synchronized void setType(OperationType operationType) {
        this.checkWritePermission();
        this.type = operationType;
    }

    @XmlElement(name="childOperation")
    public synchronized Collection<Operation> getChildOperations() {
        this.childOperations = this.nonNullCollection(this.childOperations, Operation.class);
        return this.childOperations;
    }

    public synchronized void setChildOperations(Collection<? extends Operation> collection) {
        this.childOperations = this.copyCollection(collection, this.childOperations, Operation.class);
    }

    @XmlElement(name="objective")
    public synchronized Collection<Objective> getObjectives() {
        this.objectives = this.nonNullCollection(this.objectives, Objective.class);
        return this.objectives;
    }

    public synchronized void setObjectives(Collection<? extends Objective> collection) {
        this.objectives = this.copyCollection(collection, this.objectives, Objective.class);
    }

    @Override
    @XmlElement(name="parentOperation", required=true)
    public synchronized Operation getParentOperation() {
        return this.parentOperation;
    }

    public synchronized void setParentOperation(Operation operation) {
        this.checkWritePermission();
        this.parentOperation = operation;
    }

    @Override
    @XmlElement(name="plan")
    public synchronized Plan getPlan() {
        return this.plan;
    }

    public synchronized void setPlan(Plan plan) {
        this.checkWritePermission();
        this.plan = plan;
    }

    @XmlElement(name="platform")
    public synchronized Collection<Platform> getPlatforms() {
        this.platforms = this.nonNullCollection(this.platforms, Platform.class);
        return this.platforms;
    }

    public synchronized void setPlatforms(Collection<? extends Platform> collection) {
        this.platforms = this.copyCollection(collection, this.platforms, Platform.class);
    }

    @XmlElement(name="significantEvent")
    public synchronized Collection<Event> getSignificantEvents() {
        this.significantEvents = this.nonNullCollection(this.significantEvents, Event.class);
        return this.significantEvents;
    }

    public synchronized void setSignificantEvents(Collection<? extends Event> collection) {
        this.significantEvents = this.copyCollection(collection, this.significantEvents, Event.class);
    }
}

