/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import java.util.Collections;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.CSWClient;
import org.opengis.cite.cat30.util.XMLUtils;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.w3c.dom.Document;

public class OpenSearchPreconditions {
    private CSWClient cswClient = new CSWClient();

    void setClient(CSWClient client) {
        this.cswClient = client;
    }

    @BeforeTest
    public void checkOpenSearchImplementationStatus(ITestContext testContext) {
        Document cswCapabilities = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//ows:Constraint[ends-with(@name,'%s')]/ows:DefaultValue", "OpenSearch");
        XdmValue xdmValue = null;
        Map<String, String> nsMap = Collections.singletonMap("http://www.opengis.net/ows/2.0", "ows");
        DOMSource source = new DOMSource(cswCapabilities, cswCapabilities.getDocumentURI());
        try {
            xdmValue = XMLUtils.evaluateXPath2(source, xpath, nsMap);
            if (xdmValue.size() == 0) {
                xpath = String.format("//ows:Constraint[ends-with(@name,'%s')]//ows:Value[1]", "OpenSearch");
                xdmValue = XMLUtils.evaluateXPath2(source, xpath, nsMap);
            }
        }
        catch (SaxonApiException saxonApiException) {
            // empty catch block
        }
        if (xdmValue.size() == 0 || !xdmValue.itemAt(0).getStringValue().trim().equalsIgnoreCase("TRUE")) {
            throw new AssertionError((Object)"OpenSearch not a supported capability.");
        }
        this.cswClient.setServiceDescription(cswCapabilities);
        Document openSearchDescr = this.cswClient.getOpenSearchDescription(null);
        if (null == openSearchDescr) {
            throw new AssertionError((Object)ErrorMessage.get("OpenSearchUnavailable"));
        }
        testContext.getSuite().setAttribute(SuiteAttribute.OPENSEARCH_DESCR.getName(), (Object)openSearchDescr);
    }
}

