/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@Immutable
@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    private static final BursaWolfParameters[] EMPTY_BURSAWOLF = new BursaWolfParameters[0];
    public static final DefaultGeodeticDatum WGS84;
    public static final DefaultGeodeticDatum WGS72;
    public static final DefaultGeodeticDatum SPHERE;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    @XmlElement
    private final Ellipsoid ellipsoid;
    @XmlElement
    private final PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    private DefaultGeodeticDatum() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultGeodeticDatum(GeodeticDatum geodeticDatum) {
        super(geodeticDatum);
        this.ellipsoid = geodeticDatum.getEllipsoid();
        this.primeMeridian = geodeticDatum.getPrimeMeridian();
        this.bursaWolf = geodeticDatum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)geodeticDatum).bursaWolf : null;
    }

    public DefaultGeodeticDatum(String string, Ellipsoid ellipsoid) {
        this(string, ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid) {
        this(map, ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }

    public DefaultGeodeticDatum(String string, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        this(Collections.singletonMap("name", string), ellipsoid, primeMeridian);
    }

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(map);
        BursaWolfParameters[] bursaWolfParametersArray;
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        ArgumentChecks.ensureNonNull((String)"ellipsoid", (Object)ellipsoid);
        ArgumentChecks.ensureNonNull((String)"primeMeridian", (Object)primeMeridian);
        Object obj = map.get(BURSA_WOLF_KEY);
        if (obj instanceof BursaWolfParameters) {
            bursaWolfParametersArray = new BursaWolfParameters[]{((BursaWolfParameters)obj).clone()};
        } else {
            bursaWolfParametersArray = (BursaWolfParameters[])obj;
            if (bursaWolfParametersArray != null) {
                if (bursaWolfParametersArray.length == 0) {
                    bursaWolfParametersArray = null;
                } else {
                    LinkedHashSet<BursaWolfParameters> linkedHashSet = new LinkedHashSet<BursaWolfParameters>();
                    for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
                        linkedHashSet.add(bursaWolfParametersArray[i].clone());
                    }
                    bursaWolfParametersArray = linkedHashSet.toArray(new BursaWolfParameters[linkedHashSet.size()]);
                }
            }
        }
        this.bursaWolf = bursaWolfParametersArray;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum geodeticDatum) {
        return geodeticDatum == null || geodeticDatum instanceof DefaultGeodeticDatum ? (DefaultGeodeticDatum)geodeticDatum : new DefaultGeodeticDatum(geodeticDatum);
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf != null) {
            return (BursaWolfParameters[])this.bursaWolf.clone();
        }
        return EMPTY_BURSAWOLF;
    }

    public BursaWolfParameters getBursaWolfParameters(GeodeticDatum geodeticDatum) {
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                if (!Utilities.deepEquals((Object)geodeticDatum, (Object)bursaWolfParameters.targetDatum, (ComparisonMode)ComparisonMode.IGNORE_METADATA)) continue;
                return bursaWolfParameters.clone();
            }
        }
        return null;
    }

    public static Matrix getAffineTransform(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        return DefaultGeodeticDatum.getAffineTransform(geodeticDatum, geodeticDatum2, null);
    }

    private static XMatrix getAffineTransform(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2, Set<GeodeticDatum> set) {
        Object object;
        int n;
        BursaWolfParameters[] bursaWolfParametersArray;
        ArgumentChecks.ensureNonNull((String)"source", (Object)geodeticDatum);
        ArgumentChecks.ensureNonNull((String)"target", (Object)geodeticDatum2);
        if (geodeticDatum instanceof DefaultGeodeticDatum && (bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum).bursaWolf) != null) {
            for (n = 0; n < bursaWolfParametersArray.length; ++n) {
                object = bursaWolfParametersArray[n];
                if (!Utilities.deepEquals((Object)geodeticDatum2, (Object)((BursaWolfParameters)object).targetDatum, (ComparisonMode)ComparisonMode.IGNORE_METADATA)) continue;
                return ((BursaWolfParameters)object).getAffineTransform();
            }
        }
        if (geodeticDatum2 instanceof DefaultGeodeticDatum && (bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum2).bursaWolf) != null) {
            for (n = 0; n < bursaWolfParametersArray.length; ++n) {
                object = bursaWolfParametersArray[n];
                if (!Utilities.deepEquals((Object)geodeticDatum, (Object)((BursaWolfParameters)object).targetDatum, (ComparisonMode)ComparisonMode.IGNORE_METADATA)) continue;
                XMatrix xMatrix = ((BursaWolfParameters)object).getAffineTransform();
                xMatrix.invert();
                return xMatrix;
            }
        }
        if (geodeticDatum instanceof DefaultGeodeticDatum && geodeticDatum2 instanceof DefaultGeodeticDatum) {
            bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum).bursaWolf;
            BursaWolfParameters[] bursaWolfParametersArray2 = ((DefaultGeodeticDatum)geodeticDatum2).bursaWolf;
            if (bursaWolfParametersArray != null && bursaWolfParametersArray2 != null) {
                for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
                    object = bursaWolfParametersArray[i].targetDatum;
                    for (int j = 0; j < bursaWolfParametersArray2.length; ++j) {
                        GeodeticDatum geodeticDatum3 = bursaWolfParametersArray2[j].targetDatum;
                        if (!Utilities.deepEquals((Object)object, (Object)geodeticDatum3, (ComparisonMode)ComparisonMode.IGNORE_METADATA)) continue;
                        if (set == null) {
                            set = new HashSet<GeodeticDatum>();
                        }
                        if (!set.add(geodeticDatum)) continue;
                        if (set.add(geodeticDatum2)) {
                            XMatrix xMatrix;
                            XMatrix xMatrix2 = DefaultGeodeticDatum.getAffineTransform(geodeticDatum, (GeodeticDatum)object, set);
                            if (xMatrix2 != null && (xMatrix = DefaultGeodeticDatum.getAffineTransform(geodeticDatum3, geodeticDatum2, set)) != null) {
                                xMatrix.multiply(xMatrix2);
                                return xMatrix;
                            }
                            set.remove(geodeticDatum2);
                        }
                        set.remove(geodeticDatum);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isWGS84(Datum datum) {
        if (datum instanceof AbstractIdentifiedObject) {
            return WGS84.equals((AbstractIdentifiedObject)((Object)datum), ComparisonMode.IGNORE_METADATA);
        }
        return datum != null && datum.equals(WGS84);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultGeodeticDatum defaultGeodeticDatum = (DefaultGeodeticDatum)object;
                    return Utilities.equals((Object)this.ellipsoid, (Object)defaultGeodeticDatum.ellipsoid) && Utilities.equals((Object)this.primeMeridian, (Object)defaultGeodeticDatum.primeMeridian) && Arrays.equals(this.bursaWolf, defaultGeodeticDatum.bursaWolf);
                }
            }
            GeodeticDatum geodeticDatum = (GeodeticDatum)object;
            return Utilities.deepEquals((Object)this.getEllipsoid(), (Object)geodeticDatum.getEllipsoid(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getPrimeMeridian(), (Object)geodeticDatum.getPrimeMeridian(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.ellipsoid, (int)Utilities.hash((Object)this.primeMeridian, (int)super.computeHashCode()));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.ellipsoid);
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                if (!DefaultGeodeticDatum.isWGS84(bursaWolfParameters.targetDatum)) continue;
                formatter.append(bursaWolfParameters);
                break;
            }
        }
        return "DATUM";
    }

    static {
        ReferenceIdentifier[] referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS84"), new NamedIdentifier(Citations.ORACLE, "WGS 84"), new NamedIdentifier(null, "WGS_84"), new NamedIdentifier(null, "WGS 1984"), new NamedIdentifier(null, "WGS_1984"), new NamedIdentifier(Citations.ESRI, "D_WGS_1984"), new NamedIdentifier((Citation)Citations.EPSG, "World Geodetic System 1984")};
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("alias", referenceIdentifierArray);
        hashMap.put("identifiers", new NamedIdentifier((Citation)Citations.EPSG, "6326"));
        WGS84 = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.WGS84);
        referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS72"), new NamedIdentifier((Citation)Citations.EPSG, "World Geodetic System 1972")};
        hashMap = new HashMap(6);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("alias", referenceIdentifierArray);
        hashMap.put("identifiers", new NamedIdentifier((Citation)Citations.EPSG, "6322"));
        WGS72 = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.WGS72);
        SPHERE = new DefaultGeodeticDatum(IdentifiedObjects.getProperties(DefaultEllipsoid.SPHERE), (Ellipsoid)DefaultEllipsoid.SPHERE);
    }
}

