/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DirectPositionType", propOrder={"value"})
public class DirectPositionType
implements DirectPosition {
    @XmlValue
    protected List<Double> value;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    protected Integer srsDimension;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    protected String srsName;
    @XmlAttribute
    protected List<String> axisLabels;
    @XmlAttribute
    protected List<String> uomLabels;

    DirectPositionType() {
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<String> axisLabels, List<Double> value, List<String> uomLabels) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
        this.uomLabels = uomLabels;
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<String> axisLabels, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.value = value;
    }

    public DirectPositionType(List<Double> value) {
        this.value = value;
        this.srsDimension = null;
    }

    public DirectPositionType(double ... values) {
        this.value = new ArrayList<Double>();
        double[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double pt = arr$[i$];
            if (pt == null || pt.equals(Double.NaN)) continue;
            this.value.add(pt);
        }
        this.srsDimension = null;
    }

    public DirectPositionType(org.opengis.geometry.DirectPosition position) {
        this(position, true);
    }

    public DirectPositionType(org.opengis.geometry.DirectPosition position, boolean srsInfo) {
        if (position != null) {
            this.value = new ArrayList<Double>();
            for (double d : position.getCoordinate()) {
                this.value.add(d);
            }
            if (srsInfo) {
                CoordinateReferenceSystem crs = position.getCoordinateReferenceSystem();
                if (crs != null) {
                    try {
                        this.srsName = IdentifiedObjects.lookupIdentifier(Citations.URN_OGC, (IdentifiedObject)crs, (boolean)true);
                    }
                    catch (FactoryException ex) {
                        Logging.getLogger(DirectPositionType.class).log(Level.WARNING, null, ex);
                    }
                }
                this.srsDimension = position.getDimension();
            }
        }
    }

    @Override
    public List<Double> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        return this.value;
    }

    public void setValue(List<Double> value) {
        this.value = value;
    }

    public void setValue(Double value) {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        this.value.add(value);
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.decode((String)this.srsName);
            }
            catch (NoSuchAuthorityCodeException ex) {
                Logging.getLogger(DirectPositionType.class).log(Level.WARNING, null, ex);
            }
            catch (FactoryException ex) {
                Logging.getLogger(DirectPositionType.class).log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    public int getDimension() {
        if (this.srsDimension != null) {
            return this.srsDimension;
        }
        return this.value.size();
    }

    public double[] getCoordinate() {
        double[] coords = new double[this.value.size()];
        int n = this.value.size();
        for (int i = 0; i < n; ++i) {
            coords[i] = this.value.get(i);
        }
        return coords;
    }

    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.value.get(dimension);
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.value.remove(dimension);
        this.value.add(dimension, value);
    }

    public org.opengis.geometry.DirectPosition getDirectPosition() {
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[DirectPositionType]:");
        if (this.srsName != null) {
            s.append("srsName = ").append(this.srsName).append('\n');
        }
        if (this.srsDimension != null) {
            s.append(" srsDimension = ").append(this.srsDimension).append('\n');
        }
        if (this.value != null) {
            s.append(" value: ").append('\n');
            for (double v : this.value) {
                s.append(v).append(", ");
            }
        }
        return s.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPositionType) {
            DirectPositionType that = (DirectPositionType)object;
            return Utilities.equals(this.getAxisLabels(), that.getAxisLabels()) && Utilities.equals((Object)this.srsDimension, (Object)that.srsDimension) && Utilities.equals((Object)this.srsName, (Object)that.srsName) && Utilities.equals(this.getUomLabels(), that.getUomLabels()) && Utilities.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.value != null ? ((Object)this.value).hashCode() : 0);
        hash = 71 * hash + (this.srsDimension != null ? this.srsDimension : 0);
        hash = 71 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 71 * hash + (this.axisLabels != null ? ((Object)this.axisLabels).hashCode() : 0);
        hash = 71 * hash + (this.uomLabels != null ? ((Object)this.uomLabels).hashCode() : 0);
        return hash;
    }
}

