/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.Utilities;

@Immutable
public final class Measure
extends Number {
    private static final long serialVersionUID = 6917234039472328164L;
    private final double value;
    private final Unit<?> unit;

    public Measure(double d, Unit<?> unit) {
        this.value = d;
        this.unit = unit;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return Utilities.hash(this.unit, (int)l ^ (int)(l >>> 32));
    }

    public boolean equals(Object object) {
        if (object instanceof Measure) {
            Measure measure = (Measure)object;
            return Utilities.equals(this.value, measure.value) && Utilities.equals(this.unit, measure.unit);
        }
        return false;
    }

    public String toString() {
        String string = String.valueOf(this.value);
        return this.unit != null ? string + ' ' + this.unit : string;
    }
}

