/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.util.Arrays;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Exceptions;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.DualLoggerFactory;
import org.geotoolkit.util.logging.LoggerFactory;
import org.geotoolkit.util.logging.MonolineFormatter;

public final class Logging
extends Static {
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            String string = object instanceof Logging ? ((Logging)object).name : object.toString();
            String string2 = object2 instanceof Logging ? ((Logging)object2).name : object2.toString();
            return string.compareTo(string2);
        }
    };
    private static final Logging[] EMPTY = new Logging[0];
    public static final Logging ALL = new Logging();
    public static final Logging GEOTOOLKIT;
    public final String name;
    private Logging[] children = EMPTY;
    private LoggerFactory<?> factory;
    private static boolean sameLoggerFactory;

    private Logging() {
        this.name = "";
    }

    private Logging(Logging logging, String string) {
        this.name = string;
        this.factory = logging.factory;
        assert (string.startsWith(logging.name)) : string;
    }

    public static void log(Class<?> clazz, String string, LogRecord logRecord) {
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        Logger logger = Logging.getLogger(clazz);
        if (logRecord.getLoggerName() == null) {
            logRecord.setLoggerName(logger.getName());
        }
        logger.log(logRecord);
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        while ((clazz2 = clazz.getEnclosingClass()) != null) {
            clazz = clazz2;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = n >= 1 ? string.substring(0, n) : "";
        return Logging.getLogger(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String string) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            Logging logging;
            Logging logging2 = logging = sameLoggerFactory ? ALL : Logging.getLogging(string, false);
            if (logging != null) {
                Logger logger;
                LoggerFactory<?> loggerFactory = logging.factory;
                assert (Logging.getLogging((String)string, (boolean)false).factory == loggerFactory) : string;
                if (loggerFactory != null && (logger = loggerFactory.getLogger(string)) != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return logger;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logger.getLogger(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logging getLogging(String string) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logging.getLogging(string, true);
        }
    }

    private static Logging getLogging(String string, boolean bl) {
        assert (Thread.holdsLock(EMPTY));
        Logging logging = ALL;
        if (!string.isEmpty()) {
            int n = 0;
            do {
                String string2;
                Logging[] loggingArray;
                int n2;
                if ((n2 = Arrays.binarySearch(loggingArray = logging.children, string2 = (n = string.indexOf(46, n)) >= 0 ? string.substring(0, n) : string, COMPARATOR)) < 0) {
                    if (!bl) break;
                    loggingArray = XArrays.insert(loggingArray, n2 ^= 0xFFFFFFFF, 1);
                    loggingArray[n2] = new Logging(logging, string2);
                    logging.children = loggingArray;
                }
                logging = loggingArray[n2];
            } while (++n != 0);
        }
        return logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Logging[] getChildren() {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Logging[])this.children.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerFactory<?> getLoggerFactory() {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggerFactory(LoggerFactory<?> loggerFactory) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            this.factory = loggerFactory;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].setLoggerFactory(loggerFactory);
            }
            sameLoggerFactory = Logging.sameLoggerFactory(Logging.ALL.children, Logging.ALL.factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean sameLoggerFactory(Logging[] loggingArray, LoggerFactory<?> loggerFactory) {
        assert (Thread.holdsLock(EMPTY));
        for (int i = 0; i < loggingArray.length; ++i) {
            Logging logging = loggingArray[i];
            if (logging.factory == loggerFactory && Logging.sameLoggerFactory(logging.children, loggerFactory)) continue;
            return false;
        }
        return true;
    }

    private static ClassNotFoundException factoryNotFound(String string, NoClassDefFoundError noClassDefFoundError) {
        return new ClassNotFoundException(Errors.format(63, string), noClassDefFoundError);
    }

    public void scanLoggerFactory() {
        LoggerFactory loggerFactory = null;
        for (LoggerFactory loggerFactory2 : ServiceLoader.load(LoggerFactory.class)) {
            if (loggerFactory == null) {
                loggerFactory = loggerFactory2;
                continue;
            }
            loggerFactory = new DualLoggerFactory(loggerFactory, loggerFactory2);
        }
        this.setLoggerFactory(loggerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMonolineConsoleOutput(Level level) {
        Logger logger = Logger.getLogger(this.name);
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            Level level2;
            MonolineFormatter monolineFormatter = MonolineFormatter.configureConsoleHandler(logger, level);
            if (monolineFormatter != null) {
                monolineFormatter.setSourceFormat("class:short");
            }
            if (level != null && ((level2 = logger.getLevel()) == null || level2.intValue() > level.intValue())) {
                logger.setLevel(level);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void flush() {
        for (Logger logger = Logging.getLogger(this.name); logger != null; logger = logger.getParent()) {
            for (Handler handler : logger.getHandlers()) {
                handler.flush();
            }
            if (!logger.getUseParentHandlers()) break;
        }
    }

    public static boolean unexpectedException(Logger logger, Throwable throwable) {
        return Logging.unexpectedException(logger, null, null, throwable, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.WARNING);
    }

    public static boolean unexpectedException(Class<?> clazz, String string, Throwable throwable) {
        return Logging.unexpectedException(null, clazz, string, throwable);
    }

    private static boolean unexpectedException(Logger logger, String string, String string2, Throwable throwable, Level level) {
        Object object;
        if (throwable == null) {
            return false;
        }
        if (logger == null && string != null) {
            int n = string.lastIndexOf(46);
            object = n >= 1 ? string.substring(0, n - 1) : "";
            logger = Logging.getLogger((String)object);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || string == null || string2 == null) {
            String string3 = logger != null ? logger.getName() : null;
            object = throwable.getStackTrace();
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                char c;
                StackTraceElement stackTraceElement = object[i];
                String string4 = stackTraceElement.getClassName();
                if (string != null) {
                    if (!string4.equals(string)) {
                        continue;
                    }
                } else if (string3 != null) {
                    if (!string4.startsWith(string3)) continue;
                    int n = string3.length();
                    if (string4.length() > n && Character.isJavaIdentifierPart(c = (char)string4.charAt(n))) continue;
                }
                String string5 = stackTraceElement.getMethodName();
                if (string2 != null && !string5.equals(string2)) continue;
                if (string3 == null && !(logger = Logging.getLogger(string3 = (c = string4.lastIndexOf(46)) >= '\u0001' ? string4.substring(0, c - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (string == null) {
                    string = string4;
                }
                if (string2 != null) break;
                string2 = string5;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(throwable));
        object = throwable.getLocalizedMessage();
        if (object != null) {
            stringBuilder.append(": ").append((String)object);
        }
        object = stringBuilder.toString();
        object = Exceptions.formatChainedMessages((String)object, throwable);
        LogRecord logRecord = new LogRecord(level, (String)object);
        if (string != null) {
            logRecord.setSourceClassName(string);
        }
        if (string2 != null) {
            logRecord.setSourceMethodName(string2);
        }
        if (level.intValue() > 500) {
            logRecord.setThrown(throwable);
        }
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
        return true;
    }

    public static boolean recoverableException(Class<?> clazz, String string, Throwable throwable) {
        return Logging.recoverableException(null, clazz, string, throwable);
    }

    public static boolean recoverableException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.FINE);
    }

    public static boolean severeException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.SEVERE);
    }

    static {
        ALL.scanLoggerFactory();
        GEOTOOLKIT = Logging.getLogging("org.geotoolkit");
        sameLoggerFactory = true;
    }
}

