/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.math.Complex;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class NewZealandMapGrid
extends UnitaryProjection {
    private static final long serialVersionUID = 8394817836243729133L;
    private static final Complex[] A = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final Complex[] B = new Complex[]{new Complex(1.3231270439, 0.0), new Complex(-0.577245789, -0.007809598), new Complex(0.508307513, -0.112208952), new Complex(-0.15094762, 0.18200602), new Complex(1.01418179, 1.64497696), new Complex(1.9660549, 2.5127645)};
    private static final double[] TPHI = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] TPSI = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        NewZealandMapGrid newZealandMapGrid = new NewZealandMapGrid(parameters);
        return newZealandMapGrid.createConcatenatedTransform();
    }

    protected NewZealandMapGrid(UnitaryProjection.Parameters parameters) {
        super(parameters);
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(true);
        affineTransform.scale(1.0, 2.0626480624709633);
        affineTransform.translate(0.0, -parameters.latitudeOfOrigin);
        this.finish();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        if (dArray2 != null) {
            double d;
            double d2 = d = dArray[n + 1];
            double d3 = 0.0;
            for (int i = 0; i < TPSI.length; ++i) {
                d3 += TPSI[i] * d2;
                d2 *= d;
            }
            Complex complex = new Complex(d3, this.rollLongitude(dArray[n]));
            Complex complex2 = new Complex(complex);
            Complex complex3 = new Complex();
            complex3.multiply(A[0], complex2);
            for (int i = 1; i < A.length; ++i) {
                complex2.multiply(complex2, complex);
                complex3.addMultiply(complex3, A[i], complex2);
            }
            dArray2[n2] = complex3.imag;
            dArray2[n2 + 1] = complex3.real;
        }
        if (bl) {
            throw new ProjectionException(21);
        }
        return null;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        Complex complex = new Complex(dArray[n + 1], dArray[n]);
        Complex complex2 = new Complex(complex);
        Complex complex3 = new Complex();
        complex3.multiply(B[0], complex);
        for (int i = 1; i < B.length; ++i) {
            complex2.multiply(complex2, complex);
            complex3.addMultiply(complex3, B[i], complex2);
        }
        Complex complex4 = new Complex();
        Complex complex5 = new Complex();
        Complex complex6 = new Complex();
        for (int i = 0; i < 3; ++i) {
            int n3;
            complex2.power(complex3, 2);
            complex4.addMultiply(complex, A[1], complex2);
            for (n3 = 2; n3 < A.length; ++n3) {
                complex2.multiply(complex2, complex3);
                complex6.multiply(A[n3], complex2);
                complex6.multiply(complex6, (double)n3);
                complex4.add(complex4, complex6);
            }
            complex2.real = 1.0;
            complex2.imag = 0.0;
            complex5.copy(A[0]);
            for (n3 = 1; n3 < A.length; ++n3) {
                complex2.multiply(complex2, complex3);
                complex6.multiply(A[n3], complex2);
                complex6.multiply(complex6, (double)(n3 + 1));
                complex5.add(complex5, complex6);
            }
            complex3.divide(complex4, complex5);
        }
        double d2 = d = complex3.real;
        double d3 = TPHI[0] * d;
        for (int i = 1; i < TPHI.length; ++i) {
            d3 += TPHI[i] * (d2 *= d);
        }
        dArray2[n2] = this.unrollLongitude(complex3.imag);
        dArray2[n2 + 1] = d3;
    }
}

