/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.opengis.cite.cat30.opensearch.TemplateParamInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OpenSearchTemplateUtils {
    public static QName getTemplateParameterName(String param, Node contextNode) {
        QName paramName;
        String[] qName = param.split(":");
        if (qName.length > 1) {
            String nsPrefix = qName[0];
            String nsURI = contextNode.lookupNamespaceURI(nsPrefix);
            paramName = new QName(nsURI, qName[1].replace("?", ""), nsPrefix);
        } else {
            paramName = new QName("http://a9.com/-/spec/opensearch/1.1/", qName[0].replace("?", ""));
        }
        return paramName;
    }

    public static List<Node> filterURLTemplatesByParam(List<Node> urlTemplates, QName paramName) {
        ArrayList<Node> templates = new ArrayList<Node>();
        block0: for (Node urlTemplate : urlTemplates) {
            List paramList = (List)urlTemplate.getUserData("url.template.params");
            if (null == paramList || paramList.isEmpty()) continue;
            for (TemplateParamInfo paramInfo : paramList) {
                if (!paramInfo.getName().equals(paramName)) continue;
                templates.add(urlTemplate);
                continue block0;
            }
        }
        return templates;
    }

    public static URI buildRequestURI(Element urlElem, Map<QName, String> values) {
        List paramList = (List)urlElem.getUserData("url.template.params");
        Pattern paramPattern = Pattern.compile("\\{([^}]+)\\}");
        String template = urlElem.getAttribute("template");
        Matcher matcher = paramPattern.matcher(template);
        while (matcher.find()) {
            String param = matcher.group(0);
            QName qName = OpenSearchTemplateUtils.getTemplateParameterName(matcher.group(1), urlElem);
            if (values.containsKey(qName)) {
                template = template.replace(param, values.get(qName));
                continue;
            }
            template = template.replace(param, OpenSearchTemplateUtils.getDefaultParamValue(paramList, qName));
        }
        return URI.create(template);
    }

    public static String getDefaultParamValue(List<TemplateParamInfo> paramList, QName paramName) {
        String value = null;
        for (TemplateParamInfo paramInfo : paramList) {
            if (!paramInfo.getName().equals(paramName)) continue;
            value = paramInfo.getDefaultValue().toString();
            break;
        }
        return value;
    }

    public static void updateOpenSearchParameter(TemplateParamInfo paramInfo, Element urlElem) {
        String paramName;
        switch (paramName = paramInfo.getName().getLocalPart()) {
            case "count": {
                paramInfo.setType(Integer.class);
                break;
            }
            case "startIndex": {
                paramInfo.setType(Integer.class);
                String indexOffset = urlElem.getAttribute("indexOffset");
                Integer defaultValue = indexOffset.isEmpty() ? 1 : Integer.decode(indexOffset);
                paramInfo.setDefaultValue(defaultValue);
                break;
            }
            case "startPage": {
                paramInfo.setType(Integer.class);
                String pageOffset = urlElem.getAttribute("pageOffset");
                Integer defaultValue = pageOffset.isEmpty() ? 1 : Integer.decode(pageOffset);
                paramInfo.setDefaultValue(defaultValue);
                break;
            }
            case "language": {
                paramInfo.setType(String.class);
                paramInfo.setDefaultValue("*");
                break;
            }
            case "inputEncoding": 
            case "outputEncoding": {
                paramInfo.setType(Charset.class);
                paramInfo.setDefaultValue(StandardCharsets.UTF_8);
                break;
            }
            default: {
                paramInfo.setType(String.class);
            }
        }
    }

    public static Map<QName, String> getQueryParameters(Node query) {
        HashMap<QName, String> params = new HashMap<QName, String>();
        NamedNodeMap attribs = query.getAttributes();
        List<String> metadataAttribs = Arrays.asList("role", "title", "totalResults");
        for (int i = 0; i < attribs.getLength(); ++i) {
            Node attr = attribs.item(i);
            String attrName = attr.getNodeName();
            if (metadataAttribs.contains(attrName)) continue;
            QName paramName = OpenSearchTemplateUtils.getTemplateParameterName(attrName, query);
            params.put(paramName, attr.getNodeValue());
        }
        return params;
    }
}

