/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext = null;
    private DecimalSymbols decimalFormatSymbols = null;
    private transient String picture = null;
    private SubPicture[] subPictures = null;
    private boolean requireFixup = false;
    private transient boolean checked = false;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        if (this.argument[1] instanceof StringLiteral) {
            this.picture = ((StringLiteral)this.argument[1]).getStringValue();
        }
        if (this.argument.length == 3) {
            if (this.argument[2] instanceof StringLiteral) {
                StructuredQName qName;
                String lexicalName = ((StringLiteral)this.argument[2]).getStringValue();
                try {
                    qName = StructuredQName.fromLexicalQName(lexicalName, false, visitor.getConfiguration().getNameChecker(), env.getNamespaceResolver());
                }
                catch (XPathException e) {
                    XPathException se = new XPathException("Invalid decimal format name. " + e.getMessage());
                    se.setErrorCode("XTDE1280");
                    throw se;
                }
                DecimalFormatManager dfm = ((ExpressionContext)env).getXSLStylesheet().getDecimalFormatManager();
                this.requireFixup = true;
                dfm.registerUsage(qName, this);
            } else {
                this.nsContext = env.getNamespaceResolver();
            }
        } else if (env instanceof ExpressionContext) {
            DecimalFormatManager dfm = ((ExpressionContext)env).getXSLStylesheet().getDecimalFormatManager();
            dfm.registerUsage(DecimalFormatManager.DEFAULT_NAME, this);
        }
    }

    public void fixup(DecimalSymbols dfs) {
        this.requireFixup = false;
        this.decimalFormatSymbols = dfs;
        if (this.picture != null) {
            try {
                this.subPictures = this.getSubPictures(this.picture, dfs);
            }
            catch (XPathException err) {
                this.subPictures = null;
            }
        }
    }

    private SubPicture[] getSubPictures(String picture, DecimalSymbols dfs) throws XPathException {
        int[] picture4 = StringValue.expand(picture);
        SubPicture[] pics = new SubPicture[2];
        if (picture4.length == 0) {
            XPathException err = new XPathException("format-number() picture is zero-length");
            err.setErrorCode("XTDE1310");
            throw err;
        }
        int sep = -1;
        for (int c = 0; c < picture4.length; ++c) {
            if (picture4[c] != dfs.patternSeparator) continue;
            if (c == 0) {
                this.grumble("first subpicture is zero-length");
            } else if (sep >= 0) {
                this.grumble("more than one pattern separator");
            } else if (sep == picture4.length - 1) {
                this.grumble("second subpicture is zero-length");
            }
            sep = c;
        }
        if (sep < 0) {
            pics[0] = new SubPicture(picture4, dfs);
            pics[1] = null;
        } else {
            int[] pic0 = new int[sep];
            System.arraycopy(picture4, 0, pic0, 0, sep);
            int[] pic1 = new int[picture4.length - sep - 1];
            System.arraycopy(picture4, sep + 1, pic1, 0, picture4.length - sep - 1);
            pics[0] = new SubPicture(pic0, dfs);
            pics[1] = new SubPicture(pic1, dfs);
        }
        return pics;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        SubPicture[] pics;
        int numArgs = this.argument.length;
        Controller ctrl = context.getController();
        DecimalSymbols dfs = this.decimalFormatSymbols;
        AtomicValue av0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av0 == null) {
            av0 = DoubleValue.NaN;
        }
        NumericValue number = (NumericValue)av0;
        if (dfs == null) {
            if (this.requireFixup) {
                this.dynamicError("Unknown decimal format name", "XTDE1280", context);
                return null;
            }
            DecimalFormatManager dfm = ctrl.getExecutable().getDecimalFormatManager();
            if (numArgs == 2) {
                dfs = dfm.getDefaultDecimalFormat();
            } else {
                String lexicalName = this.argument[2].evaluateItem(context).getStringValue();
                StructuredQName qName = null;
                try {
                    qName = StructuredQName.fromLexicalQName(lexicalName, false, context.getConfiguration().getNameChecker(), this.nsContext);
                }
                catch (XPathException e) {
                    this.dynamicError("Invalid decimal format name. " + e.getMessage(), "XTDE1280", context);
                }
                dfs = dfm.getNamedDecimalFormat(qName);
                if (dfs == null) {
                    this.dynamicError("format-number function: decimal-format '" + lexicalName + "' is not defined", "XTDE1280", context);
                    return null;
                }
            }
        }
        if ((pics = this.subPictures) == null) {
            String format = this.argument[1].evaluateItem(context).getStringValue();
            pics = this.getSubPictures(format, dfs);
        }
        return this.formatNumber(number, pics, dfs).toString();
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        return new StringValue(this.evaluateAsString(c));
    }

    private CharSequence formatNumber(NumericValue number, SubPicture[] subPictures, DecimalSymbols dfs) {
        SubPicture pic;
        NumericValue absN = number;
        String minusSign = "";
        if (number.signum() < 0.0) {
            absN = number.negate();
            if (subPictures[1] == null) {
                pic = subPictures[0];
                minusSign = "" + FormatNumber.unicodeChar(dfs.minusSign);
            } else {
                pic = subPictures[1];
            }
        } else {
            pic = subPictures[0];
        }
        return pic.format(absN, dfs, minusSign);
    }

    private void grumble(String s2) throws XPathException {
        this.dynamicError("format-number picture: " + s2, "XTDE1310", null);
    }

    public static BigDecimal adjustToDecimal(double value, int precision) {
        String zeros = precision == 1 ? "00000" : "000000000";
        String nines = precision == 1 ? "99999" : "999999999";
        BigDecimal initial = new BigDecimal(value);
        BigDecimal trial = null;
        FastStringBuffer fsb = new FastStringBuffer(20);
        DecimalValue.decimalToString(initial, fsb);
        String s2 = fsb.toString();
        int start = s2.charAt(0) == '-' ? 1 : 0;
        int p = s2.indexOf(".");
        int i = s2.lastIndexOf(zeros);
        if (i > 0) {
            if (p < 0 || i < p) {
                FastStringBuffer sb = new FastStringBuffer(s2.length());
                sb.append(s2.substring(0, i));
                for (int n = i; n < s2.length(); ++n) {
                    sb.append(s2.charAt(n) == '.' ? (char)'.' : '0');
                }
                trial = new BigDecimal(sb.toString());
            } else {
                trial = new BigDecimal(s2.substring(0, i));
            }
        } else {
            i = s2.indexOf(nines);
            if (i >= 0) {
                if (i == start) {
                    FastStringBuffer sb = new FastStringBuffer(s2.length() + 1);
                    if (start == 1) {
                        sb.append('-');
                    }
                    sb.append('1');
                    for (int n = start; n < s2.length(); ++n) {
                        sb.append(s2.charAt(n) == '.' ? (char)'.' : '0');
                    }
                    trial = new BigDecimal(sb.toString());
                } else {
                    while (i >= 0 && (s2.charAt(i) == '9' || s2.charAt(i) == '.')) {
                        --i;
                    }
                    if (i < 0 || s2.charAt(i) == '-') {
                        return initial;
                    }
                    if (p < 0 || i < p) {
                        FastStringBuffer sb = new FastStringBuffer(s2.length());
                        sb.append(s2.substring(0, i));
                        sb.append((char)(s2.charAt(i) + '\u0001'));
                        for (int n = i; n < s2.length(); ++n) {
                            sb.append(s2.charAt(n) == '.' ? (char)'.' : '0');
                        }
                        trial = new BigDecimal(sb.toString());
                    } else {
                        String s22 = s2.substring(0, i) + (char)(s2.charAt(i) + '\u0001');
                        trial = new BigDecimal(s22);
                    }
                }
            }
        }
        if (trial != null && (precision == 1 ? (double)trial.floatValue() == value : trial.doubleValue() == value)) {
            return trial;
        }
        return initial;
    }

    private static CharSequence unicodeChar(int ch) {
        if (ch < 65536) {
            return "" + (char)ch;
        }
        char[] sb = new char[]{(char)((ch -= 65536) / 1024 + 55296), (char)(ch % 1024 + 56320)};
        return new CharSlice(sb, 0, 2);
    }

    private static int[] insert(int[] array, int used, int value, int position) {
        if (used + 1 > array.length) {
            int[] a2 = new int[used + 10];
            System.arraycopy(array, 0, a2, 0, used);
            array = a2;
        }
        for (int i = used - 1; i >= position; --i) {
            array[i + 1] = array[i];
        }
        array[position] = value;
        return array;
    }

    private class SubPicture
    implements Serializable {
        int minWholePartSize = 0;
        int maxWholePartSize = 0;
        int minFractionPartSize = 0;
        int maxFractionPartSize = 0;
        boolean isPercent = false;
        boolean isPerMille = false;
        String prefix = "";
        String suffix = "";
        int[] wholePartGroupingPositions = null;
        int[] fractionalPartGroupingPositions = null;

        public SubPicture(int[] pic, DecimalSymbols dfs) throws XPathException {
            int i;
            int n;
            int percentSign = dfs.percent;
            int perMilleSign = dfs.permill;
            int decimalSeparator = dfs.decimalSeparator;
            int groupingSeparator = dfs.groupingSeparator;
            int digitSign = dfs.digit;
            int zeroDigit = dfs.zeroDigit;
            ArrayList<Integer> wholePartPositions = null;
            ArrayList<Integer> fractionalPartPositions = null;
            boolean foundDigit = false;
            boolean foundDecimalSeparator = false;
            for (int i2 = 0; i2 < pic.length; ++i2) {
                if (pic[i2] != digitSign && pic[i2] != zeroDigit) continue;
                foundDigit = true;
                break;
            }
            if (!foundDigit) {
                FormatNumber.this.grumble("subpicture contains no digit or zero-digit sign");
            }
            int phase = 0;
            block30: for (int i3 = 0; i3 < pic.length; ++i3) {
                int c = pic[i3];
                if (c == percentSign || c == perMilleSign) {
                    if (this.isPercent || this.isPerMille) {
                        FormatNumber.this.grumble("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.isPercent = c == percentSign;
                    this.isPerMille = c == perMilleSign;
                    switch (phase) {
                        case 0: {
                            this.prefix = this.prefix + FormatNumber.unicodeChar(c);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            phase = 5;
                            this.suffix = this.suffix + FormatNumber.unicodeChar(c);
                        }
                    }
                    continue;
                }
                if (c == digitSign) {
                    switch (phase) {
                        case 0: 
                        case 1: {
                            phase = 1;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 2: {
                            FormatNumber.this.grumble("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            phase = 4;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (c == zeroDigit) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            phase = 2;
                            ++this.minWholePartSize;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 3: {
                            ++this.minFractionPartSize;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 4: {
                            FormatNumber.this.grumble("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (c == decimalSeparator) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            phase = 3;
                            foundDecimalSeparator = true;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            if (foundDecimalSeparator) {
                                FormatNumber.this.grumble("There must only be one decimal separator in a sub-picture");
                                break;
                            }
                            FormatNumber.this.grumble("Decimal separator cannot come after a character in the suffix");
                        }
                    }
                    continue;
                }
                if (c == groupingSeparator) {
                    switch (phase) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (wholePartPositions == null) {
                                wholePartPositions = new ArrayList<Integer>(3);
                            }
                            wholePartPositions.add(new Integer(this.maxWholePartSize));
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.maxFractionPartSize == 0) {
                                FormatNumber.this.grumble("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (fractionalPartPositions == null) {
                                fractionalPartPositions = new ArrayList<Integer>(3);
                            }
                            fractionalPartPositions.add(new Integer(this.maxFractionPartSize));
                            break;
                        }
                        case 5: {
                            FormatNumber.this.grumble("Grouping separator found in suffix of sub-picture");
                        }
                    }
                    continue;
                }
                switch (phase) {
                    case 0: {
                        this.prefix = this.prefix + FormatNumber.unicodeChar(c);
                        continue block30;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        phase = 5;
                        this.suffix = this.suffix + FormatNumber.unicodeChar(c);
                    }
                }
            }
            if (wholePartPositions != null) {
                n = wholePartPositions.size();
                this.wholePartGroupingPositions = new int[n];
                for (i = 0; i < n; ++i) {
                    this.wholePartGroupingPositions[i] = this.maxWholePartSize - (Integer)wholePartPositions.get(n - i - 1);
                }
                if (n > 1) {
                    boolean regular = true;
                    int first = this.wholePartGroupingPositions[0];
                    for (int i4 = 1; i4 < n; ++i4) {
                        if (this.wholePartGroupingPositions[i4] == i4 * first) continue;
                        regular = false;
                        break;
                    }
                    if (regular) {
                        this.wholePartGroupingPositions = new int[1];
                        this.wholePartGroupingPositions[0] = first;
                    }
                }
                if (this.wholePartGroupingPositions[0] == 0) {
                    FormatNumber.this.grumble("Cannot have a grouping separator adjacent to the decimal separator");
                }
            }
            if (fractionalPartPositions != null) {
                n = fractionalPartPositions.size();
                this.fractionalPartGroupingPositions = new int[n];
                for (i = 0; i < n; ++i) {
                    this.fractionalPartGroupingPositions[i] = (Integer)fractionalPartPositions.get(i);
                }
            }
        }

        public CharSequence format(NumericValue value, DecimalSymbols dfs, String minusSign) {
            int i;
            int p;
            if (value.isNaN()) {
                return dfs.NaN;
            }
            if ((value instanceof DoubleValue || value instanceof FloatValue) && Double.isInfinite(value.getDoubleValue())) {
                return minusSign + this.prefix + dfs.infinity + this.suffix;
            }
            int multiplier = 1;
            if (this.isPercent) {
                multiplier = 100;
            } else if (this.isPerMille) {
                multiplier = 1000;
            }
            if (multiplier != 1) {
                try {
                    value = (NumericValue)ArithmeticExpression.compute(value, 2, new Int64Value(multiplier), null);
                }
                catch (XPathException e) {
                    value = new DoubleValue(value.getDoubleValue() * (double)multiplier);
                }
            }
            FastStringBuffer sb = new FastStringBuffer(20);
            if (value instanceof DoubleValue || value instanceof FloatValue) {
                BigDecimal dec = FormatNumber.adjustToDecimal(value.getDoubleValue(), 2);
                this.formatDecimal(dec, sb);
            } else if (value instanceof Int64Value || value instanceof BigIntegerValue) {
                this.formatInteger(value, sb);
            } else if (value instanceof DecimalValue) {
                this.formatDecimal(((DecimalValue)value).getDecimalValue(), sb);
            }
            int[] ib = StringValue.expand(sb);
            int ibused = ib.length;
            int point = sb.indexOf('.');
            if (point == -1) {
                point = sb.length();
            } else {
                ib[point] = dfs.decimalSeparator;
                if (this.maxFractionPartSize == 0) {
                    --ibused;
                }
            }
            if (dfs.zeroDigit != 48) {
                int newZero = dfs.zeroDigit;
                for (int i2 = 0; i2 < ibused; ++i2) {
                    int c = ib[i2];
                    if (c < 48 || c > 57) continue;
                    ib[i2] = c - 48 + newZero;
                }
            }
            if (this.wholePartGroupingPositions != null) {
                if (this.wholePartGroupingPositions.length == 1) {
                    int g2 = this.wholePartGroupingPositions[0];
                    for (p = point - g2; p > 0; p -= g2) {
                        ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                    }
                } else {
                    for (i = 0; i < this.wholePartGroupingPositions.length; ++i) {
                        p = point - this.wholePartGroupingPositions[i];
                        if (p <= 0) continue;
                        ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                    }
                }
            }
            if (this.fractionalPartGroupingPositions != null) {
                for (i = 0; i < this.fractionalPartGroupingPositions.length && (p = point + 1 + this.fractionalPartGroupingPositions[i] + i) < ibused - 1; ++i) {
                    ib = FormatNumber.insert(ib, ibused++, dfs.groupingSeparator, p);
                }
            }
            FastStringBuffer res = new FastStringBuffer(this.prefix.length() + minusSign.length() + this.suffix.length() + ibused);
            res.append(minusSign);
            res.append(this.prefix);
            res.append(StringValue.contract(ib, ibused));
            res.append(this.suffix);
            return res;
        }

        private void formatDecimal(BigDecimal dval, FastStringBuffer fsb) {
            int intDigits;
            dval = dval.setScale(this.maxFractionPartSize, 6);
            DecimalValue.decimalToString(dval, fsb);
            int point = fsb.indexOf('.');
            if (point >= 0) {
                for (int zz = this.maxFractionPartSize - this.minFractionPartSize; zz > 0 && fsb.charAt(fsb.length() - 1) == '0'; --zz) {
                    fsb.setLength(fsb.length() - 1);
                }
                intDigits = point;
                if (fsb.charAt(fsb.length() - 1) == '.') {
                    fsb.setLength(fsb.length() - 1);
                }
            } else {
                intDigits = fsb.length();
                if (this.minFractionPartSize > 0) {
                    fsb.append('.');
                    for (int i = 0; i < this.minFractionPartSize; ++i) {
                        fsb.append('0');
                    }
                }
            }
            if (this.minWholePartSize == 0 && intDigits == 1 && fsb.charAt(0) == '0') {
                fsb.removeCharAt(0);
            } else {
                fsb.prependRepeated('0', this.minWholePartSize - intDigits);
            }
        }

        private void formatInteger(NumericValue value, FastStringBuffer fsb) {
            fsb.append(value.getStringValueCS());
            int leadingZeroes = this.minWholePartSize - fsb.length();
            fsb.prependRepeated('0', leadingZeroes);
            if (this.minFractionPartSize != 0) {
                fsb.append('.');
                for (int i = 0; i < this.minFractionPartSize; ++i) {
                    fsb.append('0');
                }
            }
        }
    }
}

