/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.acquisition.EnvironmentalRecord;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="MI_EnvironmentalRecord_Type", propOrder={"averageAirTemperature", "maxRelativeHumidity", "maxAltitude", "meteorologicalConditions"})
@XmlRootElement(name="MI_EnvironmentalRecord")
public class DefaultEnvironmentalRecord
extends MetadataEntity
implements EnvironmentalRecord {
    private static final long serialVersionUID = -8553651678708627947L;
    private Double averageAirTemperature;
    private Double maxRelativeHumidity;
    private Double maxAltitude;
    private InternationalString meteorologicalConditions;

    public DefaultEnvironmentalRecord() {
    }

    public DefaultEnvironmentalRecord(EnvironmentalRecord environmentalRecord) {
        super(environmentalRecord);
    }

    public static DefaultEnvironmentalRecord castOrCopy(EnvironmentalRecord environmentalRecord) {
        return environmentalRecord == null || environmentalRecord instanceof DefaultEnvironmentalRecord ? (DefaultEnvironmentalRecord)environmentalRecord : new DefaultEnvironmentalRecord(environmentalRecord);
    }

    @Override
    @XmlElement(name="averageAirTemperature", required=true)
    public synchronized Double getAverageAirTemperature() {
        return this.averageAirTemperature;
    }

    public synchronized void setAverageAirTemperature(Double d) {
        this.checkWritePermission();
        this.averageAirTemperature = d;
    }

    @Override
    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="maxRelativeHumidity", required=true)
    public synchronized Double getMaxRelativeHumidity() {
        return this.maxRelativeHumidity;
    }

    public synchronized void setMaxRelativeHumidity(Double d) {
        this.checkWritePermission();
        this.maxRelativeHumidity = d;
    }

    @Override
    @XmlElement(name="maxAltitude", required=true)
    public synchronized Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public synchronized void setMaxAltitude(Double d) {
        this.checkWritePermission();
        this.maxAltitude = d;
    }

    @Override
    @XmlElement(name="meteorologicalConditions", required=true)
    public synchronized InternationalString getMeteorologicalConditions() {
        return this.meteorologicalConditions;
    }

    public synchronized void setMeteorologicalConditions(InternationalString internationalString) {
        this.checkWritePermission();
        this.meteorologicalConditions = internationalString;
    }
}

