/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.Identifier3D;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.factory.NoSuchIdentifiedResource;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.EllipsoidalTransform;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@ThreadSafe
public class AuthorityBackedFactory
extends DefaultCoordinateOperationFactory {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private volatile CoordinateOperationAuthorityFactory authorityFactory;
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public AuthorityBackedFactory() {
        this(EMPTY_HINTS);
    }

    public AuthorityBackedFactory(Hints hints) {
        super(hints);
        if (hints == null) {
            hints = EMPTY_HINTS;
        }
        hints = hints.clone();
        hints.keySet().removeAll(this.hints.keySet());
        hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        hints.remove(Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        hints.remove(Hints.FORCE_STANDARD_AXIS_UNITS);
        if (!hints.isEmpty()) {
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
    }

    private static void noForce(Hints hints) {
        hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.before(DefaultCoordinateOperationFactory.class, false);
    }

    protected CoordinateOperationAuthorityFactory getAuthorityFactory() {
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.authorityFactory;
        if (coordinateOperationAuthorityFactory == null) {
            Hints hints = EMPTY_HINTS.clone();
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = coordinateOperationAuthorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
        return coordinateOperationAuthorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransform getMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        this.processing.set(Boolean.TRUE);
        try {
            MathTransform mathTransform = this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
            return mathTransform;
        }
        finally {
            this.processing.set(Boolean.FALSE);
        }
    }

    @Override
    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        if (Boolean.TRUE.equals(this.processing.get())) {
            return null;
        }
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
        CoordinateOperation coordinateOperation = null;
        int n = 0;
        do {
            CoordinateReferenceSystem coordinateReferenceSystem3;
            CoordinateReferenceSystem coordinateReferenceSystem4 = (n & 2) == 0 ? coordinateReferenceSystem : AuthorityBackedFactory.getHorizontalCRS(coordinateReferenceSystem);
            CoordinateReferenceSystem coordinateReferenceSystem5 = coordinateReferenceSystem3 = (n & 1) == 0 ? coordinateReferenceSystem2 : AuthorityBackedFactory.getHorizontalCRS(coordinateReferenceSystem2);
            if (coordinateReferenceSystem4 == null || coordinateReferenceSystem3 == null) continue;
            try {
                coordinateOperation = this.createFromDatabase(coordinateReferenceSystem4, coordinateReferenceSystem3, coordinateOperationAuthorityFactory);
                if (coordinateOperation == null) continue;
                if (n == 0) break;
                coordinateOperation = this.propagateVertical(coordinateOperation, coordinateReferenceSystem4 != coordinateReferenceSystem, coordinateReferenceSystem3 != coordinateReferenceSystem2);
                coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2);
                break;
            }
            catch (FactoryException factoryException) {
                AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                return null;
            }
        } while (++n != 4);
        return coordinateOperation;
    }

    private CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory) throws FactoryException {
        boolean bl;
        Set<CoordinateOperation> set;
        String string;
        Citation citation = coordinateOperationAuthorityFactory.getAuthority();
        ReferenceIdentifier referenceIdentifier = IdentifiedObjects.getIdentifier(coordinateReferenceSystem, citation);
        if (referenceIdentifier == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier2 = IdentifiedObjects.getIdentifier(coordinateReferenceSystem2, citation);
        if (referenceIdentifier2 == null) {
            return null;
        }
        String string2 = referenceIdentifier.getCode().trim();
        if (string2.equals(string = referenceIdentifier2.getCode().trim())) {
            return null;
        }
        try {
            set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string2, string);
            bl = XCollections.isNullOrEmpty(set);
            if (bl && (set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2)) == null) {
                return null;
            }
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            AuthorityBackedFactory.log(Level.FINE, noSuchAuthorityCodeException, coordinateOperationAuthorityFactory, true);
            return null;
        }
        Iterator<CoordinateOperation> iterator = set.iterator();
        while (iterator.hasNext()) {
            CoordinateOperation coordinateOperation;
            block11: {
                try {
                    coordinateOperation = iterator.next();
                    if (coordinateOperation == null) continue;
                    if (!bl) break block11;
                    coordinateOperation = this.inverse(coordinateOperation);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    AuthorityBackedFactory.log(Level.FINE, noninvertibleTransformException, coordinateOperationAuthorityFactory, true);
                    continue;
                }
                catch (FactoryException factoryException) {
                    AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                    continue;
                }
                catch (BackingStoreException backingStoreException) {
                    Throwable throwable = backingStoreException.getCause();
                    AuthorityBackedFactory.log(throwable != null ? throwable : backingStoreException, coordinateOperationAuthorityFactory);
                    continue;
                }
            }
            if (!this.accept(coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2))) continue;
            return coordinateOperation;
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        MathTransform mathTransform;
        MathTransform mathTransform2;
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
        if (!CRS.equalsApproximatively(coordinateReferenceSystem, coordinateReferenceSystem3)) {
            mathTransform2 = this.getMathTransform(coordinateReferenceSystem, coordinateReferenceSystem3);
            coordinateReferenceSystem3 = coordinateReferenceSystem;
        } else {
            mathTransform2 = null;
        }
        if (!CRS.equalsApproximatively(coordinateReferenceSystem4, coordinateReferenceSystem2)) {
            mathTransform = this.getMathTransform(coordinateReferenceSystem4, coordinateReferenceSystem2);
            coordinateReferenceSystem4 = coordinateReferenceSystem2;
        } else {
            mathTransform = null;
        }
        return this.transform(coordinateReferenceSystem3, mathTransform2, coordinateOperation, mathTransform, coordinateReferenceSystem4);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Object object;
        CoordinateOperation[] coordinateOperationArray;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties(coordinateOperation);
        if (coordinateOperation instanceof ConcatenatedOperation && (coordinateOperationArray = (object = ((ConcatenatedOperation)coordinateOperation).getOperations()).toArray(new CoordinateOperation[object.size()])).length != 0) {
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
            if (coordinateOperationArray.length == 1) {
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, mathTransform2, coordinateReferenceSystem2);
            } else {
                CoordinateOperation coordinateOperation3 = coordinateOperationArray[coordinateOperationArray.length - 1];
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS());
                coordinateOperationArray[coordinateOperationArray.length - 1] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2);
            }
            return this.createConcatenatedOperation(map, coordinateOperationArray);
        }
        object = coordinateOperation.getMathTransform();
        coordinateOperationArray = this.getMathTransformFactory();
        if (mathTransform != null) {
            object = coordinateOperationArray.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = coordinateOperationArray.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = null;
        if (coordinateOperation instanceof SingleOperation && (operationMethod = ((SingleOperation)coordinateOperation).getMethod()) != null) {
            Integer n = object.getSourceDimensions();
            Integer n2 = object.getTargetDimensions();
            if (!Utilities.equals(n, operationMethod.getSourceDimensions()) || !Utilities.equals(n2, operationMethod.getTargetDimensions())) {
                operationMethod = new DefaultOperationMethod(operationMethod, n, n2);
            }
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, operationMethod, clazz);
    }

    private CoordinateOperation propagateVertical(CoordinateOperation coordinateOperation, boolean bl, boolean bl2) throws FactoryException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        MathTransform[] mathTransformArray;
        Object object5;
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        if (mathTransform instanceof ConcatenatedTransform) {
            object5 = ((ConcatenatedTransform)mathTransform).getSteps();
            mathTransformArray = object5.toArray(new MathTransform[object5.size()]);
        } else {
            mathTransformArray = new MathTransform[]{mathTransform};
        }
        object5 = null;
        EllipsoidalTransform ellipsoidalTransform = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mathTransformArray.length; ++i) {
            object4 = mathTransformArray[i];
            if (!(object4 instanceof EllipsoidalTransform)) continue;
            ellipsoidalTransform = (EllipsoidalTransform)object4;
            n2 = i;
            if (object5 != null) continue;
            object5 = ellipsoidalTransform;
            n = i;
        }
        Object object6 = coordinateOperation.getSourceCRS();
        object4 = coordinateOperation.getTargetCRS();
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        boolean bl3 = false;
        if (object5 != null) {
            if (n == n2) {
                object2 = object3 = object5.forDimensions(bl, bl2);
            } else {
                object2 = object5.forDimensions(bl, true);
                object3 = ellipsoidalTransform.forDimensions(true, bl2);
            }
            boolean bl4 = false;
            do {
                Object object7;
                int n3;
                int n4;
                int n5;
                Object object8;
                if (!bl4) {
                    object8 = object5;
                    object = object2;
                    n5 = n;
                    n4 = n5 - 1;
                    n3 = n5;
                    object7 = object6;
                } else {
                    object8 = ellipsoidalTransform;
                    object = object3;
                    n5 = n2;
                    n4 = n5 + 1;
                    n3 = mathTransformArray.length - n5 - 1;
                    object7 = object4;
                }
                if (object8 == object) continue;
                MathTransform mathTransform2 = null;
                boolean bl5 = true;
                if (n3 != 0) {
                    Matrix matrix;
                    int n6;
                    int n7;
                    bl5 = n3 == 1;
                    mathTransform2 = mathTransformArray[n4];
                    if (!bl4) {
                        n7 = mathTransform2.getSourceDimensions();
                        n6 = object.getSourceDimensions();
                        if (bl5 &= n6 > n7) {
                            n7 = n6;
                        }
                    } else {
                        n7 = object.getTargetDimensions();
                        if (bl5 &= n7 > (n6 = mathTransform2.getTargetDimensions())) {
                            n6 = n7;
                        }
                    }
                    if ((matrix = Matrices.getMatrix(mathTransform2)) == null || !Matrices.isAffine(matrix)) continue;
                    matrix = Matrices.resizeAffine(matrix, n7, n6);
                    mathTransform2 = mathTransformFactory.createAffineTransform(matrix);
                }
                if (bl5) {
                    if (!(object7 instanceof SingleCRS)) continue;
                    object7 = this.factories.toGeodetic3D((SingleCRS)object7);
                    if (!bl4) {
                        object6 = object7;
                    } else {
                        object4 = object7;
                    }
                }
                mathTransformArray[n5] = object;
                if (mathTransform2 != null) {
                    mathTransformArray[n4] = mathTransform2;
                }
                bl3 = true;
            } while (bl4 = !bl4);
            if (bl3) {
                mathTransform = mathTransformArray[0];
                for (int i = 1; i < mathTransformArray.length; ++i) {
                    mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransformArray[i]);
                }
            }
        } else if (bl && bl2 && mathTransform.getSourceDimensions() == 2 && mathTransform.getTargetDimensions() == 2 && object6 instanceof SingleCRS && object4 instanceof SingleCRS) {
            object6 = this.factories.toGeodetic3D((SingleCRS)object6);
            object4 = this.factories.toGeodetic3D((SingleCRS)object4);
            mathTransform = mathTransformFactory.createPassThroughTransform(0, mathTransform, 1);
            bl3 = true;
        }
        if (bl3) {
            object2 = object6.getCoordinateSystem().getDimension();
            object3 = object4.getCoordinateSystem().getDimension();
            Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
            OperationMethod operationMethod = null;
            if (coordinateOperation instanceof SingleOperation) {
                operationMethod = ((SingleOperation)coordinateOperation).getMethod();
                if (!Utilities.equals(object2, operationMethod.getSourceDimensions()) || !Utilities.equals(object3, operationMethod.getTargetDimensions())) {
                    operationMethod = new DefaultOperationMethod(operationMethod, (Integer)object2, (Integer)object3);
                }
            } else if (coordinateOperation instanceof ConcatenatedOperation) {
                clazz = SingleOperation.class;
                object = new StringBuilder();
                for (SingleOperation singleOperation : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                    String string = IdentifiedObjects.getIdentifier(singleOperation);
                    if (string != null) {
                        if (((StringBuilder)object).length() != 0) {
                            ((StringBuilder)object).append(" + ");
                        }
                        ((StringBuilder)object).append(string);
                    }
                    if (singleOperation instanceof Transformation) {
                        clazz = Transformation.class;
                        continue;
                    }
                    if (!(singleOperation instanceof Conversion) || clazz == Transformation.class) continue;
                    clazz = Conversion.class;
                }
                operationMethod = this.createOperationMethod(Collections.singletonMap("name", Descriptions.format(15, object)), (Integer)object2, (Integer)object3, null);
            }
            coordinateOperation = this.createFromMathTransform(IdentifiedObjects.getProperties(coordinateOperation), (CoordinateReferenceSystem)object6, (CoordinateReferenceSystem)object4, mathTransform, operationMethod, clazz);
        }
        return coordinateOperation;
    }

    private static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        ReferenceIdentifier referenceIdentifier = coordinateReferenceSystem.getName();
        if (referenceIdentifier instanceof Identifier3D) {
            return ((Identifier3D)referenceIdentifier).horizontalCRS;
        }
        return null;
    }

    private static void log(Throwable throwable, AuthorityFactory authorityFactory) {
        AuthorityBackedFactory.log(Level.WARNING, throwable, authorityFactory, throwable instanceof NoSuchIdentifiedResource);
    }

    private static void log(Level level, Throwable throwable, AuthorityFactory authorityFactory, boolean bl) {
        if (LOGGER.isLoggable(level)) {
            LogRecord logRecord = Loggings.format(level, 7, authorityFactory.getAuthority().getTitle());
            logRecord.setSourceClassName(AuthorityBackedFactory.class.getName());
            logRecord.setSourceMethodName("createFromDatabase");
            if (bl) {
                logRecord.setMessage(Loggings.format(logRecord) + ' ' + throwable.getLocalizedMessage());
            } else {
                logRecord.setThrown(throwable);
            }
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    protected boolean accept(CoordinateOperation coordinateOperation) {
        return true;
    }

    @Override
    public ConformanceResult availability() {
        try {
            CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
            if (coordinateOperationAuthorityFactory instanceof Factory) {
                return ((Factory)((Object)coordinateOperationAuthorityFactory)).availability();
            }
        }
        catch (FactoryRegistryException factoryRegistryException) {
            return new Factory.Availability(this, factoryRegistryException);
        }
        return super.availability();
    }
}

