/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.matrix.AffineMatrix3;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.matrix.Matrix4;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class Matrices
extends Static {
    Matrices() {
    }

    public static XMatrix create(int n) {
        switch (n) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(n);
    }

    public static XMatrix create(int n, int n2) {
        if (n == n2) {
            return Matrices.create(n);
        }
        return new GeneralMatrix(n, n2);
    }

    public static XMatrix create(int n, int n2, double[] dArray) {
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException(Errors.format(109));
        }
        if (n == n2) {
            switch (n) {
                case 1: {
                    return new Matrix1(dArray[0]);
                }
                case 2: {
                    return new Matrix2(dArray);
                }
                case 3: {
                    return new Matrix3(dArray);
                }
                case 4: {
                    return new Matrix4(dArray);
                }
            }
        }
        return new GeneralMatrix(n, n2, dArray);
    }

    public static XMatrix createDimensionFilter(int n, int[] nArray) throws IndexOutOfBoundsException {
        int n2 = nArray.length;
        XMatrix xMatrix = Matrices.create(n2 + 1, n + 1);
        xMatrix.setZero();
        for (int i = 0; i < n2; ++i) {
            xMatrix.setElement(i, nArray[i], 1.0);
        }
        xMatrix.setElement(n2, n, 1.0);
        return xMatrix;
    }

    public static XMatrix copy(Matrix matrix) {
        int n = matrix.getNumRow();
        if (n == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }

    public static Matrix getMatrix(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            return ((LinearTransform)mathTransform).getMatrix();
        }
        if (mathTransform instanceof AffineTransform) {
            return new Matrix3((AffineTransform)((Object)mathTransform));
        }
        return null;
    }

    public static XMatrix toXMatrix(Matrix matrix) {
        if (matrix == null || matrix instanceof XMatrix) {
            return (XMatrix)matrix;
        }
        return Matrices.copy(matrix);
    }

    public static XMatrix toOptimalMatrix(Matrix matrix) {
        int n;
        if (matrix != null && (n = matrix.getNumRow()) == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return matrix instanceof Matrix1 ? (Matrix1)matrix : new Matrix1(matrix);
                }
                case 2: {
                    return matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
                }
                case 3: {
                    return matrix instanceof Matrix3 ? (Matrix3)matrix : new Matrix3(matrix);
                }
                case 4: {
                    return matrix instanceof Matrix4 ? (Matrix4)matrix : new Matrix4(matrix);
                }
            }
        }
        return Matrices.toXMatrix(matrix);
    }

    public static GeneralMatrix toGeneralMatrix(Matrix matrix) {
        if (matrix == null || matrix instanceof GeneralMatrix) {
            return (GeneralMatrix)matrix;
        }
        return new GeneralMatrix(matrix);
    }

    public static AffineTransform toAffineTransform(Matrix matrix) throws IllegalArgumentException {
        if (matrix == null || matrix instanceof AffineTransform) {
            return (AffineTransform)((Object)matrix);
        }
        try {
            Matrix3 matrix3;
            if (matrix instanceof Matrix3) {
                matrix3 = (Matrix3)matrix;
            } else {
                if (matrix instanceof GeneralMatrix) {
                    return ((GeneralMatrix)matrix).toAffineTransform2D();
                }
                matrix3 = new Matrix3(matrix);
            }
            return matrix3.toAffineTransform();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    private static AffineMatrix3 toAffineMatrix3(Matrix matrix) throws IllegalStateException {
        AffineTransform affineTransform = Matrices.toAffineTransform(matrix);
        return affineTransform instanceof AffineMatrix3 ? (AffineMatrix3)affineTransform : new AffineMatrix3(affineTransform);
    }

    private static boolean isAffine2D(Matrix matrix) {
        return matrix.getNumRow() == 3 && matrix.getNumCol() == 3 && Matrices.isAffine(matrix);
    }

    public static boolean isAffine(Matrix matrix) {
        if (matrix instanceof AffineTransform) {
            return true;
        }
        if (matrix instanceof XMatrix) {
            return ((XMatrix)matrix).isAffine();
        }
        double d = 1.0;
        int n = matrix.getNumRow() - 1;
        int n2 = matrix.getNumCol();
        while (--n2 >= 0) {
            if (matrix.getElement(n, n2) != d) {
                return false;
            }
            d = 0.0;
        }
        return true;
    }

    public static Matrix resizeAffine(Matrix matrix, int n, int n2) {
        int n3 = matrix.getNumCol() - 1;
        int n4 = matrix.getNumRow() - 1;
        if (n3 != n && n4 != n2) {
            XMatrix xMatrix = Matrices.create(n2 + 1, n + 1);
            int n5 = Math.min(n2, n4);
            int n6 = Math.min(n, n3);
            for (int i = 0; i < n5; ++i) {
                if (i >= n6 && i < n2) {
                    xMatrix.setElement(i, i, 0.0);
                }
                for (int j = 0; j < n6; ++j) {
                    xMatrix.setElement(i, j, matrix.getElement(i, j));
                }
                xMatrix.setElement(i, n, matrix.getElement(i, n3));
            }
            matrix = xMatrix;
        }
        return matrix;
    }

    public static void reverseAxisDirection(Matrix matrix, int n, double d) {
        int n2 = matrix.getNumRow();
        int n3 = matrix.getNumCol() - 1;
        for (int i = 0; i < n2; ++i) {
            double d2 = matrix.getElement(i, n);
            if (d2 == 0.0) continue;
            matrix.setElement(i, n, -d2);
            matrix.setElement(i, n3, matrix.getElement(i, n3) + d2 * d);
        }
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        int n = matrix.getNumRow();
        int n2 = matrix2.getNumCol();
        if (n2 == matrix.getNumCol()) {
            if (Matrices.isAffine2D(matrix) && Matrices.isAffine2D(matrix2)) {
                AffineMatrix3 affineMatrix3 = Matrices.toAffineMatrix3(matrix);
                affineMatrix3.concatenate(Matrices.toAffineTransform(matrix2));
                return affineMatrix3;
            }
            XMatrix xMatrix = Matrices.toOptimalMatrix(matrix);
            xMatrix.multiply(matrix2);
            return xMatrix;
        }
        GeneralMatrix generalMatrix = new GeneralMatrix(n, n2);
        generalMatrix.mul(Matrices.toGeneralMatrix(matrix), Matrices.toGeneralMatrix(matrix2));
        return generalMatrix;
    }

    public static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        int n;
        int n2 = matrix.getNumRow();
        if (n2 < (n = matrix.getNumCol())) {
            int n3;
            int n4 = n - n2;
            int[] nArray = new int[n4];
            int n5 = n;
            block0: while (--n5 >= 0) {
                n3 = n2;
                while (--n3 >= 0) {
                    if (matrix.getElement(n3, n5) == 0.0) continue;
                    continue block0;
                }
                nArray[--n4] = n5;
                if (n4 != 0) continue;
            }
            if (n4 == 0) {
                int n6;
                int n7;
                Matrix matrix2 = Matrices.create(n2);
                n3 = 0;
                for (n7 = 0; n7 < n; ++n7) {
                    if (n4 != nArray.length && n7 == nArray[n4]) {
                        ++n4;
                        continue;
                    }
                    n6 = n2;
                    while (--n6 >= 0) {
                        matrix2.setElement(n6, n3, matrix.getElement(n6, n7));
                    }
                    ++n3;
                }
                matrix2 = Matrices.invertSquare(matrix2);
                XMatrix xMatrix = Matrices.create(n, n2);
                n4 = 0;
                n7 = 0;
                for (n6 = 0; n6 < n; ++n6) {
                    if (n4 != nArray.length && n6 == nArray[n4]) {
                        if (n6 < n2) {
                            xMatrix.setElement(n6, n6, 0.0);
                        }
                        xMatrix.setElement(n6, n2 - 1, Double.NaN);
                        ++n4;
                        continue;
                    }
                    int n8 = n2;
                    while (--n8 >= 0) {
                        xMatrix.setElement(n6, n8, matrix2.getElement(n7, n8));
                    }
                    ++n7;
                }
                return xMatrix;
            }
        }
        return Matrices.invertSquare(matrix);
    }

    static Matrix invertSquare(Matrix object) throws NoninvertibleTransformException {
        Cloneable cloneable;
        int n;
        int n2 = 0;
        int[] nArray = null;
        int n3 = object.getNumCol() - 1;
        int n4 = object.getNumRow() - 1;
        if (Matrices.isAffine((Matrix)object)) {
            int n5;
            int n6;
            int n7 = n4;
            block5: while (--n7 >= 0) {
                for (n6 = n3; n6 >= 0; --n6) {
                    if (!Double.isNaN(object.getElement(n7, n6))) continue;
                    n5 = -1;
                    if (n6 != n3) {
                        n5 = n6;
                        n = n4;
                        while (--n >= 0) {
                            if (n == n7 || object.getElement(n, n6) == 0.0) continue;
                            nArray = null;
                            n2 = 0;
                            break block5;
                        }
                    }
                    n = n3;
                    while (--n >= 0) {
                        if (n == n6 || object.getElement(n7, n) == 0.0) continue;
                        if (n5 >= 0) {
                            nArray = null;
                            n2 = 0;
                            break block5;
                        }
                        n5 = n;
                    }
                    if (nArray == null) {
                        nArray = new int[n4 * 6];
                    }
                    nArray[n2++] = n6;
                    nArray[n2++] = n7;
                    nArray[n2++] = n5;
                }
            }
            for (n7 = 0; n7 < n2; n7 += 3) {
                n6 = nArray[n7];
                n5 = nArray[n7 + 1];
                object.setElement(n5, n6, n6 == n3 ? 0.0 : 1.0);
            }
        }
        Exception exception = null;
        if (Matrices.isAffine2D((Matrix)object)) {
            cloneable = Matrices.toAffineMatrix3((Matrix)object);
            try {
                ((AffineTransform)((Object)cloneable)).invert();
                object = cloneable;
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                exception = noninvertibleTransformException;
            }
        } else {
            cloneable = Matrices.toOptimalMatrix((Matrix)object);
            try {
                cloneable.invert();
                object = cloneable;
            }
            catch (SingularMatrixException singularMatrixException) {
                exception = singularMatrixException;
            }
            catch (MismatchedSizeException mismatchedSizeException) {
                exception = mismatchedSizeException;
            }
        }
        if (exception != null) {
            throw new NoninvertibleTransformException(Errors.format(126), exception);
        }
        int n8 = 0;
        while (n8 < n2) {
            void var7_15 = nArray[n8++];
            n = nArray[n8++];
            int n9 = nArray[n8++];
            if (var7_15 != n3) {
                object.setElement((int)var7_15, n, Double.NaN);
                if (object.getElement((int)var7_15, n4) == 0.0) continue;
                object.setElement((int)var7_15, n4, Double.NaN);
                continue;
            }
            if (n9 < 0) continue;
            object.setElement(n9, n4, Double.NaN);
        }
        return object;
    }

    public static void filterRoundingErrors(XMatrix xMatrix, int n, double d) {
        ArgumentChecks.ensureStrictlyPositive("scale", n);
        ArgumentChecks.ensureStrictlyPositive("tolerance", d);
        d *= (double)n;
        int n2 = xMatrix.getNumRow();
        int n3 = xMatrix.getNumCol();
        double[] dArray = new double[n3 - 1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = xMatrix.getElement(i, j);
            }
            double d2 = XMath.magnitude(dArray) * d;
            for (int j = 0; j < n3; ++j) {
                double d3;
                double d4 = xMatrix.getElement(i, j) * (double)n;
                if (!(Math.abs(d4 - (d3 = Math.rint(d4))) <= d2)) continue;
                xMatrix.setElement(i, j, d3 / (double)n);
            }
        }
    }

    public static boolean equals(Matrix matrix, Matrix matrix2, double d, boolean bl) {
        if (matrix != matrix2) {
            if (matrix == null || matrix2 == null) {
                return false;
            }
            int n = matrix.getNumRow();
            if (n != matrix2.getNumRow()) {
                return false;
            }
            int n2 = matrix.getNumCol();
            if (n2 != matrix2.getNumCol()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d2 = matrix.getElement(i, j);
                    double d3 = matrix2.getElement(i, j);
                    double d4 = d;
                    if (bl) {
                        d4 *= Math.max(Math.abs(d2), Math.abs(d3));
                    }
                    if (Math.abs(d2 - d3) <= d4 || Utilities.equals(d2, d3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean equals(Matrix matrix, Matrix matrix2, ComparisonMode comparisonMode) {
        switch (comparisonMode) {
            case STRICT: {
                return Utilities.equals(matrix, matrix2);
            }
            case BY_CONTRACT: 
            case IGNORE_METADATA: {
                return Matrices.equals(matrix, matrix2, 0.0, false);
            }
            case DEBUG: 
            case APPROXIMATIVE: {
                return Matrices.equals(matrix, matrix2, 1.0E-14, true);
            }
        }
        throw new IllegalArgumentException(Errors.format(260, (Object)comparisonMode));
    }
}

