/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.CSWClient;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeSuite;
import org.w3c.dom.Document;

public class SuitePreconditions {
    @BeforeSuite
    public void verifyTestSubject(ITestContext testContext) {
        Object sutObj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != sutObj && Document.class.isInstance(sutObj)) {
            Document capabilitiesDoc = (Document)sutObj;
            String docElemNamespace = capabilitiesDoc.getDocumentElement().getNamespaceURI();
            Assert.assertEquals(docElemNamespace, "http://www.opengis.net/cat/csw/3.0", "Document element in unexpected namespace;");
            URI getCapabilitiesGET = ServiceMetadataUtils.getOperationEndpoint(capabilitiesDoc, "GetCapabilities", "GET");
            try {
                URL url = getCapabilitiesGET.toURL();
                URLConnection connection = url.openConnection();
                connection.connect();
            }
            catch (IOException iox) {
                throw new AssertionError("Service not available at " + getCapabilitiesGET, iox);
            }
        } else {
            String msg = String.format("Value of test suite attribute %s is missing or is not a DOM Document.", SuiteAttribute.TEST_SUBJECT.getName());
            TestSuiteLogger.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
    }

    @BeforeSuite
    public void fetchSampleData(ITestContext testContext) {
        Document capabilitiesDoc = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        CSWClient cswClient = new CSWClient();
        cswClient.setServiceDescription(capabilitiesDoc);
        File dataFile = cswClient.saveFullRecords(20, MediaType.APPLICATION_XML_TYPE);
        if (!dataFile.isFile()) {
            throw new AssertionError((Object)"Failed to save GetRecords response to temp file.");
        }
        Boolean hasResults = null;
        try {
            hasResults = (Boolean)XMLUtils.evaluateXPath(new StreamSource(dataFile), "//csw:Record", null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        if (!hasResults.booleanValue()) {
            throw new AssertionError((Object)"fetchSampleData: No csw:Record elements found in GetRecords response.");
        }
        TestSuiteLogger.log(Level.INFO, "fetchSampleData: Saved GetRecords response to file: " + dataFile.getAbsolutePath());
        DatasetInfo dataset = new DatasetInfo(dataFile);
        testContext.getSuite().setAttribute(SuiteAttribute.DATASET.getName(), dataset);
    }
}

